/*
 * Decompiled with CFR 0.152.
 */
package dbaut;

import dbaut.GuiUt;
import java.awt.Component;
import java.io.IOException;

public class WebBrowser {
    private static final String WIN_ID = "Windows";
    private static final String WIN_PATH = "rundll32";
    private static final String WIN_FLAG = "url.dll,FileProtocolHandler";
    private static final String UNIX_PATH = "netscape";
    private static final String UNIX_FLAG = "-remote openURL";

    public static void displayURL(Component comp, String url) {
        block6: {
            boolean windows = WebBrowser.isWindowsPlatform();
            String cmd = null;
            try {
                if (windows) {
                    cmd = "rundll32 url.dll,FileProtocolHandler " + url;
                    Process process = Runtime.getRuntime().exec(cmd);
                    break block6;
                }
                cmd = "netscape -remote openURL(" + url + ")";
                Process p = Runtime.getRuntime().exec(cmd);
                try {
                    int exitCode = p.waitFor();
                    if (exitCode != 0) {
                        cmd = "netscape " + url;
                        p = Runtime.getRuntime().exec(cmd);
                    }
                }
                catch (InterruptedException x) {
                    GuiUt.showErrorDlg(comp, x.getMessage(), null);
                    System.err.println("Error bringing up browser, cmd='" + cmd + "'");
                    System.err.println("Caught: " + x);
                }
            }
            catch (IOException x) {
                GuiUt.showErrorDlg(comp, x.getMessage(), null);
                System.err.println("Could not invoke browser, command=" + cmd);
                System.err.println("Caught: " + x);
            }
        }
    }

    public static boolean isWindowsPlatform() {
        String os = System.getProperty("os.name");
        return os != null && os.startsWith(WIN_ID);
    }
}

