/*
 * Decompiled with CFR 0.152.
 */
package dbaut;

import dbaut.CommonDatabaseConnectionInterface;
import dbaut.DbaObject;
import dbaut.GuiUt;
import java.awt.Component;
import java.sql.Connection;
import java.sql.DriverManager;
import java.sql.SQLException;

public class SunCommonDatabaseConnection
implements CommonDatabaseConnectionInterface {
    private Connection dbconn = null;
    private String dbLogin_String = "jdbc:odbc:";
    private String dbDriverName_String = "sun.jdbc.odbc.JdbcOdbcDriver";
    private String dbname = "";
    private String username = "";
    private boolean isConnected = false;
    private Component dlg = null;

    public SunCommonDatabaseConnection(String databaseName, String userName, String password, Component dlg) {
        Object stmt = null;
        Object rs = null;
        try {
            this.dbname = databaseName;
            this.username = userName;
            this.dlg = dlg;
            Class.forName(this.dbDriverName_String);
            this.dbconn = DriverManager.getConnection(this.dbLogin_String + this.dbname, this.username, password);
            this.dbconn.setAutoCommit(true);
            this.isConnected = true;
        }
        catch (SQLException sqle) {
            GuiUt.showSQLException(dlg, null, sqle);
            this.isConnected = false;
        }
        catch (ClassNotFoundException ex) {
            GuiUt.showErrorDlg(dlg, ex.getMessage(), null);
            this.isConnected = false;
        }
        catch (Exception ex) {
            GuiUt.showErrorDlg(dlg, ex.getMessage(), null);
            this.isConnected = false;
        }
        DbaObject.close(rs);
        DbaObject.close(stmt);
    }

    @Override
    public Connection getDbConnection() {
        return this.dbconn;
    }

    @Override
    public void disconnect() {
        try {
            if (this.dbconn != null) {
                this.dbconn.close();
                this.isConnected = false;
            }
        }
        catch (SQLException E) {
            if (E.getErrorCode() == 5307) {
                return;
            }
            GuiUt.showSQLException(this.dlg, null, E);
            this.isConnected = true;
        }
    }

    @Override
    public void setAutoCommit(boolean b) {
        try {
            this.dbconn.setAutoCommit(b);
        }
        catch (SQLException sqle) {
            System.out.println(sqle.getMessage());
        }
    }

    @Override
    public boolean isConnected() {
        return this.isConnected;
    }

    @Override
    public String getDatabaseName() {
        return this.dbname;
    }

    @Override
    public String getUserName() {
        return this.username;
    }
}

