/*
 * Decompiled with CFR 0.152.
 */
package dbaut;

import dbaut.ShowErrorDlg;
import dbaut.ShowInformationDlg;
import dbaut.ShowOptionsDlg;
import dbaut.ShowRetryOptionsDlg;
import dbaut.ShowSimpleErrorDlg;
import dbaut.ShowWarningDlg;
import dbaut.WebBrowser;
import dbaut.dbalib;
import dbaut.editorPanel.SQLTextPane;
import dbaut.locale.LocaleManager;
import dbaut.resource.DBAResourceBundle;
import java.awt.Color;
import java.awt.Component;
import java.awt.Dialog;
import java.awt.Dimension;
import java.awt.Font;
import java.awt.FontMetrics;
import java.awt.Frame;
import java.awt.Point;
import java.awt.Toolkit;
import java.io.IOException;
import java.lang.reflect.Constructor;
import java.sql.SQLException;
import java.util.Vector;
import javax.swing.JDialog;
import javax.swing.JFrame;
import javax.swing.UIManager;
import javax.swing.plaf.FontUIResource;

public final class GuiUt {
    private static ShowSimpleErrorDlg dlg = null;
    private static String javaversion = null;
    public static String JDK13 = "1.3";

    public static void initOutOfMemoryErrorDlg(Component comp, String msg, String moreinfo) {
        dlg = GuiUt.isWindows() ? (comp == null || comp instanceof Frame ? new ShowSimpleErrorDlg((Frame)comp, msg) : (comp instanceof Dialog ? new ShowSimpleErrorDlg((Dialog)comp, msg) : new ShowSimpleErrorDlg((Frame)null, msg))) : (comp == null || comp instanceof Frame ? new ShowSimpleErrorDlg((Frame)comp, "", true, msg) : (comp instanceof Dialog ? new ShowSimpleErrorDlg((Dialog)comp, "", true, msg) : new ShowSimpleErrorDlg((Frame)null, "", true, msg)));
    }

    public static void showOutOfMemoryErrorDlg(OutOfMemoryError e) {
        if (e != null) {
            e.printStackTrace();
        }
        if (dlg == null) {
            System.out.println("no out of memory error dialog has been created");
            return;
        }
        GuiUt.setCenterLocation(dlg.getParent(), dlg);
        dlg.show();
    }

    public static void showErrorDlg(Component comp, String msg, String moreinfo) {
        ShowErrorDlg dlg = null;
        if (GuiUt.isWindows()) {
            if (comp == null) {
                dlg = new ShowErrorDlg((Frame)null, msg, moreinfo);
            } else if (comp instanceof Frame) {
                dlg = new ShowErrorDlg((Frame)comp, msg, moreinfo);
            } else if (comp instanceof JDialog) {
                dlg = new ShowErrorDlg((Dialog)((JDialog)comp), msg, moreinfo);
            }
        } else if (comp == null) {
            dlg = new ShowErrorDlg((Frame)null, "", true, msg, moreinfo);
        } else if (comp instanceof Frame) {
            dlg = new ShowErrorDlg((Frame)comp, "", true, msg, moreinfo);
        } else if (comp instanceof JDialog) {
            dlg = new ShowErrorDlg((JDialog)comp, "", true, msg, moreinfo);
        }
        if (dlg == null) {
            return;
        }
        GuiUt.setCenterLocation(comp, dlg);
        dlg.show();
    }

    public static void showSQLException(Component comp, String msg, SQLException e) {
        DBAResourceBundle res = new DBAResourceBundle("dbaut.dbautproperties.dbaut.Res", LocaleManager.getLocale());
        Component mycomp = comp;
        String mainmsg = null;
        String moremsg = "";
        for (SQLException sqle = e; sqle != null; sqle = sqle.getNextException()) {
            moremsg = moremsg + sqle.getMessage() + "\n";
        }
        if (msg == null || msg.length() == 0) {
            mainmsg = moremsg;
            moremsg = null;
        } else {
            mainmsg = msg;
        }
        GuiUt.showErrorDlg(comp, mainmsg, moremsg);
    }

    public static void showInformationDlg(Component comp, String msg) {
        ShowInformationDlg dlg = null;
        if (GuiUt.isWindows()) {
            if (comp == null) {
                dlg = new ShowInformationDlg((Frame)null, msg);
            }
            if (comp instanceof Frame) {
                dlg = new ShowInformationDlg((Frame)comp, msg);
            } else if (comp instanceof JDialog) {
                dlg = new ShowInformationDlg((JDialog)comp, msg);
            }
        } else {
            if (comp == null) {
                dlg = new ShowInformationDlg((Frame)null, "", true, msg);
            }
            if (comp instanceof Frame) {
                dlg = new ShowInformationDlg((Frame)comp, "", true, msg);
            } else if (comp instanceof JDialog) {
                dlg = new ShowInformationDlg((JDialog)comp, "", true, msg);
            }
        }
        if (dlg == null) {
            return;
        }
        GuiUt.setCenterLocation(comp, dlg);
        dlg.show();
    }

    public static int showOptionDlg(Component comp, String title, String msg) {
        ShowOptionsDlg dlg = null;
        if (GuiUt.isWindows()) {
            if (comp == null || comp instanceof Frame) {
                dlg = new ShowOptionsDlg((Frame)comp, msg, 0);
            } else if (comp instanceof JDialog) {
                dlg = new ShowOptionsDlg((JDialog)comp, msg, 0);
            }
            if (dlg != null && title != null) {
                dlg.setTitle(title);
            }
        } else if (comp == null || comp instanceof Frame) {
            dlg = new ShowOptionsDlg((Frame)comp, title, true, msg, 0);
        } else if (comp instanceof JDialog) {
            dlg = new ShowOptionsDlg((JDialog)comp, title, true, msg, 0);
        }
        if (dlg == null) {
            return 1;
        }
        GuiUt.setCenterLocation(comp, dlg);
        dlg.show();
        int result = dlg.result;
        dlg.dispose();
        return result;
    }

    public static int showOption3Dlg(Component comp, String title, String msg) {
        ShowOptionsDlg dlg = null;
        if (GuiUt.isWindows()) {
            if (comp == null || comp instanceof Frame) {
                dlg = new ShowOptionsDlg((Frame)comp, msg, 1);
            } else if (comp instanceof JDialog) {
                dlg = new ShowOptionsDlg((JDialog)comp, msg, 1);
            }
            if (title != null) {
                dlg.setTitle(title);
            }
        } else if (comp == null || comp instanceof Frame) {
            dlg = new ShowOptionsDlg((Frame)comp, title, true, msg, 1);
        } else if (comp instanceof JDialog) {
            dlg = new ShowOptionsDlg((JDialog)comp, title, true, msg, 1);
        }
        GuiUt.setCenterLocation(comp, dlg);
        dlg.show();
        int result = dlg.result;
        dlg.dispose();
        return result;
    }

    public static int showWarningDlg(Component comp, String title, String msg) {
        ShowWarningDlg dlg = null;
        if (GuiUt.isWindows()) {
            if (comp == null || comp instanceof Frame) {
                dlg = new ShowWarningDlg((Frame)comp, msg, 0);
            } else if (comp instanceof JDialog) {
                dlg = new ShowWarningDlg((JDialog)comp, msg, 0);
            }
            if (dlg != null && title != null) {
                dlg.setTitle(title);
            }
        } else if (comp == null || comp instanceof Frame) {
            dlg = new ShowWarningDlg((Frame)comp, title, true, msg, 0);
        } else if (comp instanceof JDialog) {
            dlg = new ShowWarningDlg((JDialog)comp, title, true, msg, 0);
        }
        if (dlg == null) {
            return 1;
        }
        GuiUt.setCenterLocation(comp, dlg);
        dlg.show();
        int result = dlg.result;
        dlg.dispose();
        return result;
    }

    public static int showRetryOptionsDlg(Component comp, String title, String msg) {
        ShowRetryOptionsDlg dlg = null;
        if (GuiUt.isWindows()) {
            if (comp == null || comp instanceof Frame) {
                dlg = new ShowRetryOptionsDlg((Frame)comp, msg, 0);
            } else if (comp instanceof JDialog) {
                dlg = new ShowRetryOptionsDlg((JDialog)comp, msg, 0);
            }
            if (dlg != null && title != null) {
                dlg.setTitle(title);
            }
        } else if (comp == null || comp instanceof Frame) {
            dlg = new ShowRetryOptionsDlg((Frame)comp, title, true, msg, 0);
        } else if (comp instanceof JDialog) {
            dlg = new ShowRetryOptionsDlg((JDialog)comp, title, true, msg, 0);
        }
        if (dlg == null) {
            return 1;
        }
        GuiUt.setCenterLocation(comp, dlg);
        dlg.show();
        int result = dlg.result;
        dlg.dispose();
        return result;
    }

    public static void setCenterLocation(Component parent, Component child) {
        if (parent != null) {
            int y;
            Dimension screenSize = Toolkit.getDefaultToolkit().getScreenSize();
            Dimension childSize = child.getPreferredSize();
            Dimension parentSize = parent.getSize();
            Point loc = parent.getLocation();
            int x = (parentSize.width - childSize.width) / 2 + loc.x;
            if (x + childSize.width > screenSize.width) {
                x = screenSize.width - childSize.width;
            }
            if (x < 0) {
                x = 0;
            }
            if ((y = (parentSize.height - childSize.height) / 2 + loc.y) + childSize.height > screenSize.height) {
                y = screenSize.height - childSize.height;
            }
            if (y < 0) {
                y = 0;
            }
            child.setLocation(x, y);
        }
    }

    public static Font getDefaultFont() {
        return (Font)UIManager.get("Label.font");
    }

    public static FontMetrics getFontMetrics() {
        JFrame jfm = new JFrame();
        Font defaultFont = (Font)UIManager.get("Label.font");
        if (defaultFont == null) {
            return null;
        }
        return jfm.getFontMetrics(defaultFont);
    }

    public static void initFont() {
        int width;
        UIManager.put("Label.foreground", Color.black);
        Font defaultFont = new Font("Dialog", 0, 12);
        MyComponent cmp = new MyComponent();
        FontMetrics fm = cmp.getFontMetrics(defaultFont);
        char[] checkstr = new char[52];
        for (int i = 0; i < 26; ++i) {
            checkstr[i] = (char)(i + 65);
            checkstr[i + 26] = (char)(i + 97);
        }
        while ((width = fm.charsWidth(checkstr, 0, checkstr.length)) > 380) {
            defaultFont = new Font(defaultFont.getName(), 0, defaultFont.getSize() - 1);
            fm = cmp.getFontMetrics(defaultFont);
        }
        FontUIResource fontUIRes = new FontUIResource(defaultFont);
        UIManager.put("Text.font", fontUIRes);
        UIManager.put("TextField.font", fontUIRes);
        UIManager.put("TextArea.font", fontUIRes);
        UIManager.put("TextPane.font", fontUIRes);
        UIManager.put("List.font", fontUIRes);
        UIManager.put("Table.font", fontUIRes);
        UIManager.put("ComboBox.font", fontUIRes);
        UIManager.put("CheckBox.font", fontUIRes);
        UIManager.put("RadioButton.font", fontUIRes);
        UIManager.put("Button.font", fontUIRes);
        UIManager.put("Label.font", fontUIRes);
        UIManager.put("MenuComponent.font", fontUIRes);
        UIManager.put("Menu.font", fontUIRes);
        UIManager.put("MenuBar.font", fontUIRes);
        UIManager.put("MenuItem.font", fontUIRes);
        UIManager.put("RadioButtonMenuItem.font", fontUIRes);
        UIManager.put("ToolTip.font", fontUIRes);
        UIManager.put("ToggleButton.font", fontUIRes);
        UIManager.put("TitledBorder.font", fontUIRes);
        UIManager.put("PopupMenu.font", fontUIRes);
        UIManager.put("TableHeader.font", fontUIRes);
        UIManager.put("PasswordField.font", fontUIRes);
        UIManager.put("ToolBar.font", fontUIRes);
        UIManager.put("MenuBar.font", fontUIRes);
        UIManager.put("Panel.font", fontUIRes);
        UIManager.put("ProgressBar.font", fontUIRes);
        UIManager.put("TextPane.font", fontUIRes);
        UIManager.put("OptionPane.font", fontUIRes);
        UIManager.put("ScrollPane.font", fontUIRes);
        UIManager.put("EditorPane.font", fontUIRes);
        UIManager.put("ColorChooser.font", fontUIRes);
        UIManager.put("TabbedPane.font", fontUIRes);
    }

    public static int convertByteArrayToInt(byte[] bytearray) {
        dbalib lib = new dbalib();
        int[] intarray = new int[1];
        lib.ByteArrayToInt(intarray, bytearray);
        return intarray[0];
    }

    public static String utTimeToStr(int second) {
        dbalib lib = new dbalib();
        byte[] buffer = new byte[100];
        int rc = lib.utTimeToStr(second, buffer);
        if (rc == 0) {
            return new String(buffer).trim();
        }
        return new String(second + "");
    }

    public static String convertTimeToStr(int second) {
        dbalib lib = new dbalib();
        byte[] buffer = new byte[100];
        int rc = lib.IntToTimeStr(second, buffer);
        if (rc == 0) {
            return new String(buffer).trim();
        }
        return new String(second + "");
    }

    public static int convertStrToTime(String str) {
        if (str == null) {
            return 0;
        }
        dbalib lib = new dbalib();
        int[] ibuffer = new int[1];
        int rc = lib.TimeStrToInt(ibuffer, str.getBytes());
        if (rc == 0) {
            return ibuffer[0];
        }
        return 0;
    }

    public static String convertIntervalToStr(int second) {
        dbalib lib = new dbalib();
        byte[] buffer = new byte[100];
        int rc = lib.IntervalToTimeStr(second, buffer);
        if (rc == 0) {
            return new String(buffer).trim();
        }
        return new String(second + "");
    }

    public static int convertStrToInterval(String str) {
        if (str == null) {
            return 0;
        }
        dbalib lib = new dbalib();
        int[] ibuffer = new int[1];
        int rc = lib.TimeStrToInterval(ibuffer, str.getBytes());
        if (rc == 0) {
            return ibuffer[0];
        }
        return 0;
    }

    public static boolean isWindows() {
        return WebBrowser.isWindowsPlatform();
    }

    public static String mapStringForProperty(String sourceStr, Vector v) {
        String final_str = sourceStr;
        int size = v.size();
        for (int i = 0; i < size; ++i) {
            final_str = GuiUt.mapStringForProperty(final_str, (String)v.elementAt(i));
        }
        return final_str;
    }

    public static String mapStringForProperty(String sourceStr, String[] v) {
        String final_str = sourceStr;
        int size = v.length;
        for (int i = 0; i < size; ++i) {
            final_str = GuiUt.mapStringForProperty(final_str, v[i]);
        }
        return final_str;
    }

    public static String mapStringForProperty(String sourceStr, String replaceStr) {
        return GuiUt.mapStringForProperty(sourceStr, replaceStr, true);
    }

    public static String mapStringForProperty(String sourceStr, String replaceStr, boolean addspace) {
        String returnStr = null;
        if (sourceStr == null) {
            return replaceStr;
        }
        int index = sourceStr.indexOf("%");
        returnStr = index < 0 ? sourceStr + " " + replaceStr : (addspace ? sourceStr.substring(0, index) + " " + replaceStr + " " + sourceStr.substring(index + 1, sourceStr.length()) : sourceStr.substring(0, index) + replaceStr + sourceStr.substring(index + 1, sourceStr.length()));
        return returnStr;
    }

    public static String rightTrim(String str) {
        if (str == null || str.trim().length() == 0) {
            return str;
        }
        String tmp = str.trim();
        int i = str.indexOf(tmp);
        if (i == 0) {
            return tmp;
        }
        if (i > 0) {
            return str.substring(0, i + tmp.length());
        }
        return str;
    }

    public static String getIDString(String str) {
        String s = null;
        s = str.trim().length() > 0 ? GuiUt.rightTrim(str) : str;
        if (s.indexOf(32) >= 0) {
            return "\"" + s + "\"";
        }
        int size = s.length();
        char[] ar = new char[size];
        s.getChars(0, size, ar, 0);
        for (int i = 0; i < size; ++i) {
            if (ar[i] >= 'A' && ar[i] < '[' || ar[i] >= 'a' && ar[i] < '{' || i > 0 && ar[i] >= '0' && ar[i] <= '9') continue;
            s = "\"" + s + "\"";
            break;
        }
        if (SQLTextPane.isKeyword(s)) {
            return "\"" + s + "\"";
        }
        return s;
    }

    public static String singleQuoteHandle(String varName) {
        String tmp = GuiUt.rightTrim(varName);
        byte[] source = tmp.getBytes();
        byte[] dest = new byte[source.length * 2];
        int j = 0;
        int size = source.length;
        for (int i = 0; i < size; ++i) {
            if (source[i] == 39) {
                dest[j++] = 39;
            }
            dest[j++] = source[i];
        }
        return new String(dest, 0, j);
    }

    public static void printByte(String str) {
        System.out.print("str=");
        if (str == null) {
            return;
        }
        byte[] b = str.getBytes();
        int size = b.length;
        for (int i = 0; i < size; ++i) {
            System.out.print(b[i]);
        }
        System.out.println("");
    }

    public static String getJavaVersion() {
        if (javaversion == null) {
            javaversion = System.getProperty("java.version");
        }
        return javaversion;
    }

    public static void startTool(String tool) {
        try {
            String cmd;
            System.out.println("tool string is = " + tool);
            if (GuiUt.isWindows()) {
                String home = System.getProperty("java.home");
                String fileseparator = System.getProperty("file.separator");
                String userdir = System.getProperty("user.dir");
                System.out.println("userdir = " + userdir);
                String exefile = home + fileseparator + "bin" + fileseparator + "javaw";
                if (exefile.indexOf(32) > 0) {
                    exefile = "\"" + exefile + "\"";
                }
                String[] jars = new String[]{"startup.jar", "dmjdbc20.jar", "jhelp.jar", "jtools.jar"};
                String tmp = null;
                String classpath = "";
                int length = jars.length;
                for (int i = 0; i < length; ++i) {
                    tmp = userdir + fileseparator + jars[i];
                    if (tmp.indexOf(32) >= 0) {
                        tmp = "\"" + tmp + "\"";
                    }
                    classpath = classpath.length() == 0 ? tmp : classpath + ";" + tmp;
                }
                cmd = exefile + " -classpath " + classpath + " -Djava.endorsed.dirs=" + userdir + fileseparator + "endorsed " + tool;
            } else {
                cmd = tool;
            }
            System.out.println(cmd);
            Process process = Runtime.getRuntime().exec(cmd);
        }
        catch (IOException ex) {
            System.out.println("Error start " + tool + ": " + ex.getMessage());
        }
    }

    public static Object getNewInstance(String clsname, Class[] paramtypes, Object[] paramvalues) {
        try {
            Class<?> cls = Class.forName(clsname);
            Constructor<?> ctr = cls.getConstructor(paramtypes);
            return ctr.newInstance(paramvalues);
        }
        catch (ClassNotFoundException cnfe) {
            cnfe.printStackTrace();
            System.out.println(cnfe.getMessage());
            return null;
        }
        catch (Exception ex) {
            ex.printStackTrace();
            System.out.println(ex.getMessage());
            return null;
        }
    }

    private static class MyComponent
    extends Component {
        MyComponent() {
        }
    }
}

