/*
 * Decompiled with CFR 0.152.
 */
package dbaut.CommonUt;

import dbaut.GuiUt;
import dbaut.locale.LocaleManager;
import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Font;
import javax.swing.BorderFactory;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JTextArea;
import javax.swing.UIManager;

public class WizardTextArea
extends JPanel {
    private boolean haveText = true;

    public WizardTextArea(String title, String text) {
        this(title, text, true);
    }

    public WizardTextArea(String title, String text, boolean haveText) {
        this.haveText = haveText;
        JLabel label = new JLabel(title);
        Font f = GuiUt.getDefaultFont();
        if (f != null) {
            label.setFont(new Font(f.getName(), 1, f.getSize() + 8));
        } else {
            label.setFont(new Font("Dialog", 1, 20));
        }
        JTextArea textarea = new JTextArea(text);
        textarea.setBackground(UIManager.getColor("Button.background"));
        textarea.setBorder(BorderFactory.createEmptyBorder(0, 0, 0, 4));
        textarea.setEditable(false);
        textarea.setLineWrap(true);
        if (LocaleManager.getLanguageChoice() == 0) {
            textarea.setWrapStyleWord(true);
        } else {
            textarea.setWrapStyleWord(false);
        }
        this.setLayout(new BorderLayout(0, 0));
        this.add((Component)label, "North");
        if (this.haveText) {
            this.add((Component)textarea, "Center");
        }
    }
}

