/*
 * Decompiled with CFR 0.152.
 */
package dbmaker.sql;

import dbmaker.sql.JdbcOdbc;
import dbmaker.sql.JdbcOdbcAPI;
import dbmaker.sql.JdbcOdbcConnection;
import java.util.ResourceBundle;
import javax.transaction.xa.XAException;
import javax.transaction.xa.XAResource;
import javax.transaction.xa.Xid;

public class JdbcOdbcXAResource
extends JdbcOdbc
implements XAResource {
    private JdbcOdbcAPI ODBCOBJ;
    private boolean isClose;
    private long pConstructor;
    private JdbcOdbcConnection _conn = null;

    public JdbcOdbcXAResource(JdbcOdbcConnection jdbcOdbcConnection, long l, JdbcOdbcAPI jdbcOdbcAPI) {
        if (this.needTrace) {
            this.trace("new a XAResource object");
        }
        this.ODBCOBJ = jdbcOdbcAPI;
        this.pConstructor = l;
        this.isClose = false;
        this._conn = jdbcOdbcConnection;
    }

    public void commit(Xid xid, boolean bl) throws XAException {
        if (this.needTrace) {
            this.trace("JdbcOdbcXAResource.commit(" + xid + ", " + bl + ")");
        }
        JdbcOdbcXAResource.checkClosedXA(this.isClose);
        this.ODBCOBJ.jdbcTXSOURCE_commit(this.pConstructor, xid, bl);
    }

    public void end(Xid xid, int n) throws XAException {
        if (this.needTrace) {
            this.trace("JdbcOdbcXAResource.end(" + xid + ", " + n + ")");
        }
        JdbcOdbcXAResource.checkClosedXA(this.isClose);
        this.ODBCOBJ.jdbcTXSOURCE_end(this.pConstructor, xid, n);
    }

    public void forget(Xid xid) throws XAException {
        if (this.needTrace) {
            this.trace("JdbcOdbcXAResource.forget(" + xid + ")");
        }
        JdbcOdbcXAResource.checkClosedXA(this.isClose);
    }

    public int getTransactionTimeout() throws XAException {
        if (this.needTrace) {
            this.trace("JdbcOdbcXAResource.getTransactionTimeout()");
        }
        JdbcOdbcXAResource.checkClosedXA(this.isClose);
        return 0;
    }

    public boolean isSameRM(XAResource xAResource) throws XAException {
        if (this.needTrace) {
            this.trace("JdbcOdbcXAResource.isSameRM(XAResource xares)");
        }
        JdbcOdbcXAResource.checkClosedXA(this.isClose);
        return this.ODBCOBJ.jdbcTXSOURCE_isSameRM(this.pConstructor, ((JdbcOdbcXAResource)xAResource).getConstructor());
    }

    public int prepare(Xid xid) throws XAException {
        if (this.needTrace) {
            this.trace("JdbcOdbcXAResource.prepare(" + xid + ")");
        }
        JdbcOdbcXAResource.checkClosedXA(this.isClose);
        return this.ODBCOBJ.jdbcTXSOURCE_prepare(this.pConstructor, xid);
    }

    public Xid[] recover(int n) throws XAException {
        if (this.needTrace) {
            this.trace("JdbcOdbcXAResource.recover(" + n + ")");
        }
        JdbcOdbcXAResource.checkClosedXA(this.isClose);
        return this.ODBCOBJ.jdbcTXSOURCE_recover(this.pConstructor, n);
    }

    public void rollback(Xid xid) throws XAException {
        if (this.needTrace) {
            this.trace("JdbcOdbcXAResource.rollback(" + xid + ")");
        }
        JdbcOdbcXAResource.checkClosedXA(this.isClose);
        this.ODBCOBJ.jdbcTXSOURCE_rollback(this.pConstructor, xid);
    }

    public boolean setTransactionTimeout(int n) throws XAException {
        if (this.needTrace) {
            this.trace("JdbcOdbcXAResource.setTransactionTimeout(" + n + ")");
        }
        JdbcOdbcXAResource.checkClosedXA(this.isClose);
        return true;
    }

    public void start(Xid xid, int n) throws XAException {
        if (this.needTrace) {
            this.trace("JdbcOdbcXAResource.start(" + xid + ", " + n + ")");
        }
        JdbcOdbcXAResource.checkClosedXA(this.isClose);
        this.ODBCOBJ.jdbcTXSOURCE_start(this.pConstructor, xid, n);
    }

    public long getConstructor() throws XAException {
        if (this.needTrace) {
            this.trace("JdbcOdbcXAResource.getConstructor()");
        }
        JdbcOdbcXAResource.checkClosedXA(this.isClose);
        return this.pConstructor;
    }

    protected static void checkClosedXA(boolean bl) throws XAException {
        if (bl) {
            throw new XAException("the object is closed");
        }
    }

    protected ResourceBundle getResourceBundle() {
        return this._conn.getResourceBundle();
    }
}

