/*
 * Decompiled with CFR 0.152.
 */
package org.msgpack.unpacker;

import java.io.IOException;
import java.nio.ByteBuffer;
import org.msgpack.MessagePack;
import org.msgpack.packer.Unconverter;
import org.msgpack.template.Template;
import org.msgpack.type.Value;
import org.msgpack.unpacker.Unpacker;
import org.msgpack.unpacker.UnpackerIterator;

public abstract class AbstractUnpacker
implements Unpacker {
    protected MessagePack msgpack;
    protected int rawSizeLimit = 0x8000000;
    protected int arraySizeLimit = 0x400000;
    protected int mapSizeLimit = 0x200000;

    /*
     * WARNING - void declaration
     */
    protected AbstractUnpacker(MessagePack msgpack) {
        void var1_1;
        this.msgpack = var1_1;
    }

    @Override
    public ByteBuffer readByteBuffer() throws IOException {
        return ByteBuffer.wrap(this.readByteArray());
    }

    @Override
    public void readArrayEnd() throws IOException {
        this.readArrayEnd(false);
    }

    @Override
    public void readMapEnd() throws IOException {
        this.readMapEnd(false);
    }

    @Override
    public UnpackerIterator iterator() {
        return new UnpackerIterator(this);
    }

    protected abstract void readValue(Unconverter var1) throws IOException;

    @Override
    public Value readValue() throws IOException {
        Unconverter unconverter = new Unconverter(this.msgpack);
        this.readValue(unconverter);
        return unconverter.getResult();
    }

    protected abstract boolean tryReadNil() throws IOException;

    @Override
    public <T> T read(Class<T> klass) throws IOException {
        Template<Object> template;
        if (this.tryReadNil()) {
            return null;
        }
        template = this.msgpack.lookup(template);
        return template.read(this, null);
    }

    /*
     * WARNING - void declaration
     */
    @Override
    public <T> T read(T to) throws IOException {
        void var1_1;
        if (this.tryReadNil()) {
            return null;
        }
        Template<?> template = this.msgpack.lookup(to.getClass());
        return template.read(this, var1_1);
    }

    /*
     * WARNING - void declaration
     */
    @Override
    public <T> T read(Template<T> tmpl) throws IOException {
        void var1_1;
        if (this.tryReadNil()) {
            return null;
        }
        return var1_1.read(this, null);
    }

    /*
     * WARNING - void declaration
     */
    @Override
    public <T> T read(T to, Template<T> tmpl) throws IOException {
        void var1_1;
        void var2_2;
        if (this.tryReadNil()) {
            return null;
        }
        return var2_2.read(this, var1_1);
    }

    @Override
    public int getReadByteCount() {
        throw new UnsupportedOperationException("Not implemented");
    }

    @Override
    public void resetReadByteCount() {
        throw new UnsupportedOperationException("Not implemented");
    }

    /*
     * WARNING - void declaration
     */
    @Override
    public void setRawSizeLimit(int size) {
        void var1_1;
        if (size < 32) {
            this.rawSizeLimit = 32;
            return;
        }
        this.rawSizeLimit = var1_1;
    }

    /*
     * WARNING - void declaration
     */
    @Override
    public void setArraySizeLimit(int size) {
        void var1_1;
        if (size < 16) {
            this.arraySizeLimit = 16;
            return;
        }
        this.arraySizeLimit = var1_1;
    }

    /*
     * WARNING - void declaration
     */
    @Override
    public void setMapSizeLimit(int size) {
        void var1_1;
        if (size < 16) {
            this.mapSizeLimit = 16;
            return;
        }
        this.mapSizeLimit = var1_1;
    }
}

