/*
 * Decompiled with CFR 0.152.
 */
package org.msgpack.template;

import java.io.IOException;
import java.util.HashMap;
import org.msgpack.MessageTypeException;
import org.msgpack.annotation.OrdinalEnum;
import org.msgpack.packer.Packer;
import org.msgpack.template.AbstractTemplate;
import org.msgpack.unpacker.Unpacker;

public class OrdinalEnumTemplate<T>
extends AbstractTemplate<T> {
    protected T[] entries;
    protected HashMap<T, Integer> reverse;
    protected boolean strict;

    /*
     * WARNING - void declaration
     */
    public OrdinalEnumTemplate(Class<T> targetClass) {
        void var1_1;
        this.entries = targetClass.getEnumConstants();
        this.reverse = new HashMap();
        for (int i2 = 0; i2 < this.entries.length; ++i2) {
            this.reverse.put(this.entries[i2], i2);
        }
        this.strict = !targetClass.isAnnotationPresent(OrdinalEnum.class) || var1_1.getAnnotation(OrdinalEnum.class).strict();
    }

    /*
     * WARNING - void declaration
     */
    @Override
    public void write(Packer pk, T target, boolean required) throws IOException {
        void var1_1;
        Integer n2;
        if (target == null) {
            void var3_3;
            if (var3_3 != false) {
                throw new MessageTypeException("Attempted to write null");
            }
            pk.writeNil();
            return;
        }
        if ((n2 = this.reverse.get(n2)) == null) {
            throw new MessageTypeException(new IllegalArgumentException("ordinal: " + n2));
        }
        var1_1.write((int)n2);
    }

    /*
     * WARNING - void declaration
     */
    @Override
    public T read(Unpacker pac, T to, boolean required) throws IOException, MessageTypeException {
        void var1_1;
        if (!required && pac.trySkipNil()) {
            return null;
        }
        int n2 = var1_1.readInt();
        if (n2 < this.entries.length) {
            return this.entries[n2];
        }
        if (!this.strict) {
            return null;
        }
        throw new MessageTypeException(new IllegalArgumentException("ordinal: " + n2));
    }
}

