/*
 * Decompiled with CFR 0.152.
 */
package org.msgpack.packer;

import java.io.IOException;
import java.io.OutputStream;
import java.io.UnsupportedEncodingException;
import java.math.BigInteger;
import java.nio.ByteBuffer;
import org.msgpack.MessagePack;
import org.msgpack.MessageTypeException;
import org.msgpack.io.Output;
import org.msgpack.io.StreamOutput;
import org.msgpack.packer.AbstractPacker;
import org.msgpack.packer.Packer;
import org.msgpack.packer.PackerStack;

public class MessagePackPacker
extends AbstractPacker {
    protected final Output out;
    private PackerStack a = new PackerStack();

    /*
     * WARNING - void declaration
     */
    public MessagePackPacker(MessagePack msgpack, OutputStream stream) {
        this((MessagePack)var1_1, new StreamOutput((OutputStream)var2_2));
        void var2_2;
        void var1_1;
    }

    /*
     * WARNING - void declaration
     */
    protected MessagePackPacker(MessagePack msgpack, Output out) {
        super((MessagePack)var1_1);
        void var2_2;
        void var1_1;
        this.out = var2_2;
    }

    /*
     * WARNING - void declaration
     */
    @Override
    protected void writeByte(byte d2) throws IOException {
        if (d2 < -32) {
            this.out.writeByteAndByte((byte)-48, d2);
        } else {
            void var1_1;
            this.out.writeByte((byte)var1_1);
        }
        this.a.reduceCount();
    }

    /*
     * WARNING - void declaration
     */
    @Override
    protected void writeShort(short d2) throws IOException {
        if (d2 < -32) {
            if (d2 < -128) {
                this.out.writeByteAndShort((byte)-47, d2);
            } else {
                this.out.writeByteAndByte((byte)-48, (byte)d2);
            }
        } else if (d2 < 128) {
            this.out.writeByte((byte)d2);
        } else if (d2 < 256) {
            this.out.writeByteAndByte((byte)-52, (byte)d2);
        } else {
            void var1_1;
            this.out.writeByteAndShort((byte)-51, (short)var1_1);
        }
        this.a.reduceCount();
    }

    /*
     * WARNING - void declaration
     */
    @Override
    protected void writeInt(int d2) throws IOException {
        if (d2 < -32) {
            if (d2 < Short.MIN_VALUE) {
                this.out.writeByteAndInt((byte)-46, d2);
            } else if (d2 < -128) {
                this.out.writeByteAndShort((byte)-47, (short)d2);
            } else {
                this.out.writeByteAndByte((byte)-48, (byte)d2);
            }
        } else if (d2 < 128) {
            this.out.writeByte((byte)d2);
        } else if (d2 < 256) {
            this.out.writeByteAndByte((byte)-52, (byte)d2);
        } else if (d2 < 65536) {
            this.out.writeByteAndShort((byte)-51, (short)d2);
        } else {
            void var1_1;
            this.out.writeByteAndInt((byte)-50, (int)var1_1);
        }
        this.a.reduceCount();
    }

    /*
     * WARNING - void declaration
     */
    @Override
    protected void writeLong(long d2) throws IOException {
        if (d2 < -32L) {
            if (d2 < -32768L) {
                if (d2 < Integer.MIN_VALUE) {
                    this.out.writeByteAndLong((byte)-45, d2);
                } else {
                    this.out.writeByteAndInt((byte)-46, (int)d2);
                }
            } else if (d2 < -128L) {
                this.out.writeByteAndShort((byte)-47, (short)d2);
            } else {
                this.out.writeByteAndByte((byte)-48, (byte)d2);
            }
        } else if (d2 < 128L) {
            this.out.writeByte((byte)d2);
        } else if (d2 < 65536L) {
            if (d2 < 256L) {
                this.out.writeByteAndByte((byte)-52, (byte)d2);
            } else {
                this.out.writeByteAndShort((byte)-51, (short)d2);
            }
        } else if (d2 < 0x100000000L) {
            this.out.writeByteAndInt((byte)-50, (int)d2);
        } else {
            void var1_1;
            this.out.writeByteAndLong((byte)-49, (long)var1_1);
        }
        this.a.reduceCount();
    }

    /*
     * WARNING - void declaration
     */
    @Override
    protected void writeBigInteger(BigInteger d2) throws IOException {
        if (d2.bitLength() <= 63) {
            this.writeLong(d2.longValue());
            this.a.reduceCount();
            return;
        }
        if (d2.bitLength() == 64 && d2.signum() == 1) {
            void var1_1;
            this.out.writeByteAndLong((byte)-49, var1_1.longValue());
            this.a.reduceCount();
            return;
        }
        throw new MessageTypeException("MessagePack can't serialize BigInteger larger than (2^64)-1");
    }

    /*
     * WARNING - void declaration
     */
    @Override
    protected void writeFloat(float d2) throws IOException {
        void var1_1;
        this.out.writeByteAndFloat((byte)-54, (float)var1_1);
        this.a.reduceCount();
    }

    /*
     * WARNING - void declaration
     */
    @Override
    protected void writeDouble(double d2) throws IOException {
        void var1_1;
        this.out.writeByteAndDouble((byte)-53, (double)var1_1);
        this.a.reduceCount();
    }

    @Override
    protected void writeBoolean(boolean d2) throws IOException {
        if (d2) {
            this.out.writeByte((byte)-61);
        } else {
            this.out.writeByte((byte)-62);
        }
        this.a.reduceCount();
    }

    /*
     * WARNING - void declaration
     */
    @Override
    protected void writeByteArray(byte[] b2, int off, int len) throws IOException {
        void var3_3;
        void var2_2;
        void var1_1;
        if (len < 32) {
            this.out.writeByte((byte)(0xA0 | len));
        } else if (len < 65536) {
            this.out.writeByteAndShort((byte)-38, (short)len);
        } else {
            this.out.writeByteAndInt((byte)-37, len);
        }
        this.out.write((byte[])var1_1, (int)var2_2, (int)var3_3);
        this.a.reduceCount();
    }

    /*
     * WARNING - void declaration
     */
    @Override
    protected void writeByteBuffer(ByteBuffer bb) throws IOException {
        int n2 = bb.remaining();
        if (n2 < 32) {
            this.out.writeByte((byte)(0xA0 | n2));
        } else if (n2 < 65536) {
            this.out.writeByteAndShort((byte)-38, (short)n2);
        } else {
            this.out.writeByteAndInt((byte)-37, n2);
        }
        n2 = bb.position();
        try {
            this.out.write(bb);
            bb.position(n2);
        }
        catch (Throwable throwable) {
            void var1_1;
            var1_1.position(n2);
            throw throwable;
        }
        this.a.reduceCount();
    }

    @Override
    protected void writeString(String s2) throws IOException {
        byte[] byArray;
        try {
            byArray = s2.getBytes("UTF-8");
        }
        catch (UnsupportedEncodingException unsupportedEncodingException) {
            throw new MessageTypeException(unsupportedEncodingException);
        }
        this.writeByteArray(byArray, 0, byArray.length);
        this.a.reduceCount();
    }

    @Override
    public Packer writeNil() throws IOException {
        this.out.writeByte((byte)-64);
        this.a.reduceCount();
        return this;
    }

    /*
     * WARNING - void declaration
     */
    @Override
    public Packer writeArrayBegin(int size) throws IOException {
        void var1_1;
        if (size < 16) {
            this.out.writeByte((byte)(0x90 | size));
        } else if (size < 65536) {
            this.out.writeByteAndShort((byte)-36, (short)size);
        } else {
            this.out.writeByteAndInt((byte)-35, size);
        }
        this.a.reduceCount();
        this.a.pushArray((int)var1_1);
        return this;
    }

    @Override
    public Packer writeArrayEnd(boolean check) throws IOException {
        if (!this.a.topIsArray()) {
            throw new MessageTypeException("writeArrayEnd() is called but writeArrayBegin() is not called");
        }
        int n2 = this.a.getTopCount();
        if (n2 > 0) {
            int n3;
            if (n3 != 0) {
                throw new MessageTypeException("writeArrayEnd(check=true) is called but the array is not end: " + n2);
            }
            for (n3 = 0; n3 < n2; ++n3) {
                this.writeNil();
            }
        }
        this.a.pop();
        return this;
    }

    /*
     * WARNING - void declaration
     */
    @Override
    public Packer writeMapBegin(int size) throws IOException {
        void var1_1;
        if (size < 16) {
            this.out.writeByte((byte)(0x80 | size));
        } else if (size < 65536) {
            this.out.writeByteAndShort((byte)-34, (short)size);
        } else {
            this.out.writeByteAndInt((byte)-33, size);
        }
        this.a.reduceCount();
        this.a.pushMap((int)var1_1);
        return this;
    }

    @Override
    public Packer writeMapEnd(boolean check) throws IOException {
        if (!this.a.topIsMap()) {
            throw new MessageTypeException("writeMapEnd() is called but writeMapBegin() is not called");
        }
        int n2 = this.a.getTopCount();
        if (n2 > 0) {
            int n3;
            if (n3 != 0) {
                throw new MessageTypeException("writeMapEnd(check=true) is called but the map is not end: " + n2);
            }
            for (n3 = 0; n3 < n2; ++n3) {
                this.writeNil();
            }
        }
        this.a.pop();
        return this;
    }

    public void reset() {
        this.a.clear();
    }

    @Override
    public void flush() throws IOException {
        this.out.flush();
    }

    @Override
    public void close() throws IOException {
        this.out.close();
    }
}

