/*
 * Decompiled with CFR 0.152.
 */
package javassist.compiler;

import javassist.ClassPool;
import javassist.CtClass;
import javassist.CtField;
import javassist.Modifier;
import javassist.NotFoundException;
import javassist.bytecode.FieldInfo;
import javassist.bytecode.MethodInfo;
import javassist.bytecode.Opcode;
import javassist.compiler.CodeGen;
import javassist.compiler.CompileError;
import javassist.compiler.MemberResolver;
import javassist.compiler.NoFieldException;
import javassist.compiler.TokenId;
import javassist.compiler.ast.ASTList;
import javassist.compiler.ast.ASTree;
import javassist.compiler.ast.ArrayInit;
import javassist.compiler.ast.AssignExpr;
import javassist.compiler.ast.BinExpr;
import javassist.compiler.ast.CallExpr;
import javassist.compiler.ast.CastExpr;
import javassist.compiler.ast.CondExpr;
import javassist.compiler.ast.Declarator;
import javassist.compiler.ast.DoubleConst;
import javassist.compiler.ast.Expr;
import javassist.compiler.ast.InstanceOfExpr;
import javassist.compiler.ast.IntConst;
import javassist.compiler.ast.Keyword;
import javassist.compiler.ast.Member;
import javassist.compiler.ast.NewExpr;
import javassist.compiler.ast.StringL;
import javassist.compiler.ast.Symbol;
import javassist.compiler.ast.Variable;
import javassist.compiler.ast.Visitor;

public class TypeChecker
extends Visitor
implements Opcode,
TokenId {
    protected int exprType;
    protected int arrayDim;
    protected String className;
    protected MemberResolver resolver;
    protected CtClass thisClass;
    protected MethodInfo thisMethod;

    /*
     * WARNING - void declaration
     */
    public TypeChecker(CtClass cc, ClassPool cp) {
        void var1_1;
        void var2_2;
        this.resolver = new MemberResolver((ClassPool)var2_2);
        this.thisClass = var1_1;
        this.thisMethod = null;
    }

    protected static String argTypesToString(int[] types, int[] dims, String[] cnames) {
        StringBuffer stringBuffer = new StringBuffer();
        stringBuffer.append('(');
        int n2 = types.length;
        if (n2 > 0) {
            int n3 = 0;
            while (true) {
                TypeChecker.typeToString(stringBuffer, types[n3], dims[n3], cnames[n3]);
                if (++n3 >= n2) break;
                stringBuffer.append(',');
            }
        }
        stringBuffer.append(')');
        return stringBuffer.toString();
    }

    /*
     * WARNING - void declaration
     */
    protected static StringBuffer typeToString(StringBuffer sbuf, int type, int dim, String cname) {
        StringBuffer stringBuffer;
        void var1_1;
        String string;
        if (type == 307) {
            void var3_4;
            string = MemberResolver.jvmToJavaName((String)var3_4);
        } else if (var1_1 == 412) {
            string = "Object";
        } else {
            try {
                string = MemberResolver.a((int)var1_1);
            }
            catch (CompileError compileError) {
                string = "?";
            }
        }
        sbuf.append(string);
        while (dim-- > 0) {
            sbuf.append("[]");
        }
        return stringBuffer;
    }

    /*
     * WARNING - void declaration
     */
    public void setThisMethod(MethodInfo m2) {
        void var1_1;
        this.thisMethod = var1_1;
    }

    protected static void fatal() throws CompileError {
        throw new CompileError("fatal");
    }

    protected String getThisName() {
        return MemberResolver.javaToJvmName(this.thisClass.getName());
    }

    protected String getSuperName() throws CompileError {
        return MemberResolver.javaToJvmName(MemberResolver.getSuperclass(this.thisClass).getName());
    }

    /*
     * WARNING - void declaration
     */
    protected String resolveClassName(ASTList name) throws CompileError {
        void var1_1;
        return this.resolver.resolveClassName((ASTList)var1_1);
    }

    /*
     * WARNING - void declaration
     */
    protected String resolveClassName(String jvmName) throws CompileError {
        void var1_1;
        return this.resolver.resolveJvmClassName((String)var1_1);
    }

    @Override
    public void atNewExpr(NewExpr expr) throws CompileError {
        ASTList aSTList;
        if (expr.isArray()) {
            this.atNewArrayExpr(expr);
            return;
        }
        CtClass ctClass = this.resolver.lookupClassByName(expr.getClassName());
        String string = ctClass.getName();
        aSTList = ((NewExpr)aSTList).getArguments();
        this.atMethodCallCore(ctClass, "<init>", aSTList);
        this.exprType = 307;
        this.arrayDim = 0;
        this.className = MemberResolver.javaToJvmName(string);
    }

    public void atNewArrayExpr(NewExpr expr) throws CompileError {
        ASTree aSTree;
        int n2 = expr.getArrayType();
        ASTList aSTList = expr.getArraySize();
        ASTList aSTList2 = expr.getClassName();
        if ((aSTree = ((NewExpr)aSTree).getInitializer()) != null) {
            aSTree.accept(this);
        }
        if (aSTList.length() > 1) {
            this.atMultiNewArray(n2, aSTList2, aSTList);
            return;
        }
        aSTree = aSTList.head();
        if (aSTree != null) {
            aSTree.accept(this);
        }
        this.exprType = n2;
        this.arrayDim = 1;
        if (n2 == 307) {
            this.className = this.resolveClassName(aSTList2);
            return;
        }
        this.className = null;
    }

    @Override
    public void atArrayInit(ArrayInit init) throws CompileError {
        for (ASTList aSTList = init; aSTList != null; aSTList = aSTList.tail()) {
            ASTree aSTree = aSTList.head();
            if (aSTree == null) continue;
            aSTree.accept(this);
        }
    }

    /*
     * WARNING - void declaration
     */
    protected void atMultiNewArray(int type, ASTList classname, ASTList size) throws CompileError {
        void var1_1;
        ASTree aSTree;
        int n2 = size.length();
        while (size != null && (aSTree = size.head()) != null) {
            aSTree.accept(this);
            size = size.tail();
        }
        this.exprType = type;
        this.arrayDim = n2;
        if (var1_1 == 307) {
            void var2_2;
            this.className = this.resolveClassName((ASTList)var2_2);
            return;
        }
        this.className = null;
    }

    /*
     * WARNING - void declaration
     */
    @Override
    public void atAssignExpr(AssignExpr expr) throws CompileError {
        void var1_1;
        Expr expr2;
        int n2 = ((Expr)expr).getOperator();
        ASTree aSTree = ((Expr)expr).oprand1();
        Object object = ((Expr)expr).oprand2();
        if (aSTree instanceof Variable) {
            ASTree aSTree2 = object;
            object = ((Variable)aSTree).getDeclarator();
            aSTree = (Variable)aSTree;
            expr = this;
            int n3 = ((Declarator)object).getType();
            int n4 = ((Declarator)object).getArrayDim();
            object = ((Declarator)object).getClassName();
            if (n2 != 61) {
                ((TypeChecker)expr).atVariable((Variable)aSTree);
            }
            aSTree2.accept((Visitor)((Object)expr));
            ((TypeChecker)expr).exprType = n3;
            ((TypeChecker)expr).arrayDim = n4;
            ((TypeChecker)expr).className = object;
            return;
        }
        if (aSTree instanceof Expr && (expr2 = (Expr)aSTree).getOperator() == 65) {
            Expr expr3 = (Expr)aSTree;
            aSTree = object;
            Expr expr4 = expr3;
            expr = this;
            ((TypeChecker)expr).atArrayRead(expr4.oprand1(), expr4.oprand2());
            int n5 = ((TypeChecker)expr).exprType;
            int n6 = ((TypeChecker)expr).arrayDim;
            String string = ((TypeChecker)expr).className;
            aSTree.accept((Visitor)((Object)expr));
            ((TypeChecker)expr).exprType = n5;
            ((TypeChecker)expr).arrayDim = n6;
            ((TypeChecker)expr).className = string;
            return;
        }
        this.atFieldAssign((Expr)var1_1, n2, aSTree, (ASTree)object);
    }

    protected void atFieldAssign(Expr expr, int op, ASTree left, ASTree right) throws CompileError {
        String string;
        CtField ctField = this.fieldAccess((ASTree)((Object)string));
        this.a(ctField);
        int n2 = this.exprType;
        int n3 = this.arrayDim;
        string = this.className;
        right.accept(this);
        this.exprType = n2;
        this.arrayDim = n3;
        this.className = string;
    }

    /*
     * WARNING - void declaration
     */
    @Override
    public void atCondExpr(CondExpr expr) throws CompileError {
        this.c(expr.condExpr());
        expr.thenExpr().accept(this);
        int n2 = this.exprType;
        int n3 = this.arrayDim;
        expr.elseExpr().accept(this);
        if (n3 == 0 && n3 == this.arrayDim) {
            if (CodeGen.a(n2, this.exprType)) {
                expr.setThen(new CastExpr(this.exprType, 0, expr.thenExpr()));
                return;
            }
            if (CodeGen.a(this.exprType, n2)) {
                void var1_1;
                expr.setElse(new CastExpr(n2, 0, var1_1.elseExpr()));
                this.exprType = n2;
            }
        }
    }

    /*
     * WARNING - void declaration
     */
    @Override
    public void atBinExpr(BinExpr expr) throws CompileError {
        void var1_1;
        int n2 = expr.getOperator();
        int n3 = CodeGen.a(n2);
        if (n3 >= 0) {
            if (n2 == 43) {
                Expr expr2 = this.a(expr);
                if (expr2 != null) {
                    expr2 = CallExpr.makeCall(Expr.make(46, (ASTree)expr2, (ASTree)new Member("toString")), null);
                    expr.setOprand1(expr2);
                    expr.setOprand2(null);
                    this.className = "java/lang/String";
                }
                return;
            }
            ASTree aSTree = expr.oprand1();
            ASTree aSTree2 = expr.oprand2();
            aSTree.accept(this);
            int n4 = this.exprType;
            aSTree2.accept(this);
            if (!this.a(expr, n2, aSTree, aSTree2)) {
                this.a(expr, n2, n4);
            }
            return;
        }
        this.c((ASTree)var1_1);
    }

    private Expr a(BinExpr aSTList) throws CompileError {
        ASTree aSTree = aSTList.oprand1();
        ASTree aSTree2 = aSTList.oprand2();
        if (aSTree2 == null) {
            aSTree.accept(this);
            return null;
        }
        if (TypeChecker.b(aSTree)) {
            Expr expr = this.a((BinExpr)aSTree);
            if (expr != null) {
                aSTree2.accept(this);
                this.exprType = 307;
                this.arrayDim = 0;
                this.className = "java/lang/StringBuffer";
                return TypeChecker.a(expr, aSTree2);
            }
        } else {
            aSTree.accept(this);
        }
        int n2 = this.exprType;
        int n3 = this.arrayDim;
        String string = this.className;
        aSTree2.accept(this);
        if (this.a((BinExpr)aSTList, 43, aSTree, aSTree2)) {
            return null;
        }
        if (n2 == 307 && n3 == 0 && "java/lang/String".equals(string) || this.exprType == 307 && this.arrayDim == 0 && "java/lang/String".equals(this.className)) {
            aSTList = ASTList.make(new Symbol("java"), new Symbol("lang"), new Symbol("StringBuffer"));
            aSTList = new NewExpr(aSTList, null);
            this.exprType = 307;
            this.arrayDim = 0;
            this.className = "java/lang/StringBuffer";
            return TypeChecker.a(TypeChecker.a(aSTList, aSTree), aSTree2);
        }
        this.a((BinExpr)aSTList, 43, n2);
        return null;
    }

    private boolean a(BinExpr binExpr, int n2, ASTree aSTree, ASTree aSTree2) throws CompileError {
        aSTree = TypeChecker.a(aSTree);
        aSTree2 = TypeChecker.a(aSTree2);
        ASTree aSTree3 = null;
        if (aSTree instanceof StringL && aSTree2 instanceof StringL && n2 == 43) {
            aSTree3 = new StringL(((StringL)aSTree).get() + ((StringL)aSTree2).get());
        } else if (aSTree instanceof IntConst) {
            aSTree3 = ((IntConst)aSTree).compute(n2, aSTree2);
        } else if (aSTree instanceof DoubleConst) {
            aSTree3 = ((DoubleConst)aSTree).compute(n2, aSTree2);
        }
        if (aSTree3 == null) {
            return false;
        }
        binExpr.setOperator(43);
        binExpr.setOprand1(aSTree3);
        binExpr.setOprand2(null);
        aSTree3.accept(this);
        return true;
    }

    static ASTree a(ASTree aSTree) {
        if (aSTree instanceof BinExpr) {
            BinExpr binExpr = (BinExpr)aSTree;
            if (binExpr.getOperator() == 43 && binExpr.oprand2() == null) {
                return binExpr.getLeft();
            }
        } else if (aSTree instanceof Expr) {
            ASTree aSTree2 = (Expr)aSTree;
            int n2 = ((Expr)aSTree2).getOperator();
            if (n2 == 35) {
                aSTree2 = (Member)((Expr)aSTree2).oprand2();
                if ((aSTree2 = TypeChecker.getConstantFieldValue(((Member)aSTree2).getField())) != null) {
                    return aSTree2;
                }
            } else if (n2 == 43 && ((ASTList)aSTree2).getRight() == null) {
                return ((ASTList)aSTree2).getLeft();
            }
        } else if (aSTree instanceof Member) {
            ASTree aSTree3 = (Member)aSTree;
            if ((aSTree3 = TypeChecker.getConstantFieldValue(aSTree3.getField())) != null) {
                return aSTree3;
            }
        }
        return aSTree;
    }

    public static ASTree getConstantFieldValue(CtField f2) {
        Object object;
        if (f2 == null) {
            return null;
        }
        if ((object = ((CtField)object).getConstantValue()) == null) {
            return null;
        }
        if (object instanceof String) {
            return new StringL((String)object);
        }
        if (object instanceof Double || object instanceof Float) {
            int n2 = object instanceof Double ? 405 : 404;
            return new DoubleConst(((Number)object).doubleValue(), n2);
        }
        if (object instanceof Number) {
            int n3 = object instanceof Long ? 403 : 402;
            return new IntConst(((Number)object).longValue(), n3);
        }
        if (object instanceof Boolean) {
            return new Keyword((Boolean)object != false ? 410 : 411);
        }
        return null;
    }

    private static boolean b(ASTree aSTree) {
        if (aSTree instanceof BinExpr) {
            int n2 = ((Expr)(aSTree = (BinExpr)aSTree)).getOperator();
            return n2 == 43;
        }
        return false;
    }

    private static Expr a(ASTree aSTree, ASTree aSTree2) {
        return CallExpr.makeCall(Expr.make(46, aSTree, (ASTree)new Member("append")), new ASTList(aSTree2));
    }

    private void a(BinExpr binExpr, int n2, int n3) throws CompileError {
        int n4 = this.exprType;
        if (n2 == 364 || n2 == 366 || n2 == 370) {
            this.exprType = n3;
        } else {
            this.b(binExpr, n3, n4);
        }
        if (CodeGen.b(this.exprType)) {
            this.exprType = 324;
        }
    }

    private void c(ASTree aSTree) throws CompileError {
        int n2 = CodeGen.a(aSTree);
        if (n2 == 358) {
            aSTree = (BinExpr)aSTree;
            ((Expr)aSTree).oprand1().accept(this);
            n2 = this.exprType;
            int n3 = this.arrayDim;
            ((Expr)aSTree).oprand2().accept(this);
            if (n3 == 0 && this.arrayDim == 0) {
                this.b((BinExpr)aSTree, n2, this.exprType);
            }
        } else if (n2 == 33) {
            ((Expr)aSTree).oprand1().accept(this);
        } else if (n2 == 369 || n2 == 368) {
            aSTree = (BinExpr)aSTree;
            ((Expr)aSTree).oprand1().accept(this);
            ((Expr)aSTree).oprand2().accept(this);
        } else {
            aSTree.accept(this);
        }
        this.exprType = 301;
        this.arrayDim = 0;
    }

    private void b(BinExpr binExpr, int n2, int n3) throws CompileError {
        if (CodeGen.a(n2, n3)) {
            binExpr.setLeft(new CastExpr(n3, 0, binExpr.oprand1()));
            return;
        }
        this.exprType = n2;
    }

    /*
     * WARNING - void declaration
     */
    @Override
    public void atCastExpr(CastExpr expr) throws CompileError {
        void var1_1;
        String string = this.resolveClassName(expr.getClassName());
        expr.getOprand().accept(this);
        this.exprType = expr.getType();
        this.arrayDim = var1_1.getArrayDim();
        this.className = string;
    }

    @Override
    public void atInstanceOfExpr(InstanceOfExpr expr) throws CompileError {
        expr.getOprand().accept(this);
        this.exprType = 301;
        this.arrayDim = 0;
    }

    /*
     * WARNING - void declaration
     */
    @Override
    public void atExpr(Expr expr) throws CompileError {
        block9: {
            boolean bl;
            int n2;
            block21: {
                void var1_1;
                block22: {
                    block23: {
                        block24: {
                            int n3;
                            ASTree aSTree;
                            block17: {
                                long l2;
                                IntConst intConst;
                                block19: {
                                    block20: {
                                        block18: {
                                            ASTree aSTree2;
                                            block14: {
                                                block16: {
                                                    Expr expr2;
                                                    block15: {
                                                        block12: {
                                                            block13: {
                                                                block11: {
                                                                    block10: {
                                                                        n2 = ((Expr)expr).getOperator();
                                                                        aSTree2 = ((Expr)expr).oprand1();
                                                                        if (n2 != 46) break block11;
                                                                        String string = ((Symbol)((Expr)expr).oprand2()).get();
                                                                        if (string.equals("length")) {
                                                                            try {
                                                                                this.atArrayLength((Expr)expr);
                                                                                break block9;
                                                                            }
                                                                            catch (NoFieldException noFieldException) {
                                                                                break block10;
                                                                            }
                                                                        }
                                                                        if (!string.equals("class")) break block10;
                                                                        this.atClassObject((Expr)expr);
                                                                        break block9;
                                                                    }
                                                                    this.d((ASTree)((Object)expr));
                                                                    return;
                                                                }
                                                                if (n2 != 35) break block12;
                                                                String string = ((Symbol)((Expr)expr).oprand2()).get();
                                                                if (!string.equals("class")) break block13;
                                                                this.atClassObject((Expr)expr);
                                                                break block9;
                                                            }
                                                            this.d((ASTree)((Object)expr));
                                                            return;
                                                        }
                                                        if (n2 == 65) {
                                                            this.atArrayRead(aSTree2, ((Expr)expr).oprand2());
                                                            return;
                                                        }
                                                        if (n2 != 362 && n2 != 363) break block14;
                                                        Expr expr3 = expr;
                                                        expr = this;
                                                        boolean bl2 = aSTree2 == null;
                                                        if (bl2) {
                                                            aSTree2 = expr3.oprand2();
                                                        }
                                                        if (!(aSTree2 instanceof Variable)) break block15;
                                                        Declarator declarator = ((Variable)aSTree2).getDeclarator();
                                                        ((TypeChecker)expr).exprType = declarator.getType();
                                                        ((TypeChecker)expr).arrayDim = declarator.getArrayDim();
                                                        break block9;
                                                    }
                                                    if (!(aSTree2 instanceof Expr) || (expr2 = (Expr)aSTree2).getOperator() != 65) break block16;
                                                    ((TypeChecker)expr).atArrayRead(expr2.oprand1(), expr2.oprand2());
                                                    int n4 = ((TypeChecker)expr).exprType;
                                                    if (n4 == 324 || n4 == 303 || n4 == 306 || n4 == 334) {
                                                        ((TypeChecker)expr).exprType = 324;
                                                    }
                                                    break block9;
                                                }
                                                ((TypeChecker)expr).atFieldPlusPlus(aSTree2);
                                                return;
                                            }
                                            if (n2 == 33) {
                                                this.c((ASTree)((Object)expr));
                                                return;
                                            }
                                            if (n2 == 67) {
                                                TypeChecker.fatal();
                                                return;
                                            }
                                            aSTree2.accept(this);
                                            aSTree = aSTree2;
                                            n3 = n2;
                                            aSTree = TypeChecker.a(aSTree);
                                            if (!(aSTree instanceof IntConst)) break block17;
                                            intConst = (IntConst)aSTree;
                                            l2 = intConst.get();
                                            if (n3 != 45) break block18;
                                            l2 = -l2;
                                            break block19;
                                        }
                                        if (n3 == 126) break block20;
                                        bl = false;
                                        break block21;
                                    }
                                    l2 ^= 0xFFFFFFFFFFFFFFFFL;
                                }
                                intConst.set(l2);
                                break block22;
                            }
                            if (!(aSTree instanceof DoubleConst)) break block23;
                            DoubleConst doubleConst = (DoubleConst)aSTree;
                            if (n3 != 45) break block24;
                            DoubleConst doubleConst2 = doubleConst;
                            doubleConst2.set(-doubleConst2.get());
                            break block22;
                        }
                        bl = false;
                        break block21;
                    }
                    bl = false;
                    break block21;
                }
                var1_1.setOperator(43);
                bl = true;
            }
            if (!bl && (n2 == 45 || n2 == 126) && CodeGen.b(this.exprType)) {
                this.exprType = 324;
            }
        }
    }

    /*
     * WARNING - void declaration
     */
    @Override
    public void atCallExpr(CallExpr expr) throws CompileError {
        void var1_1;
        String string = null;
        CtClass ctClass = null;
        Object object = expr.oprand1();
        ASTList aSTList = (ASTList)expr.oprand2();
        if (object instanceof Member) {
            string = ((Member)object).get();
            ctClass = this.thisClass;
        } else if (object instanceof Keyword) {
            string = "<init>";
            ctClass = ((Keyword)object).get() == 336 ? MemberResolver.getSuperclass(this.thisClass) : this.thisClass;
        } else if (object instanceof Expr) {
            object = (Expr)object;
            string = ((Symbol)((Expr)object).oprand2()).get();
            int n2 = ((Expr)object).getOperator();
            if (n2 == 35) {
                ctClass = this.resolver.lookupClass(((Symbol)((Expr)object).oprand1()).get(), false);
            } else if (n2 == 46) {
                ASTree aSTree = ((Expr)object).oprand1();
                try {
                    aSTree.accept(this);
                }
                catch (NoFieldException noFieldException) {
                    NoFieldException noFieldException2 = noFieldException;
                    if (noFieldException.getExpr() != aSTree) {
                        throw noFieldException2;
                    }
                    this.exprType = 307;
                    this.arrayDim = 0;
                    this.className = noFieldException2.getField();
                    ((Expr)object).setOperator(35);
                    ((Expr)object).setOprand1(new Symbol(MemberResolver.jvmToJavaName(this.className)));
                }
                if (this.arrayDim > 0) {
                    ctClass = this.resolver.lookupClass("java.lang.Object", true);
                } else if (this.exprType == 307) {
                    ctClass = this.resolver.lookupClassByJvmName(this.className);
                } else {
                    TypeChecker.a();
                }
            } else {
                TypeChecker.a();
            }
        } else {
            TypeChecker.fatal();
        }
        object = this.atMethodCallCore(ctClass, string, aSTList);
        var1_1.setMethod((MemberResolver.Method)object);
    }

    private static void a() throws CompileError {
        throw new CompileError("bad method");
    }

    /*
     * WARNING - void declaration
     */
    public MemberResolver.Method atMethodCallCore(CtClass targetClass, String mname, ASTList args) throws CompileError {
        String string;
        Object object;
        int n2 = this.getMethodArgsLength(args);
        int[] nArray = new int[n2];
        int[] nArray2 = new int[n2];
        String[] stringArray = new String[n2];
        this.atMethodArgs((ASTList)object, nArray, nArray2, stringArray);
        object = this.resolver.lookupMethod(targetClass, this.thisClass, this.thisMethod, mname, nArray, nArray2, stringArray);
        if (object == null) {
            void var2_2;
            string = ((CtClass)((Object)string)).getName();
            object = TypeChecker.argTypesToString(nArray, nArray2, stringArray);
            string = mname.equals("<init>") ? "cannot find constructor " + string + (String)object : (String)var2_2 + (String)object + " not found in " + string;
            throw new CompileError(string);
        }
        string = ((MemberResolver.Method)object).info.getDescriptor();
        this.a(string);
        return object;
    }

    public int getMethodArgsLength(ASTList args) {
        return ASTList.length(args);
    }

    public void atMethodArgs(ASTList args, int[] types, int[] dims, String[] cnames) throws CompileError {
        int n2 = 0;
        while (args != null) {
            ASTree aSTree = args.head();
            aSTree.accept(this);
            types[n2] = this.exprType;
            dims[n2] = this.arrayDim;
            cnames[n2] = this.className;
            ++n2;
            args = args.tail();
        }
    }

    final void a(String string) throws CompileError {
        int n2 = string.indexOf(41);
        if (n2 < 0) {
            TypeChecker.a();
        }
        int n3 = string.charAt(++n2);
        int n4 = 0;
        while (n3 == 91) {
            ++n4;
            n3 = string.charAt(++n2);
        }
        this.arrayDim = n4;
        if (n3 == 76) {
            n3 = string.indexOf(59, n2 + 1);
            if (n3 < 0) {
                TypeChecker.a();
            }
            this.exprType = 307;
            this.className = string.substring(n2 + 1, n3);
            return;
        }
        this.exprType = MemberResolver.descToType((char)n3);
        this.className = null;
    }

    private void d(ASTree aSTree) throws CompileError {
        TypeChecker typeChecker = this;
        typeChecker.a(typeChecker.fieldAccess(aSTree));
    }

    private void a(CtField object) throws CompileError {
        object = ((CtField)object).getFieldInfo2();
        object = ((FieldInfo)object).getDescriptor();
        int n2 = 0;
        int n3 = 0;
        char c2 = ((String)object).charAt(0);
        while (c2 == '[') {
            ++n3;
            c2 = ((String)object).charAt(++n2);
        }
        this.arrayDim = n3;
        this.exprType = MemberResolver.descToType(c2);
        if (c2 == 'L') {
            this.className = ((String)object).substring(n2 + 1, ((String)object).indexOf(59, n2 + 1));
            return;
        }
        this.className = null;
    }

    protected CtField fieldAccess(ASTree expr) throws CompileError {
        if (expr instanceof Member) {
            Member member = (Member)expr;
            String string = member.get();
            try {
                CtField ctField = this.thisClass.getField(string);
                if (Modifier.isStatic(ctField.getModifiers())) {
                    member.setField(ctField);
                }
                return ctField;
            }
            catch (NotFoundException notFoundException) {
                throw new NoFieldException(string, expr);
            }
        }
        if (expr instanceof Expr) {
            Object object;
            Expr expr2 = (Expr)object;
            int n2 = expr2.getOperator();
            if (n2 == 35) {
                Member member = (Member)expr2.oprand2();
                object = this.resolver.lookupField(((Symbol)expr2.oprand1()).get(), member);
                member.setField((CtField)object);
                return object;
            }
            if (n2 == 46) {
                try {
                    expr2.oprand1().accept(this);
                }
                catch (NoFieldException noFieldException) {
                    NoFieldException noFieldException2 = noFieldException;
                    if (noFieldException.getExpr() != expr2.oprand1()) {
                        throw noFieldException2;
                    }
                    return this.a(expr2, noFieldException2.getField());
                }
                CompileError compileError = null;
                try {
                    if (this.exprType == 307 && this.arrayDim == 0) {
                        return this.resolver.lookupFieldByJvmName(this.className, (Symbol)expr2.oprand2());
                    }
                }
                catch (CompileError compileError2) {
                    object = compileError2;
                    compileError = compileError2;
                }
                object = expr2.oprand1();
                if (object instanceof Symbol) {
                    return this.a(expr2, ((Symbol)object).get());
                }
                if (compileError != null) {
                    throw compileError;
                }
            }
        }
        throw new CompileError("bad filed access");
    }

    private CtField a(Expr expr, String string) throws CompileError {
        Member member = (Member)expr.oprand2();
        CtField ctField = this.resolver.lookupFieldByJvmName2(string, member, expr);
        expr.setOperator(35);
        expr.setOprand1(new Symbol(MemberResolver.jvmToJavaName(string)));
        member.setField(ctField);
        return ctField;
    }

    public void atClassObject(Expr expr) throws CompileError {
        this.exprType = 307;
        this.arrayDim = 0;
        this.className = "java/lang/Class";
    }

    /*
     * WARNING - void declaration
     */
    public void atArrayLength(Expr expr) throws CompileError {
        expr.oprand1().accept(this);
        if (this.arrayDim == 0) {
            void var1_1;
            throw new NoFieldException("length", (ASTree)var1_1);
        }
        this.exprType = 324;
        this.arrayDim = 0;
    }

    /*
     * WARNING - void declaration
     */
    public void atArrayRead(ASTree array, ASTree index) throws CompileError {
        void var2_3;
        array.accept(this);
        int n2 = this.exprType;
        int n3 = this.arrayDim;
        String string = this.className;
        var2_3.accept(this);
        this.exprType = n2;
        this.arrayDim = n3 - 1;
        this.className = string;
    }

    protected void atFieldPlusPlus(ASTree oprand) throws CompileError {
        CtField ctField;
        ctField = this.fieldAccess((ASTree)((Object)ctField));
        this.a(ctField);
        int n2 = this.exprType;
        if (n2 == 324 || n2 == 303 || n2 == 306 || n2 == 334) {
            this.exprType = 324;
        }
    }

    /*
     * WARNING - void declaration
     */
    @Override
    public void atMember(Member mem) throws CompileError {
        void var1_1;
        this.d((ASTree)var1_1);
    }

    @Override
    public void atVariable(Variable v) throws CompileError {
        Declarator declarator = v.getDeclarator();
        this.exprType = declarator.getType();
        this.arrayDim = declarator.getArrayDim();
        this.className = declarator.getClassName();
    }

    /*
     * WARNING - void declaration
     */
    @Override
    public void atKeyword(Keyword k2) throws CompileError {
        void var1_1;
        this.arrayDim = 0;
        int n2 = var1_1.get();
        switch (n2) {
            case 410: 
            case 411: {
                this.exprType = 301;
                return;
            }
            case 412: {
                this.exprType = 412;
                return;
            }
            case 336: 
            case 339: {
                this.exprType = 307;
                if (n2 == 339) {
                    this.className = this.getThisName();
                    return;
                }
                this.className = this.getSuperName();
                return;
            }
        }
        TypeChecker.fatal();
    }

    @Override
    public void atStringL(StringL s2) throws CompileError {
        this.exprType = 307;
        this.arrayDim = 0;
        this.className = "java/lang/String";
    }

    /*
     * WARNING - void declaration
     */
    @Override
    public void atIntConst(IntConst i2) throws CompileError {
        void var1_1;
        this.arrayDim = 0;
        int n2 = var1_1.getType();
        if (n2 == 402 || n2 == 401) {
            this.exprType = n2 == 402 ? 324 : 306;
            return;
        }
        this.exprType = 326;
    }

    /*
     * WARNING - void declaration
     */
    @Override
    public void atDoubleConst(DoubleConst d2) throws CompileError {
        void var1_1;
        this.arrayDim = 0;
        if (var1_1.getType() == 405) {
            this.exprType = 312;
            return;
        }
        this.exprType = 317;
    }
}

