/*
 * Decompiled with CFR 0.152.
 */
package javassist.bytecode.stackmap;

import java.util.ArrayList;
import java.util.HashSet;
import javassist.ClassPool;
import javassist.CtClass;
import javassist.NotFoundException;
import javassist.bytecode.BadBytecode;
import javassist.bytecode.ConstPool;
import javassist.bytecode.Descriptor;
import javassist.bytecode.stackmap.TypeTag;

public abstract class TypeData {
    public static TypeData[] make(int size) {
        TypeData[] typeDataArray = new TypeData[size];
        for (int i2 = 0; i2 < size; ++i2) {
            typeDataArray[i2] = TypeTag.TOP;
        }
        return typeDataArray;
    }

    protected TypeData() {
    }

    public abstract int getTypeTag();

    public abstract int getTypeData(ConstPool var1);

    public TypeData join() {
        return new TypeVar(this);
    }

    public abstract BasicType isBasicType();

    public abstract boolean is2WordType();

    public boolean isNullType() {
        return false;
    }

    public boolean isUninit() {
        return false;
    }

    public abstract boolean eq(TypeData var1);

    public abstract String getName();

    public abstract void setType(String var1, ClassPool var2) throws BadBytecode;

    public int dfs(ArrayList order, int index, ClassPool cp) throws NotFoundException {
        return index;
    }

    protected TypeVar toTypeVar() {
        return null;
    }

    public void constructorCalled(int offset) {
    }

    /*
     * WARNING - void declaration
     */
    public static CtClass commonSuperClassEx(CtClass one, CtClass two) throws NotFoundException {
        void var1_1;
        CtClass ctClass;
        if (one == two) {
            return one;
        }
        if (one.isArray() && two.isArray()) {
            CtClass ctClass2;
            CtClass ctClass3 = one.getComponentType();
            CtClass ctClass4 = TypeData.commonSuperClassEx(ctClass3, ctClass2 = two.getComponentType());
            if (ctClass4 == ctClass3) {
                return one;
            }
            if (ctClass4 == ctClass2) {
                return two;
            }
            return one.getClassPool().get(ctClass4 == null ? "java.lang.Object" : ctClass4.getName() + "[]");
        }
        if (one.isPrimitive() || two.isPrimitive()) {
            return null;
        }
        if (one.isArray() || two.isArray()) {
            return one.getClassPool().get("java.lang.Object");
        }
        return TypeData.commonSuperClass(ctClass, (CtClass)var1_1);
    }

    public static CtClass commonSuperClass(CtClass one, CtClass two) throws NotFoundException {
        CtClass ctClass;
        CtClass ctClass2 = one;
        CtClass ctClass3 = ctClass;
        CtClass ctClass4 = ctClass2;
        while (true) {
            if (TypeData.a(ctClass2, ctClass) && ctClass2.getSuperclass() != null) {
                return ctClass2;
            }
            CtClass ctClass5 = ctClass2.getSuperclass();
            CtClass ctClass6 = ctClass.getSuperclass();
            if (ctClass6 == null) {
                ctClass = ctClass3;
                break;
            }
            if (ctClass5 == null) {
                ctClass2 = ctClass4;
                ctClass4 = ctClass3;
                ctClass3 = ctClass2;
                ctClass2 = ctClass;
                ctClass = ctClass3;
                break;
            }
            ctClass2 = ctClass5;
            ctClass = ctClass6;
        }
        while ((ctClass2 = ctClass2.getSuperclass()) != null) {
            ctClass4 = ctClass4.getSuperclass();
        }
        ctClass2 = ctClass4;
        while (!TypeData.a(ctClass2, ctClass)) {
            ctClass2 = ctClass2.getSuperclass();
            ctClass = ctClass.getSuperclass();
        }
        return ctClass2;
    }

    private static boolean a(CtClass ctClass, CtClass ctClass2) {
        return ctClass == ctClass2 || ctClass != null && ctClass2 != null && ctClass.getName().equals(ctClass2.getName());
    }

    /*
     * WARNING - void declaration
     */
    public static void aastore(TypeData array, TypeData value, ClassPool cp) throws BadBytecode {
        if (array instanceof AbsTypeVar && !value.isNullType()) {
            ((AbsTypeVar)array).merge(ArrayType.a(value));
        }
        if (value instanceof AbsTypeVar) {
            String string;
            if (array instanceof AbsTypeVar) {
                ArrayElement.make(array);
                return;
            }
            if (array instanceof ClassName) {
                if (!array.isNullType()) {
                    void var2_2;
                    void var1_1;
                    string = ArrayElement.b(array.getName());
                    var1_1.setType(string, (ClassPool)var2_2);
                    return;
                }
            } else {
                throw new BadBytecode("bad AASTORE: " + string);
            }
        }
    }

    public static class UninitThis
    extends UninitData {
        /*
         * WARNING - void declaration
         */
        UninitThis(String className) {
            super(-1, (String)var1_1);
            void var1_1;
        }

        @Override
        public UninitData copy() {
            return new UninitThis(this.getName());
        }

        @Override
        public int getTypeTag() {
            return 6;
        }

        @Override
        public int getTypeData(ConstPool cp) {
            return 0;
        }

        @Override
        public String toString() {
            return "uninit:this";
        }
    }

    public static class UninitData
    extends ClassName {
        int a;
        private boolean b;

        /*
         * WARNING - void declaration
         */
        UninitData(int offset, String className) {
            super((String)var2_2);
            void var1_1;
            void var2_2;
            this.a = var1_1;
            this.b = false;
        }

        public UninitData copy() {
            return new UninitData(this.a, this.getName());
        }

        @Override
        public int getTypeTag() {
            return 8;
        }

        @Override
        public int getTypeData(ConstPool cp) {
            return this.a;
        }

        @Override
        public TypeData join() {
            if (this.b) {
                return new TypeVar(new ClassName(this.getName()));
            }
            return new UninitTypeVar(this.copy());
        }

        @Override
        public boolean isUninit() {
            return true;
        }

        @Override
        public boolean eq(TypeData d2) {
            if (d2 instanceof UninitData) {
                UninitData uninitData;
                uninitData = uninitData;
                return this.a == uninitData.a && this.getName().equals(uninitData.getName());
            }
            return false;
        }

        public String toString() {
            return "uninit:" + this.getName() + "@" + this.a;
        }

        public int offset() {
            return this.a;
        }

        @Override
        public void constructorCalled(int offset) {
            if (offset == this.a) {
                this.b = true;
            }
        }
    }

    public static class NullType
    extends ClassName {
        public NullType() {
            super("null-type");
        }

        @Override
        public int getTypeTag() {
            return 5;
        }

        @Override
        public boolean isNullType() {
            return true;
        }

        @Override
        public int getTypeData(ConstPool cp) {
            return 0;
        }
    }

    public static class ClassName
    extends TypeData {
        private String a;

        /*
         * WARNING - void declaration
         */
        public ClassName(String n2) {
            void var1_1;
            this.a = var1_1;
        }

        @Override
        public String getName() {
            return this.a;
        }

        @Override
        public BasicType isBasicType() {
            return null;
        }

        @Override
        public boolean is2WordType() {
            return false;
        }

        @Override
        public int getTypeTag() {
            return 7;
        }

        @Override
        public int getTypeData(ConstPool cp) {
            return cp.addClassInfo(this.getName());
        }

        /*
         * WARNING - void declaration
         */
        @Override
        public boolean eq(TypeData d2) {
            void var1_1;
            return this.a.equals(var1_1.getName());
        }

        @Override
        public void setType(String typeName, ClassPool cp) throws BadBytecode {
        }
    }

    public static class UninitTypeVar
    extends AbsTypeVar {
        protected TypeData type;

        /*
         * WARNING - void declaration
         */
        public UninitTypeVar(UninitData t2) {
            void var1_1;
            this.type = var1_1;
        }

        @Override
        public int getTypeTag() {
            return this.type.getTypeTag();
        }

        /*
         * WARNING - void declaration
         */
        @Override
        public int getTypeData(ConstPool cp) {
            void var1_1;
            return this.type.getTypeData((ConstPool)var1_1);
        }

        @Override
        public BasicType isBasicType() {
            return this.type.isBasicType();
        }

        @Override
        public boolean is2WordType() {
            return this.type.is2WordType();
        }

        @Override
        public boolean isUninit() {
            return this.type.isUninit();
        }

        /*
         * WARNING - void declaration
         */
        @Override
        public boolean eq(TypeData d2) {
            void var1_1;
            return this.type.eq((TypeData)var1_1);
        }

        @Override
        public String getName() {
            return this.type.getName();
        }

        @Override
        protected TypeVar toTypeVar() {
            return null;
        }

        @Override
        public TypeData join() {
            return this.type.join();
        }

        /*
         * WARNING - void declaration
         */
        @Override
        public void setType(String s2, ClassPool cp) throws BadBytecode {
            void var2_2;
            void var1_1;
            this.type.setType((String)var1_1, (ClassPool)var2_2);
        }

        @Override
        public void merge(TypeData t2) {
            if (!t2.eq(this.type)) {
                this.type = TypeTag.TOP;
            }
        }

        /*
         * WARNING - void declaration
         */
        @Override
        public void constructorCalled(int offset) {
            void var1_1;
            this.type.constructorCalled((int)var1_1);
        }

        public int offset() {
            if (this.type instanceof UninitData) {
                return ((UninitData)this.type).a;
            }
            throw new RuntimeException("not available");
        }
    }

    public static class ArrayElement
    extends AbsTypeVar {
        private AbsTypeVar a;

        /*
         * WARNING - void declaration
         */
        private ArrayElement(AbsTypeVar a2) {
            void var1_1;
            this.a = var1_1;
        }

        public static TypeData make(TypeData array) throws BadBytecode {
            TypeData typeData;
            if (array instanceof ArrayType) {
                return ((ArrayType)array).elementType();
            }
            if (array instanceof AbsTypeVar) {
                return new ArrayElement((AbsTypeVar)array);
            }
            if (array instanceof ClassName && !array.isNullType()) {
                return new ClassName(ArrayElement.b(array.getName()));
            }
            throw new BadBytecode("bad AASTORE: " + typeData);
        }

        /*
         * WARNING - void declaration
         */
        @Override
        public void merge(TypeData t2) {
            try {
                if (!t2.isNullType()) {
                    void var1_1;
                    this.a.merge(ArrayType.a((TypeData)var1_1));
                }
                return;
            }
            catch (BadBytecode badBytecode) {
                throw new RuntimeException("fatal: " + badBytecode);
            }
        }

        @Override
        public String getName() {
            return ArrayElement.b(this.a.getName());
        }

        public AbsTypeVar arrayType() {
            return this.a;
        }

        @Override
        public BasicType isBasicType() {
            return null;
        }

        @Override
        public boolean is2WordType() {
            return false;
        }

        private static String b(String string) {
            if (string.length() > 1 && string.charAt(0) == '[') {
                char c2 = string.charAt(1);
                if (c2 == 'L') {
                    return string.substring(2, string.length() - 1).replace('/', '.');
                }
                if (c2 == '[') {
                    return string.substring(1);
                }
            }
            return "java.lang.Object";
        }

        /*
         * WARNING - void declaration
         */
        @Override
        public void setType(String s2, ClassPool cp) throws BadBytecode {
            void var2_2;
            void var1_1;
            this.a.setType(ArrayType.typeName((String)var1_1), (ClassPool)var2_2);
        }

        @Override
        protected TypeVar toTypeVar() {
            return this.a.toTypeVar();
        }

        /*
         * WARNING - void declaration
         */
        @Override
        public int dfs(ArrayList order, int index, ClassPool cp) throws NotFoundException {
            void var3_3;
            void var2_2;
            void var1_1;
            return this.a.dfs((ArrayList)var1_1, (int)var2_2, (ClassPool)var3_3);
        }
    }

    public static class ArrayType
    extends AbsTypeVar {
        private AbsTypeVar a;

        /*
         * WARNING - void declaration
         */
        private ArrayType(AbsTypeVar elementType) {
            void var1_1;
            this.a = var1_1;
        }

        static TypeData a(TypeData typeData) throws BadBytecode {
            if (typeData instanceof ArrayElement) {
                return ((ArrayElement)typeData).arrayType();
            }
            if (typeData instanceof AbsTypeVar) {
                return new ArrayType((AbsTypeVar)typeData);
            }
            if (typeData instanceof ClassName && !typeData.isNullType()) {
                return new ClassName(ArrayType.typeName(typeData.getName()));
            }
            throw new BadBytecode("bad AASTORE: " + typeData);
        }

        /*
         * WARNING - void declaration
         */
        @Override
        public void merge(TypeData t2) {
            try {
                if (!t2.isNullType()) {
                    void var1_1;
                    this.a.merge(ArrayElement.make((TypeData)var1_1));
                }
                return;
            }
            catch (BadBytecode badBytecode) {
                throw new RuntimeException("fatal: " + badBytecode);
            }
        }

        @Override
        public String getName() {
            return ArrayType.typeName(this.a.getName());
        }

        public AbsTypeVar elementType() {
            return this.a;
        }

        @Override
        public BasicType isBasicType() {
            return null;
        }

        @Override
        public boolean is2WordType() {
            return false;
        }

        public static String typeName(String elementType) {
            String string;
            if (elementType.charAt(0) == '[') {
                return "[" + elementType;
            }
            return "[L" + string.replace('.', '/') + ";";
        }

        /*
         * WARNING - void declaration
         */
        @Override
        public void setType(String s2, ClassPool cp) throws BadBytecode {
            void var2_2;
            void var1_1;
            this.a.setType(ArrayElement.b((String)var1_1), (ClassPool)var2_2);
        }

        @Override
        protected TypeVar toTypeVar() {
            return this.a.toTypeVar();
        }

        /*
         * WARNING - void declaration
         */
        @Override
        public int dfs(ArrayList order, int index, ClassPool cp) throws NotFoundException {
            void var3_3;
            void var2_2;
            void var1_1;
            return this.a.dfs((ArrayList)var1_1, (int)var2_2, (ClassPool)var3_3);
        }
    }

    public static class TypeVar
    extends AbsTypeVar {
        protected ArrayList lowers = new ArrayList(2);
        protected ArrayList usedBy = new ArrayList(2);
        protected ArrayList uppers = null;
        protected String fixedType;
        private boolean a;
        private int b = 0;
        private int c = 0;
        private boolean d = false;

        /*
         * WARNING - void declaration
         */
        public TypeVar(TypeData t2) {
            void var1_1;
            this.merge(t2);
            this.fixedType = null;
            this.a = var1_1.is2WordType();
        }

        @Override
        public String getName() {
            if (this.fixedType == null) {
                return ((TypeData)this.lowers.get(0)).getName();
            }
            return this.fixedType;
        }

        @Override
        public BasicType isBasicType() {
            if (this.fixedType == null) {
                return ((TypeData)this.lowers.get(0)).isBasicType();
            }
            return null;
        }

        @Override
        public boolean is2WordType() {
            if (this.fixedType == null) {
                return this.a;
            }
            return false;
        }

        @Override
        public boolean isNullType() {
            if (this.fixedType == null) {
                return ((TypeData)this.lowers.get(0)).isNullType();
            }
            return false;
        }

        @Override
        public boolean isUninit() {
            if (this.fixedType == null) {
                return ((TypeData)this.lowers.get(0)).isUninit();
            }
            return false;
        }

        /*
         * WARNING - void declaration
         */
        @Override
        public void merge(TypeData t2) {
            this.lowers.add(t2);
            if (t2 instanceof TypeVar) {
                void var1_1;
                ((TypeVar)var1_1).usedBy.add(this);
            }
        }

        @Override
        public int getTypeTag() {
            if (this.fixedType == null) {
                return ((TypeData)this.lowers.get(0)).getTypeTag();
            }
            return super.getTypeTag();
        }

        /*
         * WARNING - void declaration
         */
        @Override
        public int getTypeData(ConstPool cp) {
            void var1_1;
            if (this.fixedType == null) {
                return ((TypeData)this.lowers.get(0)).getTypeData(cp);
            }
            return super.getTypeData((ConstPool)var1_1);
        }

        /*
         * WARNING - void declaration
         */
        @Override
        public void setType(String typeName, ClassPool cp) throws BadBytecode {
            void var1_1;
            if (this.uppers == null) {
                this.uppers = new ArrayList();
            }
            this.uppers.add(var1_1);
        }

        @Override
        protected TypeVar toTypeVar() {
            return this;
        }

        /*
         * WARNING - void declaration
         */
        @Override
        public int dfs(ArrayList preOrder, int index, ClassPool cp) throws NotFoundException {
            void var2_2;
            TypeVar typeVar;
            if (this.b > 0) {
                return index;
            }
            TypeVar typeVar2 = this;
            typeVar2.b = typeVar2.c = ++index;
            preOrder.add(this);
            this.d = true;
            int n2 = this.lowers.size();
            for (int i2 = 0; i2 < n2; ++i2) {
                typeVar = ((TypeData)this.lowers.get(i2)).toTypeVar();
                if (typeVar == null) continue;
                if (typeVar.b == 0) {
                    index = typeVar.dfs(preOrder, index, cp);
                    if (typeVar.c >= this.c) continue;
                    this.c = typeVar.c;
                    continue;
                }
                if (!typeVar.d || typeVar.b >= this.c) continue;
                this.c = typeVar.b;
            }
            if (this.b == this.c) {
                void var3_3;
                ArrayList<TypeVar> arrayList = new ArrayList<TypeVar>();
                do {
                    ArrayList arrayList2 = preOrder;
                    typeVar = (TypeVar)arrayList2.remove(arrayList2.size() - 1);
                    ((TypeVar)arrayList2.remove(arrayList2.size() - 1)).d = false;
                    arrayList.add(typeVar);
                } while (typeVar != this);
                this.a(arrayList, (ClassPool)var3_3);
            }
            return (int)var2_2;
        }

        private void a(ArrayList arrayList, ClassPool classPool) throws NotFoundException {
            Object object;
            int n2;
            HashSet<String> hashSet = new HashSet<String>();
            boolean bl = false;
            TypeData typeData = null;
            int n3 = arrayList.size();
            block0: for (n2 = 0; n2 < n3; ++n2) {
                object = ((TypeVar)arrayList.get((int)n2)).lowers;
                int n4 = ((ArrayList)object).size();
                for (int i2 = 0; i2 < n4; ++i2) {
                    TypeData typeData2 = (TypeData)((ArrayList)object).get(i2);
                    BasicType basicType = typeData2.isBasicType();
                    if (typeData == null) {
                        if (basicType == null) {
                            bl = false;
                            typeData = typeData2;
                            if (typeData2.isUninit()) {
                                continue block0;
                            }
                        } else {
                            bl = true;
                            typeData = basicType;
                        }
                    } else if (basicType == null && bl || basicType != null && typeData != basicType) {
                        bl = true;
                        typeData = TypeTag.TOP;
                        continue block0;
                    }
                    if (basicType != null || typeData2.isNullType()) continue;
                    hashSet.add(typeData2.getName());
                }
            }
            if (bl) {
                for (n2 = 0; n2 < n3; ++n2) {
                    object = (TypeVar)arrayList.get(n2);
                    ((TypeVar)object).lowers.clear();
                    ((TypeVar)object).lowers.add(typeData);
                    this.a = typeData.is2WordType();
                }
                return;
            }
            String string = this.a(arrayList, hashSet, classPool);
            for (int i3 = 0; i3 < n3; ++i3) {
                TypeVar typeVar = (TypeVar)arrayList.get(i3);
                ((TypeVar)arrayList.get(i3)).fixedType = string;
            }
        }

        private String a(ArrayList arrayList, HashSet object, ClassPool classPool) throws NotFoundException {
            Object object2 = ((HashSet)object).iterator();
            if (((HashSet)object).size() == 0) {
                return null;
            }
            if (((HashSet)object).size() == 1) {
                return (String)object2.next();
            }
            object = classPool.get((String)object2.next());
            while (object2.hasNext()) {
                object = TypeVar.commonSuperClassEx((CtClass)object, classPool.get((String)object2.next()));
            }
            if (((CtClass)object).getSuperclass() == null || ((CtClass)(object2 = object)).isArray() && ((CtClass)object2).getComponentType().getSuperclass() == null) {
                object = this.a(arrayList, classPool, new HashSet(), (CtClass)object);
            }
            if (((CtClass)object).isArray()) {
                return Descriptor.toJvmName((CtClass)object);
            }
            return ((CtClass)object).getName();
        }

        private CtClass a(ArrayList arrayList, ClassPool classPool, HashSet hashSet, CtClass ctClass) throws NotFoundException {
            if (arrayList == null) {
                return ctClass;
            }
            int n2 = arrayList.size();
            for (int i2 = 0; i2 < n2; ++i2) {
                TypeVar typeVar = (TypeVar)arrayList.get(i2);
                if (!hashSet.add(typeVar)) {
                    return ctClass;
                }
                if (typeVar.uppers != null) {
                    int n3 = typeVar.uppers.size();
                    for (int i3 = 0; i3 < n3; ++i3) {
                        CtClass ctClass2 = classPool.get((String)typeVar.uppers.get(i3));
                        if (!ctClass2.subtypeOf(ctClass)) continue;
                        ctClass = ctClass2;
                    }
                }
                ctClass = this.a(typeVar.usedBy, classPool, hashSet, ctClass);
            }
            return ctClass;
        }
    }

    public static abstract class AbsTypeVar
    extends TypeData {
        public abstract void merge(TypeData var1);

        @Override
        public int getTypeTag() {
            return 7;
        }

        @Override
        public int getTypeData(ConstPool cp) {
            return cp.addClassInfo(this.getName());
        }

        /*
         * WARNING - void declaration
         */
        @Override
        public boolean eq(TypeData d2) {
            void var1_1;
            return this.getName().equals(var1_1.getName());
        }
    }

    protected static class BasicType
    extends TypeData {
        private String a;
        private int b;

        /*
         * WARNING - void declaration
         */
        public BasicType(String type, int tag) {
            void var2_2;
            void var1_1;
            this.a = var1_1;
            this.b = var2_2;
        }

        @Override
        public int getTypeTag() {
            return this.b;
        }

        @Override
        public int getTypeData(ConstPool cp) {
            return 0;
        }

        @Override
        public TypeData join() {
            if (this == TypeTag.TOP) {
                return this;
            }
            return super.join();
        }

        @Override
        public BasicType isBasicType() {
            return this;
        }

        @Override
        public boolean is2WordType() {
            return this.b == 4 || this.b == 3;
        }

        /*
         * WARNING - void declaration
         */
        @Override
        public boolean eq(TypeData d2) {
            void var1_1;
            return this == var1_1;
        }

        @Override
        public String getName() {
            return this.a;
        }

        /*
         * WARNING - void declaration
         */
        @Override
        public void setType(String s2, ClassPool cp) throws BadBytecode {
            void var1_1;
            throw new BadBytecode("conflict: " + this.a + " and " + (String)var1_1);
        }

        public String toString() {
            return this.a;
        }
    }
}

