/*
 * Decompiled with CFR 0.152.
 */
package javassist.bytecode;

import java.io.DataInputStream;
import java.io.IOException;
import java.util.Map;
import javassist.bytecode.AttributeInfo;
import javassist.bytecode.ByteArray;
import javassist.bytecode.ConstPool;

public class InnerClassesAttribute
extends AttributeInfo {
    public static final String tag = "InnerClasses";

    /*
     * WARNING - void declaration
     */
    InnerClassesAttribute(ConstPool cp, int n2, DataInputStream in) throws IOException {
        super((ConstPool)var1_1, (int)var2_2, (DataInputStream)var3_3);
        void var3_3;
        void var2_2;
        void var1_1;
    }

    /*
     * WARNING - void declaration
     */
    private InnerClassesAttribute(ConstPool cp, byte[] info) {
        super((ConstPool)var1_1, tag, (byte[])var2_2);
        void var2_2;
        void var1_1;
    }

    /*
     * WARNING - void declaration
     */
    public InnerClassesAttribute(ConstPool cp) {
        super((ConstPool)var1_1, tag, new byte[2]);
        void var1_1;
        ByteArray.write16bit(0, this.get(), 0);
    }

    public int tableLength() {
        return ByteArray.readU16bit(this.get(), 0);
    }

    /*
     * WARNING - void declaration
     */
    public int innerClassIndex(int nth) {
        void var1_1;
        return ByteArray.readU16bit(this.get(), (int)((var1_1 << 3) + 2));
    }

    public String innerClass(int nth) {
        int n2;
        if ((n2 = this.innerClassIndex(n2)) == 0) {
            return null;
        }
        return this.constPool.getClassInfo(n2);
    }

    /*
     * WARNING - void declaration
     */
    public void setInnerClassIndex(int nth, int index) {
        void var1_1;
        ByteArray.write16bit(index, this.get(), (int)((var1_1 << 3) + 2));
    }

    /*
     * WARNING - void declaration
     */
    public int outerClassIndex(int nth) {
        void var1_1;
        return ByteArray.readU16bit(this.get(), (int)((var1_1 << 3) + 4));
    }

    public String outerClass(int nth) {
        int n2;
        if ((n2 = this.outerClassIndex(n2)) == 0) {
            return null;
        }
        return this.constPool.getClassInfo(n2);
    }

    /*
     * WARNING - void declaration
     */
    public void setOuterClassIndex(int nth, int index) {
        void var1_1;
        ByteArray.write16bit(index, this.get(), (int)((var1_1 << 3) + 4));
    }

    /*
     * WARNING - void declaration
     */
    public int innerNameIndex(int nth) {
        void var1_1;
        return ByteArray.readU16bit(this.get(), (int)((var1_1 << 3) + 6));
    }

    public String innerName(int nth) {
        int n2;
        if ((n2 = this.innerNameIndex(n2)) == 0) {
            return null;
        }
        return this.constPool.getUtf8Info(n2);
    }

    /*
     * WARNING - void declaration
     */
    public void setInnerNameIndex(int nth, int index) {
        void var1_1;
        ByteArray.write16bit(index, this.get(), (int)((var1_1 << 3) + 6));
    }

    /*
     * WARNING - void declaration
     */
    public int accessFlags(int nth) {
        void var1_1;
        return ByteArray.readU16bit(this.get(), (int)((var1_1 << 3) + 8));
    }

    /*
     * WARNING - void declaration
     */
    public void setAccessFlags(int nth, int flags) {
        void var1_1;
        ByteArray.write16bit(flags, this.get(), (int)((var1_1 << 3) + 8));
    }

    /*
     * WARNING - void declaration
     */
    public void append(String inner, String outer, String name, int flags) {
        void var3_5;
        void var2_3;
        void var1_1;
        int n2 = this.constPool.addClassInfo((String)var1_1);
        int n3 = this.constPool.addClassInfo((String)var2_3);
        int n4 = this.constPool.addUtf8Info((String)var3_5);
        this.append(n2, n3, n4, flags);
    }

    /*
     * WARNING - void declaration
     */
    public void append(int inner, int outer, int name, int flags) {
        void var3_3;
        void var2_2;
        void var1_1;
        int n2;
        byte[] byArray = this.get();
        int n3 = byArray.length;
        byte[] byArray2 = new byte[n3 + 8];
        for (n2 = 2; n2 < n3; ++n2) {
            byArray2[n2] = byArray[n2];
        }
        n2 = ByteArray.readU16bit(byArray, 0);
        ByteArray.write16bit(n2 + 1, byArray2, 0);
        ByteArray.write16bit((int)var1_1, byArray2, n3);
        ByteArray.write16bit((int)var2_2, byArray2, n3 + 2);
        ByteArray.write16bit((int)var3_3, byArray2, n3 + 4);
        ByteArray.write16bit(flags, byArray2, n3 + 6);
        this.set(byArray2);
    }

    @Override
    public AttributeInfo copy(ConstPool newCp, Map classnames) {
        byte[] byArray = this.get();
        byte[] byArray2 = new byte[byArray.length];
        ConstPool constPool = this.getConstPool();
        InnerClassesAttribute innerClassesAttribute = new InnerClassesAttribute(newCp, byArray2);
        int n2 = ByteArray.readU16bit(byArray, 0);
        ByteArray.write16bit(n2, byArray2, 0);
        int n3 = 2;
        for (int i2 = 0; i2 < n2; ++i2) {
            int n4 = ByteArray.readU16bit(byArray, n3);
            int n5 = ByteArray.readU16bit(byArray, n3 + 2);
            int n6 = ByteArray.readU16bit(byArray, n3 + 4);
            int n7 = ByteArray.readU16bit(byArray, n3 + 6);
            if (n4 != 0) {
                n4 = constPool.copy(n4, newCp, classnames);
            }
            ByteArray.write16bit(n4, byArray2, n3);
            if (n5 != 0) {
                n5 = constPool.copy(n5, newCp, classnames);
            }
            ByteArray.write16bit(n5, byArray2, n3 + 2);
            if (n6 != 0) {
                n6 = constPool.copy(n6, newCp, classnames);
            }
            ByteArray.write16bit(n6, byArray2, n3 + 4);
            ByteArray.write16bit(n7, byArray2, n3 + 6);
            n3 += 8;
        }
        return innerClassesAttribute;
    }
}

