/*
 * Decompiled with CFR 0.152.
 */
package org.apache.xalan.xsltc.trax;

import java.io.File;
import java.io.IOException;
import javax.xml.parsers.ParserConfigurationException;
import javax.xml.parsers.SAXParser;
import javax.xml.parsers.SAXParserFactory;
import javax.xml.transform.Source;
import org.apache.xalan.xsltc.compiler.util.ErrorMsg;
import org.apache.xalan.xsltc.dom.DOMBuilder;
import org.apache.xalan.xsltc.dom.DOMImpl;
import org.apache.xalan.xsltc.dom.DTDMonitor;
import org.xml.sax.InputSource;
import org.xml.sax.SAXException;
import org.xml.sax.XMLReader;

public final class XSLTCSource
implements Source {
    private String _systemId = null;
    private DOMImpl _dom = null;
    private DTDMonitor _dtd = null;
    private static final String LEXICAL_HANDLER_PROPERTY = "http://xml.org/sax/properties/lexical-handler";

    public XSLTCSource(int size) {
        this._dom = new DOMImpl(size);
        this._dtd = new DTDMonitor();
    }

    public XSLTCSource() {
        this._dom = new DOMImpl();
        this._dtd = new DTDMonitor();
    }

    public void setSystemId(String systemId) {
        this._systemId = new File(systemId).exists() ? "file:" + systemId : systemId;
        this._dom.setDocumentURI(this._systemId);
    }

    public String getSystemId() {
        return this._systemId;
    }

    public void build(XMLReader reader, String systemId) throws SAXException {
        try {
            if (systemId == null && this._systemId == null) {
                ErrorMsg err = new ErrorMsg(70);
                throw new SAXException(err.toString());
            }
            if (systemId == null) {
                systemId = this._systemId;
            }
            this.setSystemId(systemId);
            InputSource input = new InputSource(systemId);
            this._dtd.handleDTD(reader);
            DOMBuilder builder = this._dom.getBuilder();
            reader.setContentHandler(builder);
            try {
                reader.setProperty(LEXICAL_HANDLER_PROPERTY, builder);
            }
            catch (SAXException e) {
                // empty catch block
            }
            reader.parse(input);
        }
        catch (IOException e) {
            throw new SAXException(e);
        }
    }

    public void build(String systemId) throws SAXException {
        try {
            SAXParserFactory factory = SAXParserFactory.newInstance();
            SAXParser parser2 = factory.newSAXParser();
            XMLReader reader = parser2.getXMLReader();
            this.build(reader, systemId);
        }
        catch (ParserConfigurationException e) {
            throw new SAXException(e);
        }
    }

    public void build(XMLReader reader) throws SAXException {
        this.build(reader, this._systemId);
    }

    public void build() throws SAXException {
        this.build(this._systemId);
    }

    protected DOMImpl getDOM() {
        return this._dom;
    }

    protected DTDMonitor getDTD() {
        return this._dtd;
    }
}

