/*
 * Decompiled with CFR 0.152.
 */
package org.apache.xalan.xsltc.trax;

import java.util.Hashtable;
import java.util.Properties;
import java.util.Vector;
import javax.xml.parsers.SAXParserFactory;
import javax.xml.transform.ErrorListener;
import javax.xml.transform.Source;
import javax.xml.transform.Templates;
import javax.xml.transform.Transformer;
import javax.xml.transform.TransformerConfigurationException;
import javax.xml.transform.TransformerException;
import javax.xml.transform.URIResolver;
import javax.xml.transform.sax.SAXTransformerFactory;
import javax.xml.transform.sax.TemplatesHandler;
import javax.xml.transform.sax.TransformerHandler;
import org.apache.xalan.xsltc.compiler.SourceLoader;
import org.apache.xalan.xsltc.compiler.XSLTC;
import org.apache.xalan.xsltc.compiler.util.ErrorMsg;
import org.apache.xalan.xsltc.trax.TemplatesHandlerImpl;
import org.apache.xalan.xsltc.trax.TemplatesImpl;
import org.apache.xalan.xsltc.trax.TrAXFilter;
import org.apache.xalan.xsltc.trax.TransformerHandlerImpl;
import org.apache.xalan.xsltc.trax.TransformerImpl;
import org.apache.xalan.xsltc.trax.Util;
import org.xml.sax.InputSource;
import org.xml.sax.XMLFilter;
import org.xml.sax.XMLReader;

public class TransformerFactoryImpl
extends SAXTransformerFactory
implements SourceLoader,
ErrorListener {
    private ErrorListener _errorListener = this;
    private URIResolver _uriResolver = null;
    protected static String _defaultTransletName = "GregorSamsa";
    private Hashtable _piParams = null;
    private boolean _debug = false;
    private boolean _disableInlining = false;
    private int _indentNumber = -1;
    private XMLReader _xmlReader = null;

    public void setErrorListener(ErrorListener listener) throws IllegalArgumentException {
        if (listener == null) {
            ErrorMsg err = new ErrorMsg(59, "TransformerFactory");
            throw new IllegalArgumentException(err.toString());
        }
        this._errorListener = listener;
    }

    public ErrorListener getErrorListener() {
        return this._errorListener;
    }

    public Object getAttribute(String name) throws IllegalArgumentException {
        if (name.equals("translet-name")) {
            return _defaultTransletName;
        }
        ErrorMsg err = new ErrorMsg(63, name);
        throw new IllegalArgumentException(err.toString());
    }

    public void setAttribute(String name, Object value) throws IllegalArgumentException {
        if (name.equals("translet-name") && value instanceof String) {
            _defaultTransletName = (String)value;
            return;
        }
        if (name.equals("debug")) {
            if (value instanceof Boolean) {
                this._debug = (Boolean)value;
                return;
            }
            if (value instanceof String) {
                this._debug = ((String)value).equalsIgnoreCase("true");
                return;
            }
        } else if (name.equals("disable-inlining")) {
            if (value instanceof Boolean) {
                this._disableInlining = (Boolean)value;
                return;
            }
            if (value instanceof String) {
                this._disableInlining = ((String)value).equalsIgnoreCase("true");
                return;
            }
        } else if (name.equals("indent-number")) {
            if (value instanceof String) {
                try {
                    this._indentNumber = Integer.parseInt((String)value);
                    return;
                }
                catch (NumberFormatException e) {}
            } else if (value instanceof Integer) {
                this._indentNumber = (Integer)value;
                return;
            }
        }
        ErrorMsg err = new ErrorMsg(63, name);
        throw new IllegalArgumentException(err.toString());
    }

    public boolean getFeature(String name) {
        String[] features = new String[]{"http://javax.xml.transform.dom.DOMSource/feature", "http://javax.xml.transform.dom.DOMResult/feature", "http://javax.xml.transform.sax.SAXSource/feature", "http://javax.xml.transform.sax.SAXResult/feature", "http://javax.xml.transform.stream.StreamSource/feature", "http://javax.xml.transform.stream.StreamResult/feature"};
        int i = 0;
        while (i < features.length) {
            if (name.equals(features[i])) {
                return true;
            }
            ++i;
        }
        return false;
    }

    public URIResolver getURIResolver() {
        return this._uriResolver;
    }

    public void setURIResolver(URIResolver resolver) {
        this._uriResolver = resolver;
    }

    public Source getAssociatedStylesheet(Source source, String media, String title, String charset) throws TransformerConfigurationException {
        if (this._piParams == null) {
            this._piParams = new Hashtable();
        }
        this._piParams.put(source, new PIParamWrapper(media, title, charset));
        return source;
    }

    public Transformer newTransformer() throws TransformerConfigurationException {
        TransformerImpl result = new TransformerImpl(new Properties(), this._indentNumber, this);
        if (this._uriResolver != null) {
            result.setURIResolver(this._uriResolver);
        }
        return result;
    }

    public Transformer newTransformer(Source source) throws TransformerConfigurationException {
        Templates templates = this.newTemplates(source);
        Transformer transformer = templates.newTransformer();
        if (this._uriResolver != null) {
            transformer.setURIResolver(this._uriResolver);
        }
        return transformer;
    }

    private void passWarningsToListener(Vector messages) throws TransformerException {
        if (this._errorListener == null || messages == null) {
            return;
        }
        int count = messages.size();
        int pos = 0;
        while (pos < count) {
            String message = messages.elementAt(pos).toString();
            this._errorListener.error(new TransformerConfigurationException(message));
            ++pos;
        }
    }

    private void passErrorsToListener(Vector messages) {
        try {
            if (this._errorListener == null || messages == null) {
                return;
            }
            int count = messages.size();
            int pos = 0;
            while (pos < count) {
                String message = messages.elementAt(pos).toString();
                this._errorListener.error(new TransformerException(message));
                ++pos;
            }
        }
        catch (TransformerException transformerException) {
            // empty catch block
        }
    }

    public Templates newTemplates(Source source) throws TransformerConfigurationException {
        PIParamWrapper p;
        XSLTC xsltc = new XSLTC();
        if (this._debug) {
            xsltc.setDebug(true);
        }
        if (this._disableInlining) {
            xsltc.setTemplateInlining(false);
        }
        xsltc.init();
        if (this._uriResolver != null) {
            xsltc.setSourceLoader(this);
        }
        if (this._piParams != null && this._piParams.get(source) != null && (p = (PIParamWrapper)this._piParams.get(source)) != null) {
            xsltc.setPIParameters(p._media, p._title, p._charset);
        }
        InputSource input = Util.getInputSource(xsltc, source);
        byte[][] bytecodes = xsltc.compile(null, input);
        String transletName = xsltc.getClassName();
        if (this._errorListener != this) {
            try {
                this.passWarningsToListener(xsltc.getWarnings());
            }
            catch (TransformerException e) {
                throw new TransformerConfigurationException(e);
            }
        } else {
            xsltc.printWarnings();
        }
        if (bytecodes == null) {
            if (this._errorListener != null) {
                this.passErrorsToListener(xsltc.getErrors());
            } else {
                xsltc.printErrors();
            }
            ErrorMsg err = new ErrorMsg(62);
            throw new TransformerConfigurationException(err.toString());
        }
        return new TemplatesImpl(bytecodes, transletName, xsltc.getOutputProperties(), this._indentNumber, this);
    }

    public TemplatesHandler newTemplatesHandler() throws TransformerConfigurationException {
        TemplatesHandlerImpl handler = new TemplatesHandlerImpl(this._indentNumber, this);
        handler.init();
        if (this._uriResolver != null) {
            handler.setURIResolver(this._uriResolver);
        }
        return handler;
    }

    public TransformerHandler newTransformerHandler() throws TransformerConfigurationException {
        Transformer transformer = this.newTransformer();
        if (this._uriResolver != null) {
            transformer.setURIResolver(this._uriResolver);
        }
        return new TransformerHandlerImpl((TransformerImpl)transformer);
    }

    public TransformerHandler newTransformerHandler(Source src) throws TransformerConfigurationException {
        Transformer transformer = this.newTransformer(src);
        if (this._uriResolver != null) {
            transformer.setURIResolver(this._uriResolver);
        }
        return new TransformerHandlerImpl((TransformerImpl)transformer);
    }

    public TransformerHandler newTransformerHandler(Templates templates) throws TransformerConfigurationException {
        Transformer transformer = templates.newTransformer();
        TransformerImpl internal = (TransformerImpl)transformer;
        return new TransformerHandlerImpl(internal);
    }

    public XMLFilter newXMLFilter(Source src) throws TransformerConfigurationException {
        Templates templates = this.newTemplates(src);
        if (templates == null) {
            return null;
        }
        return this.newXMLFilter(templates);
    }

    public XMLFilter newXMLFilter(Templates templates) throws TransformerConfigurationException {
        try {
            return new TrAXFilter(templates);
        }
        catch (TransformerConfigurationException e1) {
            if (this._errorListener != null) {
                try {
                    this._errorListener.fatalError(e1);
                    return null;
                }
                catch (TransformerException e2) {
                    new TransformerConfigurationException(e2);
                }
            }
            throw e1;
        }
    }

    public void error(TransformerException e) throws TransformerException {
        System.err.println("ERROR: " + e.getMessageAndLocation());
        Throwable wrapped = e.getException();
        if (wrapped != null) {
            System.err.println("     : " + wrapped.getMessage());
        }
        throw e;
    }

    public void fatalError(TransformerException e) throws TransformerException {
        System.err.println("FATAL: " + e.getMessageAndLocation());
        Throwable wrapped = e.getException();
        if (wrapped != null) {
            System.err.println("     : " + wrapped.getMessage());
        }
        throw e;
    }

    public void warning(TransformerException e) throws TransformerException {
        System.err.println("WARNING: " + e.getMessageAndLocation());
        Throwable wrapped = e.getException();
        if (wrapped != null) {
            System.err.println("       : " + wrapped.getMessage());
        }
    }

    public InputSource loadSource(String href, String context, XSLTC xsltc) {
        try {
            Source source;
            if (this._uriResolver != null && (source = this._uriResolver.resolve(href, context)) != null) {
                return Util.getInputSource(xsltc, source);
            }
        }
        catch (TransformerException e) {
            // empty catch block
        }
        return null;
    }

    public XMLReader getXMLReader() throws Exception {
        if (this._xmlReader == null) {
            SAXParserFactory pfactory = SAXParserFactory.newInstance();
            pfactory.setNamespaceAware(true);
            this._xmlReader = pfactory.newSAXParser().getXMLReader();
        }
        return this._xmlReader;
    }

    private class PIParamWrapper {
        public String _media = null;
        public String _title = null;
        public String _charset = null;

        public PIParamWrapper(String media, String title, String charset) {
            this._media = media;
            this._title = title;
            this._charset = charset;
        }
    }
}

