/*
 * Decompiled with CFR 0.152.
 */
package org.apache.xalan.xsltc.runtime.output;

import org.apache.xalan.xsltc.TransletException;
import org.apache.xalan.xsltc.runtime.Constants;
import org.apache.xalan.xsltc.runtime.output.OutputBase;
import org.xml.sax.ContentHandler;
import org.xml.sax.SAXException;
import org.xml.sax.ext.LexicalHandler;
import org.xml.sax.helpers.AttributesImpl;

abstract class SAXOutput
extends OutputBase
implements Constants {
    protected ContentHandler _saxHandler;
    protected LexicalHandler _lexHandler = null;
    protected AttributesImpl _attributes = new AttributesImpl();
    protected String _elementName = null;
    protected String _encoding = null;

    public SAXOutput(ContentHandler handler, String encoding) {
        this._saxHandler = handler;
        this._encoding = encoding;
    }

    public SAXOutput(ContentHandler hdler, LexicalHandler lex, String encoding) {
        this._saxHandler = hdler;
        this._lexHandler = lex;
        this._encoding = encoding;
    }

    public void startDocument() throws TransletException {
        try {
            this._saxHandler.startDocument();
        }
        catch (SAXException e) {
            throw new TransletException(e);
        }
    }

    public void characters(String characters) throws TransletException {
        this.characters(characters.toCharArray(), 0, characters.length());
    }

    public void comment(String comment) throws TransletException {
        try {
            if (this._startTagOpen) {
                this.closeStartTag();
            } else if (this._cdataTagOpen) {
                this.closeCDATA();
            }
            if (this._lexHandler != null) {
                this._lexHandler.comment(comment.toCharArray(), 0, comment.length());
            }
        }
        catch (SAXException e) {
            throw new TransletException(e);
        }
    }

    public void processingInstruction(String target, String data) throws TransletException {
    }

    protected void closeStartTag() throws TransletException {
    }

    protected void closeCDATA() throws SAXException {
    }
}

