/*
 * Decompiled with CFR 0.152.
 */
package org.apache.xalan.xsltc.dom;

import org.apache.xalan.xsltc.DOM;
import org.apache.xalan.xsltc.NodeIterator;
import org.apache.xalan.xsltc.Translet;
import org.apache.xalan.xsltc.dom.NodeCounter;
import org.apache.xalan.xsltc.util.IntegerArray;

public abstract class MultipleNodeCounter
extends NodeCounter {
    private NodeIterator _precSiblings = null;

    public MultipleNodeCounter(Translet translet, DOM document, NodeIterator iterator) {
        super(translet, document, iterator);
    }

    public NodeCounter setStartNode(int node) {
        this._node = node;
        this._nodeType = this._document.getType(node);
        this._precSiblings = this._document.getAxisIterator(12);
        return this;
    }

    public String getCounter() {
        if (this._value != Integer.MIN_VALUE) {
            return this.formatNumbers(this._value);
        }
        IntegerArray ancestors = new IntegerArray();
        int next = this._node;
        ancestors.add(next);
        while ((next = this._document.getParent(next)) > 0 && !this.matchesFrom(next)) {
            ancestors.add(next);
        }
        int nAncestors = ancestors.cardinality();
        int[] counters = new int[nAncestors];
        int i = 0;
        while (i < nAncestors) {
            counters[i] = Integer.MIN_VALUE;
            ++i;
        }
        int j = 0;
        int i2 = nAncestors - 1;
        while (i2 >= 0) {
            int counter = counters[j];
            int ancestor = ancestors.at(i2);
            if (this.matchesCount(ancestor)) {
                this._precSiblings.setStartNode(ancestor);
                while ((next = this._precSiblings.next()) != 0) {
                    if (!this.matchesCount(next)) continue;
                    int n = counters[j] = counters[j] == Integer.MIN_VALUE ? 1 : counters[j] + 1;
                }
                counters[j] = counters[j] == Integer.MIN_VALUE ? 1 : counters[j] + 1;
            }
            --i2;
            ++j;
        }
        return this.formatNumbers(counters);
    }

    public static NodeCounter getDefaultNodeCounter(Translet translet, DOM document, NodeIterator iterator) {
        return new DefaultMultipleNodeCounter(translet, document, iterator);
    }

    static class DefaultMultipleNodeCounter
    extends MultipleNodeCounter {
        public DefaultMultipleNodeCounter(Translet translet, DOM document, NodeIterator iterator) {
            super(translet, document, iterator);
        }
    }
}

