/*
 * Decompiled with CFR 0.152.
 */
package org.apache.xalan.xsltc.compiler;

import org.apache.bcel.generic.ALOAD;
import org.apache.bcel.generic.ASTORE;
import org.apache.bcel.generic.BranchHandle;
import org.apache.bcel.generic.ConstantPoolGen;
import org.apache.bcel.generic.IFNONNULL;
import org.apache.bcel.generic.IFNULL;
import org.apache.bcel.generic.INVOKEINTERFACE;
import org.apache.bcel.generic.INVOKESTATIC;
import org.apache.bcel.generic.InstructionConstants;
import org.apache.bcel.generic.InstructionList;
import org.apache.bcel.generic.LocalVariableGen;
import org.apache.bcel.generic.PUSH;
import org.apache.xalan.xsltc.compiler.AttributeValueTemplate;
import org.apache.xalan.xsltc.compiler.Instruction;
import org.apache.xalan.xsltc.compiler.Parser;
import org.apache.xalan.xsltc.compiler.QName;
import org.apache.xalan.xsltc.compiler.SymbolTable;
import org.apache.xalan.xsltc.compiler.SyntaxTreeNode;
import org.apache.xalan.xsltc.compiler.UseAttributeSets;
import org.apache.xalan.xsltc.compiler.XslAttribute;
import org.apache.xalan.xsltc.compiler.util.ClassGenerator;
import org.apache.xalan.xsltc.compiler.util.ErrorMsg;
import org.apache.xalan.xsltc.compiler.util.MethodGenerator;
import org.apache.xalan.xsltc.compiler.util.Type;
import org.apache.xalan.xsltc.compiler.util.TypeCheckError;
import org.apache.xalan.xsltc.compiler.util.Util;

final class XslElement
extends Instruction {
    private String _prefix;
    private boolean _ignore = false;
    private boolean _isLiteralName = true;
    private AttributeValueTemplate _name;
    private AttributeValueTemplate _namespace;

    XslElement() {
    }

    public void display(int indent) {
        this.indent(indent);
        Util.println("Element " + this._name);
        this.displayContents(indent + 4);
    }

    public boolean declaresDefaultNS() {
        return false;
    }

    private boolean isLiteral(String str) {
        int length = str.length();
        int i = 0;
        while (i < length) {
            if (str.charAt(i) == '{' && str.charAt(i + 1) != '{') {
                return false;
            }
            ++i;
        }
        return true;
    }

    private boolean isLegalName(String str) {
        if (str.indexOf(32) > -1) {
            return false;
        }
        int colon = str.indexOf(58);
        if (colon == 0 || colon == str.length() - 1) {
            return false;
        }
        char first = str.charAt(0);
        return Character.isLetter(first) || first == '_';
    }

    public void parseContents(Parser parser2) {
        SymbolTable stable = parser2.getSymbolTable();
        String name = this.getAttribute("name");
        if (name == "") {
            ErrorMsg msg = new ErrorMsg(36, (Object)name, this);
            parser2.reportError(4, msg);
            this.parseChildren(parser2);
            this._ignore = true;
            return;
        }
        String namespace = this.getAttribute("namespace");
        this._isLiteralName = this.isLiteral(name);
        if (this._isLiteralName) {
            if (!this.isLegalName(name)) {
                ErrorMsg msg = new ErrorMsg(36, (Object)name, this);
                parser2.reportError(4, msg);
                this.parseChildren(parser2);
                this._ignore = true;
                return;
            }
            QName qname = parser2.getQNameSafe(name);
            String prefix = qname.getPrefix();
            String local = qname.getLocalPart();
            if (prefix == null) {
                prefix = "";
            }
            if (!this.hasAttribute("namespace")) {
                namespace = this.lookupNamespace(prefix);
                if (namespace == null) {
                    ErrorMsg err = new ErrorMsg(12, (Object)prefix, this);
                    parser2.reportError(4, err);
                    this.parseChildren(parser2);
                    this._ignore = true;
                    return;
                }
                this._prefix = prefix;
                this._namespace = new AttributeValueTemplate(namespace, parser2, this);
            } else {
                if (prefix == "") {
                    if (this.isLiteral(namespace) && (prefix = this.lookupPrefix(namespace)) == null) {
                        prefix = stable.generateNamespacePrefix();
                    }
                    StringBuffer newName = new StringBuffer(prefix);
                    if (prefix != "") {
                        newName.append(':');
                    }
                    name = newName.append(local).toString();
                }
                this._prefix = prefix;
                this._namespace = new AttributeValueTemplate(namespace, parser2, this);
            }
        } else {
            this._namespace = namespace == "" ? null : new AttributeValueTemplate(namespace, parser2, this);
        }
        this._name = new AttributeValueTemplate(name, parser2, this);
        String useSets = this.getAttribute("use-attribute-sets");
        if (useSets.length() > 0) {
            this.setFirstElement(new UseAttributeSets(useSets, parser2));
        }
        this.parseChildren(parser2);
    }

    public Type typeCheck(SymbolTable stable) throws TypeCheckError {
        if (!this._ignore) {
            this._name.typeCheck(stable);
            if (this._namespace != null) {
                this._namespace.typeCheck(stable);
            }
        }
        this.typeCheckContents(stable);
        return Type.Void;
    }

    public void translateLiteral(ClassGenerator classGen, MethodGenerator methodGen) {
        ConstantPoolGen cpg = classGen.getConstantPool();
        InstructionList il = methodGen.getInstructionList();
        if (!this._ignore) {
            il.append(methodGen.loadHandler());
            this._name.translate(classGen, methodGen);
            il.append(InstructionConstants.DUP2);
            il.append(methodGen.startElement());
            if (this._namespace != null) {
                il.append(methodGen.loadHandler());
                il.append(new PUSH(cpg, this._prefix));
                this._namespace.translate(classGen, methodGen);
                il.append(methodGen.namespace());
            }
        }
        this.translateContents(classGen, methodGen);
        if (!this._ignore) {
            il.append(methodGen.endElement());
        }
    }

    public void translate(ClassGenerator classGen, MethodGenerator methodGen) {
        LocalVariableGen local = null;
        ConstantPoolGen cpg = classGen.getConstantPool();
        InstructionList il = methodGen.getInstructionList();
        if (this._isLiteralName) {
            this.translateLiteral(classGen, methodGen);
            return;
        }
        if (!this._ignore) {
            il.append(methodGen.loadHandler());
            this._name.translate(classGen, methodGen);
            il.append(InstructionConstants.DUP);
            int getPrefix = cpg.addMethodref("org.apache.xalan.xsltc.runtime.BasisLibrary", "getPrefix", "(Ljava/lang/String;)Ljava/lang/String;");
            il.append(new INVOKESTATIC(getPrefix));
            il.append(InstructionConstants.DUP);
            local = methodGen.addLocalVariable("prefix", org.apache.bcel.generic.Type.STRING, il.getEnd(), null);
            il.append(new ASTORE(local.getIndex()));
            BranchHandle ifNotNull = il.append(new IFNONNULL(null));
            if (this._namespace != null) {
                int generatePrefix = cpg.addMethodref("org.apache.xalan.xsltc.runtime.BasisLibrary", "generatePrefix", "()Ljava/lang/String;");
                il.append(new INVOKESTATIC(generatePrefix));
                il.append(InstructionConstants.DUP);
                il.append(new ASTORE(local.getIndex()));
                int makeQName = cpg.addMethodref("org.apache.xalan.xsltc.runtime.BasisLibrary", "makeQName", "(Ljava/lang/String;Ljava/lang/String;)Ljava/lang/String;");
                il.append(new INVOKESTATIC(makeQName));
            }
            ifNotNull.setTarget(il.append(InstructionConstants.DUP2));
            il.append(methodGen.startElement());
            if (this._namespace != null) {
                il.append(methodGen.loadHandler());
                il.append(new ALOAD(local.getIndex()));
                this._namespace.translate(classGen, methodGen);
                il.append(methodGen.namespace());
            } else {
                il.append(new ALOAD(local.getIndex()));
                BranchHandle ifNull = il.append(new IFNULL(null));
                il.append(methodGen.loadHandler());
                il.append(new ALOAD(local.getIndex()));
                il.append(methodGen.loadDOM());
                il.append(methodGen.loadCurrentNode());
                il.append(new ALOAD(local.getIndex()));
                int lookupNamespace = cpg.addInterfaceMethodref("org.apache.xalan.xsltc.DOM", "lookupNamespace", "(ILjava/lang/String;)Ljava/lang/String;");
                il.append(new INVOKEINTERFACE(lookupNamespace, 3));
                il.append(methodGen.namespace());
                ifNull.setTarget(il.append(InstructionConstants.NOP));
            }
        }
        this.translateContents(classGen, methodGen);
        if (!this._ignore) {
            il.append(methodGen.endElement());
        }
    }

    public void translateContents(ClassGenerator classGen, MethodGenerator methodGen) {
        int n = this.elementCount();
        int i = 0;
        while (i < n) {
            SyntaxTreeNode item = (SyntaxTreeNode)this.getContents().elementAt(i);
            if (!this._ignore || !(item instanceof XslAttribute)) {
                item.translate(classGen, methodGen);
            }
            ++i;
        }
    }
}

