/*
 * Decompiled with CFR 0.152.
 */
package com.borland.jbcl.control;

import com.borland.jb.util.ChainedException;
import com.borland.jb.util.ExceptionChain;
import com.borland.jbcl.control.ButtonDialog;
import com.borland.jbcl.control.FieldControl;
import com.borland.jbcl.control.TextAreaControl;
import com.borland.jbcl.model.BasicSingletonContainer;
import com.borland.jbcl.model.BasicViewManager;
import com.borland.jbcl.view.WrappedTextItemPainter;
import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.Frame;
import java.awt.Panel;
import java.awt.Rectangle;
import java.awt.SystemColor;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.WindowEvent;
import java.io.ByteArrayOutputStream;
import java.io.PrintStream;
import java.io.Serializable;
import java.util.Vector;

public class ExceptionDialog
extends ButtonDialog
implements ActionListener,
Serializable {
    private FieldControl message = new FieldControl();
    private TextAreaControl details = new TextAreaControl();
    private Panel centerPanel = new Panel();
    private boolean showDetails = false;
    private int detailHeight = 200;
    private int position;
    private transient Vector exceptionVector;
    private transient Throwable ex;
    private static int showCount;
    private transient Component returnFocusComponent;

    private static int makeButtonSet(Exception ex) {
        if (ex instanceof ChainedException && ((ChainedException)ex).getExceptionChain() != null) {
            return 897;
        }
        return 513;
    }

    public ExceptionDialog(Frame frame, String title, Exception ex, boolean modal) {
        super(frame, title, modal, null, null, ButtonDialog.buttonSetToButtonDescriptors(ExceptionDialog.makeButtonSet(ex)));
        this.ex = ex;
        this.details.setEditable(false);
        this.details.setBackground(SystemColor.window);
        this.details.setPreferredHeight(200);
        this.message.setPreferredHeight(100);
        this.message.setPreferredWidth(400);
        this.message.setModel(new BasicSingletonContainer());
        this.message.setAlignment(1);
        this.message.setViewManager(new BasicViewManager(new WrappedTextItemPainter(null, 1, 0), null));
        this.makeExceptionList(ex);
        this.getContentPane().setLayout(new BorderLayout());
        this.centerPanel.setLayout(new BorderLayout());
        this.centerPanel.add((Component)this.message, "Center");
        this.centerPanel.add((Component)this.buttonPanel, "South");
        this.getContentPane().add((Component)this.centerPanel, "Center");
        this.setBackground(SystemColor.control);
        this.pack();
        this.setEnterOK(true);
        this.displayException(0);
        ++showCount;
    }

    public ExceptionDialog(Frame frame, String title, Exception ex) {
        this(frame, title, ex, false);
    }

    public ExceptionDialog(Frame frame, String title, Exception ex, Component c2) {
        this(frame, title, ex, false);
        this.returnFocusComponent = c2;
    }

    public ExceptionDialog(Frame frame, String title, Exception ex, boolean modal, Component c2) {
        this(frame, title, ex, modal);
        this.returnFocusComponent = c2;
    }

    protected void processActionEvent(ActionEvent e2) {
        super.processActionEvent(e2);
        if (this.result != null) {
            if (this.result.closeDialog) {
                --showCount;
                if (this.returnFocusComponent != null) {
                    this.returnFocusComponent.requestFocus();
                    this.returnFocusComponent = null;
                }
            }
            if (this.result.command.equals("next") && this.position < this.exceptionVector.size() - 1) {
                this.displayException(++this.position);
            }
            if (this.result.command.equals("previous") && this.position > 0) {
                this.displayException(--this.position);
            }
            if (this.result.command.equals("details")) {
                if (!this.showDetails) {
                    Dimension dim = this.getSize();
                    Rectangle rect = this.centerPanel.getBounds();
                    this.remove(this.centerPanel);
                    this.getContentPane().add((Component)this.centerPanel, "North");
                    this.getContentPane().add((Component)this.details, "Center");
                    this.details.setBounds(rect.x, rect.y + rect.height, rect.width, this.detailHeight);
                    this.setSize(dim.width, dim.height + this.detailHeight);
                } else {
                    Dimension dim = this.getSize();
                    this.detailHeight = this.details.getSize().height;
                    this.remove(this.details);
                    this.remove(this.centerPanel);
                    this.getContentPane().add((Component)this.centerPanel, "Center");
                    this.setSize(dim.width, dim.height - this.detailHeight);
                }
                this.showDetails = !this.showDetails;
            }
        }
    }

    protected void processWindowEvent(WindowEvent e2) {
        super.processWindowEvent(e2);
        if (e2.getID() == 201) {
            this.processActionEvent(new ActionEvent(this, 1001, "ok"));
        }
    }

    private void displayException(int pos) {
        this.enableButton("previous", this.position > 0);
        this.enableButton("next", this.position < this.exceptionVector.size() - 1);
        Exception ex = (Exception)this.exceptionVector.elementAt(pos);
        String messageString = ex.getMessage();
        if (messageString == null || messageString.length() < 1) {
            messageString = ex.getClass().getName();
        }
        this.message.setText(messageString);
        ByteArrayOutputStream byteStream = new ByteArrayOutputStream(512);
        PrintStream printStream = new PrintStream(byteStream);
        ex.printStackTrace(printStream);
        printStream.flush();
        this.details.setText(byteStream.toString());
    }

    private void makeExceptionList(Throwable ex) {
        this.exceptionVector = new Vector();
        this.exceptionVector.addElement(ex);
        if (ex instanceof ChainedException) {
            for (ExceptionChain chain = ((ChainedException)ex).getExceptionChain(); chain != null; chain = chain.getNext()) {
                ex = chain.getException();
                this.exceptionVector.addElement(ex);
            }
        }
        this.position = 0;
    }

    public static int getShowCount() {
        return showCount;
    }
}

