/*
 * Decompiled with CFR 0.152.
 */
package dbmaster.xml.xttnode;

import dbmaster.xml.DisplaySetting;
import dbmaster.xml.XttEnv;
import dbmaster.xml.XttMessageUtil;
import java.io.IOException;
import java.io.OutputStreamWriter;
import org.w3c.dom.Attr;
import org.w3c.dom.Element;
import startup.ToolInfo;

public abstract class VirtualTreeObject {
    public static final String XTT_NAMESPACE = "urn:schema-" + ToolInfo.getProductName() + "-com:xml-template";
    public static final String XTT_TEMPLATE = "template";
    public static final String XTT_PARAMETER = "parameter";
    public static final String XTT_QUERY = "query";
    public static final String XTT_COMMAND = "command";
    public static final String XTT_TEXTVALUE = "textvalue";
    public static final String XTT_ATTRIBUTE = "attribute";
    public static final String XTT_ENCODING = "encoding";
    public static final String XTT_NAME = "name";
    public static final String XTT_DEFAULT = "default";
    public static final String XTT_VALUE = "value";
    public static final String XTT_HEADER = "header";
    public static final String NAME = "name";
    public static final String DEFAULT = "default";
    public static final String VALUE = "value";
    public static final String COMMAND = "command";
    public static final int XTT_NOT_DSP_ATTR = -1;
    XttEnv env = null;
    int scope = 0;
    DisplaySetting display = null;
    String xpath = null;

    public abstract int initialize(Element var1, String var2, int var3) throws IOException;

    public abstract int run(OutputStreamWriter var1) throws Exception;

    public abstract int setXPath(String var1, String var2, int var3);

    VirtualTreeObject(XttEnv xttEnv, int n) {
        this.env = xttEnv;
        this.scope = n;
    }

    public DisplaySetting getDisplaySetting() {
        if (this.display != null) {
            return this.display;
        }
        return this.env.getDisplaySetting();
    }

    public XttEnv getXttEnv() {
        return this.env;
    }

    public String getXPath() {
        return this.xpath;
    }

    public boolean isXttNode(Element element) {
        String string = element.getNamespaceURI();
        return string != null && string.compareTo(XTT_NAMESPACE) == 0;
    }

    int setDisplaySettingOptions(String string, String string2) throws IOException {
        int n = 0;
        n = string.compareTo("display_mode") == 0 ? this.setDisplayMode(string2) : (string.compareTo("null_handling") == 0 ? this.setNullHandling(string2) : (string.compareTo("lo_mode") == 0 ? this.setLoMode(string2) : (string.compareTo("fo_mode") == 0 ? this.setFoMode(string2) : (string.compareTo("abbreviation") == 0 ? this.setAbbreviation(string2) : (string.compareTo("linebreak") == 0 ? this.setLineBreak(string2) : (string.compareTo("indent") == 0 ? this.setIndent(string2) : (string.compareTo("linebreakchar") == 0 ? this.setLineBreakChar(string2) : -1)))))));
        return n;
    }

    int initDisplaySetting(Element element) throws IOException {
        int n = 0;
        Attr attr = null;
        Object var4_4 = null;
        DisplaySetting displaySetting = this.env.getDisplaySetting();
        attr = element.getAttributeNodeNS(XTT_NAMESPACE, "display_mode");
        if (attr != null && (n = this.setDisplayMode(attr.getValue())) != 0) {
            return n;
        }
        attr = element.getAttributeNodeNS(XTT_NAMESPACE, "null_handling");
        if (attr != null && (n = this.setNullHandling(attr.getValue())) != 0) {
            return n;
        }
        attr = element.getAttributeNodeNS(XTT_NAMESPACE, "lo_mode");
        if (attr != null && (n = this.setLoMode(attr.getValue())) != 0) {
            return n;
        }
        attr = element.getAttributeNodeNS(XTT_NAMESPACE, "fo_mode");
        if (attr != null && (n = this.setFoMode(attr.getValue())) != 0) {
            return n;
        }
        attr = element.getAttributeNodeNS(XTT_NAMESPACE, "abbreviation");
        if (attr != null && (n = this.setAbbreviation(attr.getValue())) != 0) {
            return n;
        }
        attr = element.getAttributeNodeNS(XTT_NAMESPACE, "linebreak");
        if (attr != null && (n = this.setLineBreak(attr.getValue())) != 0) {
            return n;
        }
        attr = element.getAttributeNodeNS(XTT_NAMESPACE, "indent");
        if (attr != null && (n = this.setIndent(attr.getValue())) != 0) {
            return n;
        }
        attr = element.getAttributeNodeNS(XTT_NAMESPACE, "linebreakchar");
        if (attr != null && (n = this.setLineBreakChar(attr.getValue())) != 0) {
            return n;
        }
        return n;
    }

    int setDisplayMode(String string) {
        int n = 0;
        DisplaySetting displaySetting = this.env.getDisplaySetting();
        if (this.display == null) {
            this.display = new DisplaySetting(displaySetting);
        }
        if (string.compareTo("0") == 0) {
            this.display.display_mode = DisplaySetting.DisplayModeOption.REGULAR;
        } else if (string.compareTo("1") == 0) {
            this.display.display_mode = DisplaySetting.DisplayModeOption.CDATA;
        } else if (string.compareTo("2") == 0) {
            this.display.display_mode = DisplaySetting.DisplayModeOption.XMLDATA;
        } else {
            n = 90;
        }
        return n;
    }

    int setNullHandling(String string) {
        int n = 0;
        DisplaySetting displaySetting = this.env.getDisplaySetting();
        if (this.display == null) {
            this.display = new DisplaySetting(displaySetting);
        }
        if (string.compareTo("0") == 0) {
            this.display.null_handling = DisplaySetting.NullHandlingOption.SKIP_NULL;
        } else if (string.compareTo("1") == 0) {
            this.display.null_handling = DisplaySetting.NullHandlingOption.EMPTY_STRING;
        } else if (string.compareTo("2") == 0) {
            this.display.null_handling = DisplaySetting.NullHandlingOption.NULL_STRING;
        } else {
            n = 91;
        }
        return n;
    }

    int setLoMode(String string) {
        int n = 0;
        DisplaySetting displaySetting = this.env.getDisplaySetting();
        if (this.display == null) {
            this.display = new DisplaySetting(displaySetting);
        }
        if (string.compareTo("0") == 0) {
            this.display.lo_mode = DisplaySetting.LoModeOption.INLINE;
        } else if (string.compareTo("1") == 0) {
            this.display.lo_mode = DisplaySetting.LoModeOption.CREATE_EXTERNAL;
        } else {
            n = 92;
        }
        return n;
    }

    int setFoMode(String string) {
        int n = 0;
        DisplaySetting displaySetting = this.env.getDisplaySetting();
        if (this.display == null) {
            this.display = new DisplaySetting(displaySetting);
        }
        if (string.compareTo("0") == 0) {
            this.display.fo_mode = DisplaySetting.FoModeOption.FILE_NAME;
        } else if (string.compareTo("1") == 0) {
            this.display.fo_mode = DisplaySetting.FoModeOption.AS_BLOB;
        } else {
            n = 93;
        }
        return n;
    }

    int setAbbreviation(String string) {
        int n = 0;
        DisplaySetting displaySetting = this.env.getDisplaySetting();
        if (this.display == null) {
            this.display = new DisplaySetting(displaySetting);
        }
        if (string.compareTo("0") == 0) {
            this.display.abbreviation = DisplaySetting.AbbreviationOption.SHOW_BOTH;
        } else if (string.compareTo("1") == 0) {
            this.display.abbreviation = DisplaySetting.AbbreviationOption.REDUCE_END;
        } else if (string.compareTo("2") == 0) {
            this.display.abbreviation = DisplaySetting.AbbreviationOption.REDUCE_BOTH;
        } else {
            n = 94;
        }
        return n;
    }

    int setLineBreak(String string) {
        int n = 0;
        DisplaySetting displaySetting = this.env.getDisplaySetting();
        if (this.display == null) {
            this.display = new DisplaySetting(displaySetting);
        }
        if (string.compareTo("0") == 0) {
            this.display.linebreak = DisplaySetting.LineBreakOption.LNBK_NONE;
        } else if (string.compareTo("1") == 0) {
            this.display.linebreak = DisplaySetting.LineBreakOption.LNBK_END;
        } else if (string.compareTo("2") == 0) {
            this.display.linebreak = DisplaySetting.LineBreakOption.LNBK_BOTH;
        } else {
            n = 96;
        }
        return n;
    }

    int setLineBreakChar(String string) throws IOException {
        int n = 0;
        DisplaySetting displaySetting = this.env.getDisplaySetting();
        if (this.display == null) {
            this.display = new DisplaySetting(displaySetting);
        }
        if (string == null || string.length() <= 0) {
            return n;
        }
        if (string.compareTo("0") == 0 || string.compareTo("CR") == 0) {
            this.display.linebreakchar = "\r";
        } else if (string.compareTo("1") == 0 || string.compareTo("LF") == 0) {
            this.display.linebreakchar = "\n";
        } else if (string.compareTo("2") == 0 || string.compareTo("CRLF") == 0) {
            this.display.linebreakchar = "\r\n";
        } else {
            OutputStreamWriter outputStreamWriter = this.env.getErrorOutputStreamWriter();
            outputStreamWriter.write("error line break char.\n");
            n = 97;
            return 97;
        }
        return n;
    }

    int setIndent(String string) {
        int n = 0;
        DisplaySetting displaySetting = this.env.getDisplaySetting();
        if (this.display == null) {
            this.display = new DisplaySetting(displaySetting);
        }
        if (string != null) {
            try {
                this.display.indent = Integer.parseInt(string);
            }
            catch (Exception exception) {
                n = 95;
            }
        }
        return n;
    }

    void invalidAttribute(String string, String string2) throws IOException {
        OutputStreamWriter outputStreamWriter = this.env.getErrorOutputStreamWriter();
        String string3 = null;
        string3 = this.xpath != null ? XttMessageUtil.formatMessage("ERR_INVALID_ATTR_XPATH", string, this.xpath) : XttMessageUtil.formatMessage("ERR_INVALID_ATTR_XPATH", string, string2);
        outputStreamWriter.write(string3);
    }

    void invalidElement(String string, String string2) throws IOException {
        OutputStreamWriter outputStreamWriter = this.env.getErrorOutputStreamWriter();
        String string3 = null;
        string3 = this.xpath != null ? XttMessageUtil.formatMessage("ERR_INVALID_ELM_XPATH", string, this.xpath) : XttMessageUtil.formatMessage("ERR_INVALID_ELM_XPATH", string, string2);
        outputStreamWriter.write(string3);
    }
}

