/*
 * Decompiled with CFR 0.152.
 */
package dbmaster.xml;

import dbaut.dbalib;
import dbmaster.sql.JdbcOdbcConnection;
import dbmaster.xml.DOMTreeErrorReporter;
import dbmaster.xml.DisplaySetting;
import dbmaster.xml.XttMessageUtil;
import dbmaster.xml.parameter.ParameterParser;
import dbmaster.xml.symtb.SymbolicObject;
import dbmaster.xml.symtb.SymbolicTable;
import dbmaster.xml.xttnode.TemplateNode;
import java.io.ByteArrayOutputStream;
import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.OutputStream;
import java.io.OutputStreamWriter;
import java.sql.Connection;
import java.util.Hashtable;
import javax.xml.parsers.DocumentBuilder;
import javax.xml.parsers.DocumentBuilderFactory;
import org.w3c.dom.Attr;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.w3c.dom.NamedNodeMap;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;
import org.xml.sax.InputSource;

public class XttEnv {
    public static final int ENC_XTT = 16;
    public static final int ENC_DB_LOCALE_CODE = 16;
    public static final int ENC_UTF8_CODE = 17;
    public static final int ENC_UTF16LE_CODE = 18;
    public static final int ENC_UTF16BE_CODE = 19;
    public static final String ENC_DB_LOCALE = "DB_LOCALE";
    public static final String ENC_UTF_16LE = "UTF-16LE";
    public static final String ENC_UTF16LE = "UTF16LE";
    public static final String ENC_UTF_16BE = "UTF-16BE";
    public static final String ENC_UTF16BE = "UTF16BE";
    public static final String ENC_UTF_16 = "UTF-16";
    public static final String ENC_UTF16 = "UTF16";
    public static final String ENC_UTF_8 = "UTF-8";
    public static final String ENC_UTF8 = "UTF8";
    public static final String ANY_NODE = "*";
    public static final String[] ENC_LOCAL_STR = new String[]{"US-ASCII", "Big5", "SHIFT_JIS", "GB2312", "ISO-8859-1", "ISO-8859-2", "ISO-8859-5", "ISO-8859-7"};
    public static final String LO_DIR = "lobdir";
    public static final String CLOB_FILE = "clobfile";
    public static final String BLOB_FILE = "blobfile";
    public static final String CLOB_FILE_EXT = "txt";
    public static final String BLOB_FILE_EXT = "tmp";
    public static final int MAX_FILES_IN_FOLDER = 8192;
    private Hashtable params = null;
    private int encoding = 16;
    private long hdbc;
    private Connection connection = null;
    private InputSource xttfile;
    private OutputStreamWriter xmlOutputStreamWriter;
    private OutputStream xmlOutputStream;
    private ByteArrayOutputStream errOutputStream;
    private OutputStreamWriter errOutputStreamWriter;
    private DisplaySetting display;
    private TemplateNode root;
    private String xmlfilename;
    private String path;
    private int codeid;
    private boolean doHeader = true;
    private boolean prepared;
    private SymbolicTable symtb = null;
    public static char SLASH;
    public static char SLASH2;
    public static String NEWLINE;
    public static String SLASHSTR;
    private int dir_cnt = 0;
    private int blob_cnt = 0;
    private int clob_cnt = 0;

    public XttEnv() {
        if (SLASH == '\u0000') {
            XttEnv.initPlatformInfo();
        }
    }

    private static boolean isWindowsPlatform() {
        String string = System.getProperty("os.name");
        return string != null && string.startsWith("Windows");
    }

    private static void initPlatformInfo() {
        if (NEWLINE != null) {
            return;
        }
        if (XttEnv.isWindowsPlatform()) {
            SLASH = (char)92;
            SLASH2 = (char)47;
            NEWLINE = "\r\n";
            SLASHSTR = "\\";
        } else {
            SLASH = (char)47;
            SLASH2 = (char)92;
            NEWLINE = "\n";
            SLASHSTR = "/";
        }
    }

    private boolean isFullPath(String string, int n) {
        if (string == null) {
            return false;
        }
        if (n != 0) {
            n = string.length();
        }
        char[] cArray = string.toCharArray();
        if (XttEnv.isWindowsPlatform()) {
            if (n < 3) {
                return false;
            }
            return cArray[1] == ':' && (cArray[2] == SLASH || cArray[2] == SLASH2) || cArray[0] == SLASH && cArray[1] == SLASH;
        }
        return n >= 1 && cArray[0] == SLASH;
    }

    private String getFilePath(String string) {
        String string2;
        boolean bl = false;
        int n = -1;
        String string3 = null;
        if (string != null && (n = string.lastIndexOf(SLASH)) < 0) {
            n = string.lastIndexOf(SLASH2);
        }
        if (!(string2 = System.getProperty("user.dir")).endsWith(SLASHSTR)) {
            string2 = string2 + SLASH;
        }
        string3 = n < 0 ? string2 : (this.isFullPath(string, string.length()) ? string.substring(0, n + 1) : string2 + string.substring(0, n + 1));
        return string3;
    }

    public static void printElement(Element element) {
        Node node = null;
        String string = null;
        String string2 = null;
        String string3 = null;
        NamedNodeMap namedNodeMap = element.getAttributes();
        int n = namedNodeMap.getLength();
        for (int i = 0; i < n; ++i) {
            node = namedNodeMap.item(i);
            if (node.getNodeType() != 2) continue;
            string = ((Attr)node).getNamespaceURI();
            string2 = ((Attr)node).getLocalName();
            string3 = ((Attr)node).getValue();
            System.out.println("attns=" + string);
            System.out.println("attname=" + string2);
            System.out.println("attvalue=" + string3);
        }
        NodeList nodeList = element.getChildNodes();
        n = nodeList.getLength();
        for (int i = 0; i < n; ++i) {
            node = nodeList.item(i);
            if (node.getNodeType() != 1) continue;
            XttEnv.printElement((Element)node);
        }
    }

    public int prepare(InputSource inputSource) throws Exception {
        Object object;
        Object object2;
        int n = 0;
        this.xttfile = inputSource;
        Document document = null;
        OutputStreamWriter outputStreamWriter = this.getErrorOutputStreamWriter();
        try {
            object2 = DocumentBuilderFactory.newInstance();
            ((DocumentBuilderFactory)object2).setIgnoringElementContentWhitespace(true);
            ((DocumentBuilderFactory)object2).setNamespaceAware(true);
            ((DocumentBuilderFactory)object2).setIgnoringComments(true);
            ((DocumentBuilderFactory)object2).setValidating(false);
            ((DocumentBuilderFactory)object2).setExpandEntityReferences(false);
            object = ((DocumentBuilderFactory)object2).newDocumentBuilder();
            DOMTreeErrorReporter dOMTreeErrorReporter = new DOMTreeErrorReporter();
            ((DocumentBuilder)object).setErrorHandler(dOMTreeErrorReporter);
            this.display = new DisplaySetting();
            this.path = this.getFilePath(this.xmlfilename);
            document = ((DocumentBuilder)object).parse(this.xttfile);
        }
        catch (Exception exception) {
            this.errOutputStreamWriter.write(XttMessageUtil.formatMessage("ERR_PARSING") + "\nException message:" + exception.getMessage());
            n = 35;
            return 35;
        }
        if (document == null) {
            this.errOutputStreamWriter.write(XttMessageUtil.formatMessage("ERR_DOM_ERROR"));
            n = 34;
            return 34;
        }
        object2 = new dbalib();
        this.codeid = ((dbalib)object2).getLicLCode();
        try {
            object = document.getDocumentElement();
            if (object == null) {
                this.errOutputStreamWriter.write(XttMessageUtil.formatMessage("XTT_INVALID_TEMPLATE"));
                n = 66;
                return 66;
            }
            this.root = new TemplateNode(this, 0);
            n = this.root.initialize((Element)object, null, 0);
            if (n != 0) {
                return n;
            }
            if (this.encoding == 16) {
                this.encoding = this.codeid;
            }
        }
        catch (IOException iOException) {
            System.err.println(iOException.getMessage());
            iOException.printStackTrace();
        }
        return n;
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public int run() throws Exception {
        OutputStream outputStream;
        int n;
        block17: {
            n = 0;
            this.dir_cnt = 0;
            this.clob_cnt = 0;
            this.blob_cnt = 0;
            OutputStreamWriter outputStreamWriter = this.getErrorOutputStreamWriter();
            outputStream = this.getXmlOutputStream();
            try {
                try {
                    this.xmlOutputStreamWriter = new OutputStreamWriter(outputStream, this.getEncodingStr());
                }
                catch (Exception exception) {
                    this.xmlOutputStreamWriter = new OutputStreamWriter(outputStream);
                }
                if (this.encoding == 19) {
                    byte[] byArray = new byte[]{-2, -1};
                    outputStream.write(byArray);
                } else if (this.encoding == 18) {
                    byte[] byArray = new byte[]{-1, -2};
                    outputStream.write(byArray);
                }
                DisplaySetting.accum_indent = 0;
                if (this.root == null) {
                    this.errOutputStreamWriter.write(XttMessageUtil.formatMessage("XTT_INVALID_ROOT_ELEMENT"));
                    n = 67;
                } else {
                    this.symtb = new SymbolicTable(this);
                    n = this.root.run(this.xmlOutputStreamWriter);
                }
                Object var6_8 = null;
                if (this.xmlOutputStreamWriter == null) break block17;
            }
            catch (Throwable throwable) {
                Object var6_9 = null;
                if (this.xmlOutputStreamWriter != null) {
                    this.xmlOutputStreamWriter.flush();
                    this.xmlOutputStreamWriter.close();
                    this.xmlOutputStreamWriter = null;
                }
                if (outputStream != null) {
                    outputStream.flush();
                    outputStream.close();
                    outputStream = null;
                }
                System.gc();
                throw throwable;
            }
            this.xmlOutputStreamWriter.flush();
            this.xmlOutputStreamWriter.close();
            this.xmlOutputStreamWriter = null;
        }
        if (outputStream != null) {
            outputStream.flush();
            outputStream.close();
            outputStream = null;
        }
        System.gc();
        return n;
    }

    public void printXMLDecl() throws IOException {
        this.xmlOutputStreamWriter.write("<?xml version=\"1.0\" encoding=\"");
        if ((this.encoding & 0x10) > 0) {
            if (this.encoding == 19 || this.encoding == 18) {
                this.xmlOutputStreamWriter.write(ENC_UTF_16);
            } else if (this.encoding == 17) {
                this.xmlOutputStreamWriter.write(ENC_UTF_8);
            }
        } else {
            this.xmlOutputStreamWriter.write(ENC_LOCAL_STR[this.encoding]);
        }
        this.xmlOutputStreamWriter.write("\"?>");
    }

    public DisplaySetting getDisplaySetting() {
        return this.display;
    }

    public String getError() throws IOException {
        if (this.errOutputStreamWriter != null) {
            this.errOutputStreamWriter.flush();
        }
        if (this.errOutputStream != null) {
            return this.errOutputStream.toString();
        }
        return null;
    }

    public OutputStreamWriter getErrorOutputStreamWriter() {
        if (this.errOutputStreamWriter == null) {
            this.errOutputStream = new ByteArrayOutputStream();
            this.errOutputStreamWriter = new OutputStreamWriter(this.errOutputStream);
        }
        return this.errOutputStreamWriter;
    }

    public String getEncodingStr() {
        String string = null;
        if ((this.encoding & 0x10) > 0) {
            switch (this.encoding) {
                case 17: {
                    string = ENC_UTF_8;
                    break;
                }
                case 18: {
                    string = ENC_UTF_16LE;
                    break;
                }
                case 19: {
                    string = ENC_UTF_16BE;
                }
            }
        } else {
            string = ENC_LOCAL_STR[this.encoding];
        }
        return string;
    }

    public void setEncoding(String string) {
        if (string.compareTo(ENC_DB_LOCALE) == 0) {
            this.encoding = 16;
        } else if (string.compareTo(ENC_UTF_8) == 0 || string.compareTo(ENC_UTF8) == 0) {
            this.encoding = 17;
        } else if (string.compareTo(ENC_UTF_16LE) == 0 || string.compareTo(ENC_UTF16LE) == 0 || string.compareTo(ENC_UTF_16) == 0 || string.compareTo(ENC_UTF16) == 0) {
            this.encoding = 18;
        } else if (string.compareTo(ENC_UTF_16BE) == 0 || string.compareTo(ENC_UTF16BE) == 0) {
            this.encoding = 19;
        }
    }

    public OutputStreamWriter getXmlOutputStreamWriter() {
        return this.xmlOutputStreamWriter;
    }

    private int getCurrentDirctory(String[] stringArray) throws Exception {
        int n = 0;
        String string = this.path + LO_DIR + this.dir_cnt;
        File file = new File(string);
        while (file.exists()) {
            if (++this.dir_cnt > 8192) {
                this.errOutputStreamWriter.write(XttMessageUtil.formatMessage("XTT_TOO_MANY_FOLDERS"));
                n = 1;
                return 1;
            }
            string = this.path + LO_DIR + this.dir_cnt;
            file = new File(string);
        }
        if (!file.mkdir()) {
            this.errOutputStreamWriter.write("fail to create folder " + string);
            try {
                throw new Exception("fail to create folder " + string);
            }
            catch (Exception exception) {
                System.err.println(exception.getMessage());
                exception.printStackTrace();
                n = 4;
                return 4;
            }
        }
        this.blob_cnt = 0;
        this.clob_cnt = 0;
        stringArray[0] = string;
        return n;
    }

    public int getNextFileName(String[] stringArray, boolean bl) throws Exception {
        int n = 0;
        String string = this.path + LO_DIR + this.dir_cnt;
        if (this.blob_cnt == 0 && this.clob_cnt == 0 && this.dir_cnt == 0 || this.blob_cnt + this.clob_cnt > 8192) {
            String[] stringArray2 = new String[1];
            n = this.getCurrentDirctory(stringArray2);
            if (n != 0) {
                return n;
            }
            string = stringArray2[0];
        }
        stringArray[0] = bl ? string + SLASH + BLOB_FILE + this.blob_cnt++ + "." + BLOB_FILE_EXT : string + SLASH + CLOB_FILE + this.clob_cnt++ + "." + CLOB_FILE_EXT;
        return n;
    }

    public String getRelativePath(String string) {
        if (this.path != null && string.startsWith(this.path)) {
            return string.substring(this.path.length());
        }
        return string;
    }

    public int symtb_insert(String string, SymbolicObject.SymbolicObjectType symbolicObjectType, int n, SymbolicObject symbolicObject) throws IOException {
        int n2 = 0;
        if (this.symtb == null) {
            this.errOutputStreamWriter.write(XttMessageUtil.formatMessage("XTT_SYMBOLIC_TABLE_NOT_FOUND"));
            n2 = 65;
            return 65;
        }
        n2 = this.symtb.insert(string, symbolicObjectType, n, symbolicObject);
        return n2;
    }

    public int symtb_remove(int n) throws IOException {
        int n2 = 0;
        if (this.symtb == null) {
            this.errOutputStreamWriter.write(XttMessageUtil.formatMessage("XTT_SYMBOLIC_TABLE_NOT_FOUND"));
            n2 = 65;
            return 65;
        }
        this.symtb.remove(n);
        return n2;
    }

    public SymbolicObject symtb_search(String string) {
        if (this.symtb == null) {
            return null;
        }
        return this.symtb.search(string);
    }

    public void setXmlFileName(String string) throws IOException {
        File file = new File(string);
        if (file == null || file.exists() && !file.canWrite() || !file.exists() && !file.getParentFile().canWrite()) {
            throw new IOException(XttMessageUtil.formatMessage("ERR_OPEN_XML_FILE", string));
        }
        file = null;
        this.xmlfilename = string;
    }

    public void setXmlOutputStream(OutputStream outputStream) {
        this.xmlOutputStream = outputStream;
    }

    public OutputStream getXmlOutputStream() throws IOException {
        if (this.xmlOutputStream != null) {
            return this.xmlOutputStream;
        }
        if (this.xmlfilename == null) {
            return System.out;
        }
        FileOutputStream fileOutputStream = null;
        try {
            fileOutputStream = new FileOutputStream(this.xmlfilename);
        }
        catch (IOException iOException) {
            this.getErrorOutputStreamWriter().write(XttMessageUtil.formatMessage("ERR_OPEN_XML_FILE", this.xmlfilename));
            throw iOException;
        }
        return fileOutputStream;
    }

    public void setParameters(String string) {
        if (string == null || string.length() == 0) {
            return;
        }
        this.params = ParameterParser.init(string);
    }

    public String getParamValue(String string) {
        if (this.params == null) {
            return null;
        }
        return (String)this.params.get(string);
    }

    public Connection getConnection() {
        return this.connection;
    }

    public void setConnection(JdbcOdbcConnection jdbcOdbcConnection) {
        this.connection = jdbcOdbcConnection;
    }

    public boolean isDoHeader() {
        return this.doHeader;
    }

    public void setDoHeader(boolean bl) {
        this.doHeader = bl;
    }
}

