/*
 * Decompiled with CFR 0.152.
 */
package dbmaker.xml;

import dbmaker.sql.JdbcOdbcConnection;
import dbmaker.xml.XttEnv;
import dbmaker.xml.XttMessageUtil;
import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.UnsupportedEncodingException;
import java.sql.SQLException;
import org.xml.sax.InputSource;

public class XTT {
    private String connectionStr = null;
    private JdbcOdbcConnection conn = null;
    private String xttfile = null;
    private String xmlfile = null;
    private byte[] xttValue = null;
    private byte[] xmlValue = null;
    private XttEnv env = new XttEnv();

    private static String getEncoding(String string) {
        if (string.compareTo("DBMAKER") == 0) {
            return "US-ASCII";
        }
        if (string.compareTo("DBMASTER") == 0) {
            return "Shift_JIS";
        }
        return "US-ASCII";
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public static int spRun(long l, String string, String string2, String string3, byte[] byArray, String string4) {
        Object object;
        int n;
        block10: {
            String string5 = null;
            n = 0;
            try {
                Thread.currentThread().setContextClassLoader(ClassLoader.getSystemClassLoader());
                System.setProperty("DM_DRIVER_MODE", "SERVER_ODBC");
                object = new XTT();
                JdbcOdbcConnection jdbcOdbcConnection = new JdbcOdbcConnection(l);
                ((XTT)object).setDatabaseConnection(jdbcOdbcConnection);
                ((XTT)object).setXtt(string);
                ((XTT)object).setOutputXml(string2);
                ((XTT)object).setParameters(string3);
                n = ((XTT)object).run();
                if (n != 0) {
                    string5 = ((XTT)object).getError();
                }
                jdbcOdbcConnection.close();
            }
            catch (SQLException sQLException) {
                n = sQLException.getErrorCode();
            }
            catch (Exception exception) {
                string5 = exception.getMessage();
                n = 8;
            }
            if (string5 != null) {
                object = null;
                try {
                    try {
                        object = string5.getBytes(XTT.getEncoding(string4));
                    }
                    catch (UnsupportedEncodingException unsupportedEncodingException) {
                        object = string5.getBytes();
                        Object var12_14 = null;
                        int n4 = ((Object)object).length < byArray.length ? ((Object)object).length : byArray.length;
                        System.arraycopy(object, 0, byArray, 0, n4);
                        break block10;
                    }
                    Object var12_13 = null;
                }
                catch (Throwable throwable) {
                    Object var12_15 = null;
                    int n2 = ((Object)object).length < byArray.length ? ((Object)object).length : byArray.length;
                    System.arraycopy(object, 0, byArray, 0, n2);
                    throw throwable;
                }
                int n3 = ((Object)object).length < byArray.length ? ((Object)object).length : byArray.length;
                System.arraycopy(object, 0, byArray, 0, n3);
            }
        }
        if (n != 0 && ((File)(object = new File(string2))).exists() && !((File)object).delete()) {
            System.err.println("fails to delete " + string2);
        }
        System.gc();
        return n;
    }

    public int setDatabaseConnection(JdbcOdbcConnection jdbcOdbcConnection) {
        this.env.setConnection(jdbcOdbcConnection);
        return 0;
    }

    public void setGenXMLHeader(boolean bl) {
        this.env.setDoHeader(bl);
    }

    public void setXtt(String string) {
        this.xttfile = string;
        this.xttValue = null;
    }

    public void setXtt(byte[] byArray) {
        this.xttfile = null;
        this.xttValue = byArray;
    }

    public void setOutputXml(String string) {
        this.xmlfile = string;
        this.xmlValue = null;
    }

    public void setOutputXml(byte[] byArray) {
        this.xmlfile = null;
        this.xmlValue = byArray;
    }

    public void setParameters(String string) {
        if (string != null) {
            this.env.setParameters(string);
        }
    }

    public String getError() throws IOException {
        return this.env.getError();
    }

    public int run() throws Exception {
        int n = 0;
        InputStream inputStream = null;
        if (this.xttfile != null && this.xttfile.length() > 0) {
            try {
                inputStream = new FileInputStream(this.xttfile);
            }
            catch (Exception exception) {
                this.env.getErrorOutputStreamWriter().write(XttMessageUtil.formatMessage("ERR_OPEN_XTT_FILE", this.xttfile));
                n = 21;
                return 21;
            }
        } else if (this.xttValue != null && this.xttValue.length > 0) {
            inputStream = new ByteArrayInputStream(this.xttValue);
        } else {
            this.env.getErrorOutputStreamWriter().write(XttMessageUtil.formatMessage("ERR_FILE_OR_SOURCE_BUFFER_NOT_FOUND"));
            n = 18;
            return 18;
        }
        ByteArrayOutputStream byteArrayOutputStream = null;
        if (this.xmlfile != null && this.xmlfile.length() > 0) {
            this.env.setXmlFileName(this.xmlfile);
        } else if (this.xmlValue != null && this.xmlValue.length > 0) {
            byteArrayOutputStream = new ByteArrayOutputStream(this.xmlValue.length);
            this.env.setXmlOutputStream(byteArrayOutputStream);
        } else {
            this.env.getErrorOutputStreamWriter().write(XttMessageUtil.formatMessage("ERR_FILE_OR_DEST_BUFFER_NOT_FOUND"));
            n = 19;
            return 19;
        }
        InputSource inputSource = new InputSource(inputStream);
        n = this.env.prepare(inputSource);
        if (n != 0) {
            return n;
        }
        n = this.env.run();
        if (n != 0) {
            return n;
        }
        if (byteArrayOutputStream != null) {
            System.arraycopy(byteArrayOutputStream.toByteArray(), 0, this.xmlValue, 0, byteArrayOutputStream.size());
        }
        return n;
    }
}

