/*
 * Decompiled with CFR 0.152.
 */
package javassist.bytecode;

import java.util.Map;
import javassist.ClassPool;
import javassist.CtClass;
import javassist.CtPrimitiveType;
import javassist.NotFoundException;

public class Descriptor {
    public static String toJvmName(String classname) {
        return classname.replace('.', '/');
    }

    public static String toJavaName(String classname) {
        return classname.replace('/', '.');
    }

    public static String toJvmName(CtClass clazz) {
        CtClass ctClass;
        if (clazz.isArray()) {
            return Descriptor.of(clazz);
        }
        return Descriptor.toJvmName(ctClass.getName());
    }

    public static String toClassName(String descriptor) {
        String string;
        int n2 = 0;
        int n3 = 0;
        char c2 = descriptor.charAt(0);
        while (c2 == '[') {
            ++n2;
            c2 = descriptor.charAt(++n3);
        }
        if (c2 == 'L') {
            int n4 = descriptor.indexOf(59, n3++);
            string = descriptor.substring(n3, n4).replace('/', '.');
            n3 = n4;
        } else if (c2 == 'V') {
            string = "void";
        } else if (c2 == 'I') {
            string = "int";
        } else if (c2 == 'B') {
            string = "byte";
        } else if (c2 == 'J') {
            string = "long";
        } else if (c2 == 'D') {
            string = "double";
        } else if (c2 == 'F') {
            string = "float";
        } else if (c2 == 'C') {
            string = "char";
        } else if (c2 == 'S') {
            string = "short";
        } else if (c2 == 'Z') {
            string = "boolean";
        } else {
            throw new RuntimeException("bad descriptor: " + descriptor);
        }
        if (n3 + 1 != descriptor.length()) {
            String string2;
            throw new RuntimeException("multiple descriptors?: " + string2);
        }
        if (n2 == 0) {
            return string;
        }
        StringBuffer stringBuffer = new StringBuffer(string);
        do {
            stringBuffer.append("[]");
        } while (--n2 > 0);
        return stringBuffer.toString();
    }

    public static String of(String classname) {
        String string;
        if (classname.equals("void")) {
            return "V";
        }
        if (classname.equals("int")) {
            return "I";
        }
        if (classname.equals("byte")) {
            return "B";
        }
        if (classname.equals("long")) {
            return "J";
        }
        if (classname.equals("double")) {
            return "D";
        }
        if (classname.equals("float")) {
            return "F";
        }
        if (classname.equals("char")) {
            return "C";
        }
        if (classname.equals("short")) {
            return "S";
        }
        if (classname.equals("boolean")) {
            return "Z";
        }
        return "L" + Descriptor.toJvmName(string) + ";";
    }

    public static String rename(String desc2, String oldname, String newname) {
        if (desc2.indexOf(oldname) < 0) {
            return desc2;
        }
        StringBuffer stringBuffer = new StringBuffer();
        int n2 = 0;
        int n3 = 0;
        while ((n3 = desc2.indexOf(76, n3)) >= 0) {
            if (desc2.startsWith(oldname, n3 + 1) && desc2.charAt(n3 + oldname.length() + 1) == ';') {
                stringBuffer.append(desc2.substring(n2, n3));
                stringBuffer.append('L');
                stringBuffer.append(newname);
                stringBuffer.append(';');
                n2 = n3 = n3 + oldname.length() + 2;
                continue;
            }
            if ((n3 = desc2.indexOf(59, n3) + 1) > 0) continue;
            break;
        }
        if (n2 == 0) {
            return desc2;
        }
        n3 = desc2.length();
        if (n2 < n3) {
            String string;
            stringBuffer.append(string.substring(n2, n3));
        }
        return stringBuffer.toString();
    }

    public static String rename(String desc2, Map map) {
        int n2;
        int n3;
        if (map == null) {
            return desc2;
        }
        StringBuffer stringBuffer = new StringBuffer();
        int n4 = 0;
        int n5 = 0;
        while ((n3 = desc2.indexOf(76, n5)) >= 0 && (n2 = desc2.indexOf(59, n3)) >= 0) {
            n5 = n2 + 1;
            String string = desc2.substring(n3 + 1, n2);
            if ((string = (String)map.get(string)) == null) continue;
            stringBuffer.append(desc2.substring(n4, n3));
            stringBuffer.append('L');
            stringBuffer.append(string);
            stringBuffer.append(';');
            n4 = n5;
        }
        if (n4 == 0) {
            return desc2;
        }
        n3 = desc2.length();
        if (n4 < n3) {
            String string;
            stringBuffer.append(string.substring(n4, n3));
        }
        return stringBuffer.toString();
    }

    public static String of(CtClass type) {
        CtClass ctClass;
        StringBuffer stringBuffer = new StringBuffer();
        Descriptor.a(stringBuffer, ctClass);
        return stringBuffer.toString();
    }

    private static void a(StringBuffer stringBuffer, CtClass object) {
        if (((CtClass)object).isArray()) {
            stringBuffer.append('[');
            try {
                Descriptor.a(stringBuffer, ((CtClass)object).getComponentType());
                return;
            }
            catch (NotFoundException notFoundException) {
                stringBuffer.append('L');
                object = ((CtClass)object).getName();
                stringBuffer.append(Descriptor.toJvmName(((String)object).substring(0, ((String)object).length() - 2)));
                stringBuffer.append(';');
                return;
            }
        }
        if (((CtClass)object).isPrimitive()) {
            object = (CtPrimitiveType)object;
            stringBuffer.append(((CtPrimitiveType)object).getDescriptor());
            return;
        }
        stringBuffer.append('L');
        stringBuffer.append(((CtClass)object).getName().replace('.', '/'));
        stringBuffer.append(';');
    }

    public static String ofConstructor(CtClass[] paramTypes) {
        CtClass[] ctClassArray;
        return Descriptor.ofMethod(CtClass.voidType, ctClassArray);
    }

    public static String ofMethod(CtClass returnType, CtClass[] paramTypes) {
        StringBuffer stringBuffer = new StringBuffer();
        stringBuffer.append('(');
        if (paramTypes != null) {
            int n2 = paramTypes.length;
            for (int i2 = 0; i2 < n2; ++i2) {
                Descriptor.a(stringBuffer, paramTypes[i2]);
            }
        }
        stringBuffer.append(')');
        if (returnType != null) {
            CtClass ctClass;
            Descriptor.a(stringBuffer, ctClass);
        }
        return stringBuffer.toString();
    }

    public static String ofParameters(CtClass[] paramTypes) {
        CtClass[] ctClassArray;
        return Descriptor.ofMethod(null, ctClassArray);
    }

    /*
     * WARNING - void declaration
     */
    public static String appendParameter(String classname, String desc2) {
        void var1_1;
        String string;
        int n2 = desc2.indexOf(41);
        if (n2 < 0) {
            return desc2;
        }
        StringBuffer stringBuffer = new StringBuffer();
        stringBuffer.append(desc2.substring(0, n2));
        stringBuffer.append('L');
        stringBuffer.append(string.replace('.', '/'));
        stringBuffer.append(';');
        stringBuffer.append(var1_1.substring(n2));
        return stringBuffer.toString();
    }

    /*
     * WARNING - void declaration
     */
    public static String insertParameter(String classname, String desc2) {
        void var1_1;
        String string;
        if (desc2.charAt(0) != '(') {
            return desc2;
        }
        return "(L" + string.replace('.', '/') + ';' + var1_1.substring(1);
    }

    /*
     * WARNING - void declaration
     */
    public static String appendParameter(CtClass type, String descriptor) {
        void var1_1;
        CtClass ctClass;
        int n2 = descriptor.indexOf(41);
        if (n2 < 0) {
            return descriptor;
        }
        StringBuffer stringBuffer = new StringBuffer();
        stringBuffer.append(descriptor.substring(0, n2));
        Descriptor.a(stringBuffer, ctClass);
        stringBuffer.append(var1_1.substring(n2));
        return stringBuffer.toString();
    }

    /*
     * WARNING - void declaration
     */
    public static String insertParameter(CtClass type, String descriptor) {
        void var1_1;
        CtClass ctClass;
        if (descriptor.charAt(0) != '(') {
            return descriptor;
        }
        return "(" + Descriptor.of(ctClass) + var1_1.substring(1);
    }

    /*
     * WARNING - void declaration
     */
    public static String changeReturnType(String classname, String desc2) {
        String string;
        void var1_1;
        int n2 = desc2.indexOf(41);
        if (n2 < 0) {
            return desc2;
        }
        StringBuffer stringBuffer = new StringBuffer();
        stringBuffer.append(var1_1.substring(0, n2 + 1));
        stringBuffer.append('L');
        stringBuffer.append(string.replace('.', '/'));
        stringBuffer.append(';');
        return stringBuffer.toString();
    }

    public static CtClass[] getParameterTypes(String desc2, ClassPool cp) throws NotFoundException {
        if (desc2.charAt(0) != '(') {
            return null;
        }
        int n2 = Descriptor.numOfParameters(desc2);
        CtClass[] ctClassArray = new CtClass[n2];
        int n3 = 0;
        int n4 = 1;
        while ((n4 = Descriptor.a(cp, desc2, n4, ctClassArray, n3++)) > 0) {
        }
        return ctClassArray;
    }

    public static boolean eqParamTypes(String desc1, String desc2) {
        if (desc1.charAt(0) != '(') {
            return false;
        }
        int n2 = 0;
        char c2;
        while ((c2 = desc1.charAt(n2)) == desc2.charAt(n2)) {
            if (c2 == ')') {
                return true;
            }
            ++n2;
        }
        return false;
    }

    public static String getParamDescriptor(String decl) {
        String string;
        return decl.substring(0, string.indexOf(41) + 1);
    }

    /*
     * WARNING - void declaration
     */
    public static CtClass getReturnType(String desc2, ClassPool cp) throws NotFoundException {
        String string;
        void var1_1;
        int n2 = desc2.indexOf(41);
        if (n2 < 0) {
            return null;
        }
        CtClass[] ctClassArray = new CtClass[1];
        Descriptor.a((ClassPool)var1_1, string, n2 + 1, ctClassArray, 0);
        return ctClassArray[0];
    }

    public static int numOfParameters(String desc2) {
        char c2;
        int n2 = 0;
        int n3 = 1;
        while ((c2 = desc2.charAt(n3)) != ')') {
            while (c2 == '[') {
                c2 = desc2.charAt(++n3);
            }
            if (c2 == 'L') {
                if ((n3 = desc2.indexOf(59, n3) + 1) <= 0) {
                    throw new IndexOutOfBoundsException("bad descriptor");
                }
            } else {
                ++n3;
            }
            ++n2;
        }
        return n2;
    }

    /*
     * WARNING - void declaration
     */
    public static CtClass toCtClass(String desc2, ClassPool cp) throws NotFoundException {
        String string;
        void var1_1;
        CtClass[] ctClassArray = new CtClass[1];
        int n2 = Descriptor.a(cp, desc2, 0, ctClassArray, 0);
        if (n2 >= 0) {
            return ctClassArray[0];
        }
        return var1_1.get(string.replace('/', '.'));
    }

    private static int a(ClassPool classPool, String object, int n2, CtClass[] ctClassArray, int n3) throws NotFoundException {
        int n4 = 0;
        int n5 = ((String)object).charAt(n2);
        while (n5 == 91) {
            ++n4;
            n5 = ((String)object).charAt(++n2);
        }
        if (n5 == 76) {
            n5 = ((String)object).indexOf(59, ++n2);
            object = ((String)object).substring(n2, n5++).replace('/', '.');
        } else {
            object = Descriptor.a((char)n5);
            if (object == null) {
                return -1;
            }
            n5 = n2 + 1;
            if (n4 == 0) {
                ctClassArray[n3] = object;
                return n5;
            }
            object = ((CtClass)object).getName();
        }
        if (n4 > 0) {
            object = new StringBuffer((String)object);
            while (n4-- > 0) {
                ((StringBuffer)object).append("[]");
            }
            object = ((StringBuffer)object).toString();
        }
        ctClassArray[n3] = classPool.get((String)object);
        return n5;
    }

    static CtClass a(char c2) {
        CtClass ctClass = null;
        switch (c2) {
            case 'Z': {
                ctClass = CtClass.booleanType;
                break;
            }
            case 'C': {
                ctClass = CtClass.charType;
                break;
            }
            case 'B': {
                ctClass = CtClass.byteType;
                break;
            }
            case 'S': {
                ctClass = CtClass.shortType;
                break;
            }
            case 'I': {
                ctClass = CtClass.intType;
                break;
            }
            case 'J': {
                ctClass = CtClass.longType;
                break;
            }
            case 'F': {
                ctClass = CtClass.floatType;
                break;
            }
            case 'D': {
                ctClass = CtClass.doubleType;
                break;
            }
            case 'V': {
                ctClass = CtClass.voidType;
            }
        }
        return ctClass;
    }

    public static int arrayDimension(String desc2) {
        int n2 = 0;
        while (desc2.charAt(n2) == '[') {
            ++n2;
        }
        return n2;
    }

    /*
     * WARNING - void declaration
     */
    public static String toArrayComponent(String desc2, int dim) {
        void var1_1;
        return desc2.substring((int)var1_1);
    }

    public static int dataSize(String desc2) {
        return Descriptor.a(desc2, true);
    }

    public static int paramSize(String desc2) {
        return -Descriptor.a(desc2, false);
    }

    private static int a(String string, boolean bl) {
        int n2 = 0;
        char c2 = string.charAt(0);
        if (c2 == '(') {
            int n3 = 1;
            while (true) {
                if ((c2 = string.charAt(n3)) == ')') {
                    c2 = string.charAt(n3 + 1);
                    break;
                }
                boolean bl2 = false;
                while (c2 == '[') {
                    bl2 = true;
                    c2 = string.charAt(++n3);
                }
                if (c2 == 'L') {
                    if ((n3 = string.indexOf(59, n3) + 1) <= 0) {
                        throw new IndexOutOfBoundsException("bad descriptor");
                    }
                } else {
                    ++n3;
                }
                if (!(bl2 || c2 != 'J' && c2 != 'D')) {
                    n2 -= 2;
                    continue;
                }
                --n2;
            }
        }
        if (bl) {
            if (c2 == 'J' || c2 == 'D') {
                n2 += 2;
            } else if (c2 != 'V') {
                ++n2;
            }
        }
        return n2;
    }

    public static String toString(String desc2) {
        String string = desc2;
        StringBuffer stringBuffer = new StringBuffer();
        if (string.charAt(0) == '(') {
            int n2 = 1;
            stringBuffer.append('(');
            while (string.charAt(n2) != ')') {
                if (n2 > 1) {
                    stringBuffer.append(',');
                }
                n2 = a.a(stringBuffer, n2, string);
            }
            stringBuffer.append(')');
        } else {
            a.a(stringBuffer, 0, string);
        }
        return stringBuffer.toString();
    }

    public static class Iterator {
        private String a;
        private int b;
        private int c;
        private boolean d;

        /*
         * WARNING - void declaration
         */
        public Iterator(String s2) {
            void var1_1;
            this.a = var1_1;
            Iterator iterator = this;
            iterator.c = 0;
            iterator.b = 0;
            this.d = false;
        }

        public boolean hasNext() {
            return this.b < this.a.length();
        }

        public boolean isParameter() {
            return this.d;
        }

        public char currentChar() {
            return this.a.charAt(this.c);
        }

        public boolean is2byte() {
            char c2 = this.currentChar();
            return c2 == 'D' || c2 == 'J';
        }

        public int next() {
            int n2;
            char c2;
            if ((c2 = this.a.charAt(n2 = this.b++)) == '(') {
                c2 = this.a.charAt(++n2);
                this.d = true;
            }
            if (c2 == ')') {
                ++this.b;
                c2 = this.a.charAt(++n2);
                this.d = false;
            }
            while (c2 == '[') {
                c2 = this.a.charAt(++n2);
            }
            if (c2 == 'L') {
                if ((n2 = this.a.indexOf(59, n2) + 1) <= 0) {
                    throw new IndexOutOfBoundsException("bad descriptor");
                }
            } else {
                ++n2;
            }
            this.c = this.b;
            this.b = n2;
            return this.c;
        }
    }

    static class a {
        int a;
        int b;
        int c;
        int d;

        static int a(StringBuffer stringBuffer, int n2, String object) {
            char c2 = ((String)object).charAt(n2);
            int n3 = 0;
            while (c2 == '[') {
                ++n3;
                c2 = ((String)object).charAt(++n2);
            }
            if (c2 == 'L') {
                while ((c2 = ((String)object).charAt(++n2)) != ';') {
                    if (c2 == '/') {
                        c2 = '.';
                    }
                    stringBuffer.append(c2);
                }
            } else {
                object = Descriptor.a(c2);
                stringBuffer.append(((CtClass)object).getName());
            }
            while (n3-- > 0) {
                stringBuffer.append("[]");
            }
            return n2 + 1;
        }

        a(int n2, int n3, int n4, int n5) {
            this.a = n2;
            this.b = n3;
            this.c = n4;
            this.d = n5;
        }
    }
}

