/*
 * Decompiled with CFR 0.152.
 */
package dbmaster.sql;

import dbmaster.sql.JdbcOdbc;
import dbmaster.sql.JdbcOdbcAPI;
import dbmaster.sql.JdbcOdbcConnection;
import dbmaster.sql.JdbcOdbcMetaDataResultSet;
import dbmaster.sql.JdbcOdbcResultSet;
import dbmaster.sql.JdbcOdbcStatement;
import java.sql.Connection;
import java.sql.DatabaseMetaData;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.util.ResourceBundle;

public class JdbcOdbcDatabaseMetaData
extends JdbcOdbc
implements DatabaseMetaData {
    protected JdbcOdbcAPI ODBCOBJ;
    protected JdbcOdbcConnection myConnection;

    public JdbcOdbcDatabaseMetaData(JdbcOdbcAPI jdbcOdbcAPI, JdbcOdbcConnection jdbcOdbcConnection) throws SQLException {
        if (this.needTrace) {
            this.trace("new DatabaseMetaData");
        }
        this.checkClosed(jdbcOdbcConnection.isClosed());
        this.ODBCOBJ = jdbcOdbcAPI;
        this.myConnection = jdbcOdbcConnection;
    }

    public boolean allProceduresAreCallable() throws SQLException {
        String string = new String("Y");
        if (this.needTrace) {
            this.trace("DatabaseMetaData.allProceduresAreCallable()");
        }
        this.checkClosed(this.myConnection.isClosed());
        String string2 = null;
        JdbcOdbcConnection jdbcOdbcConnection = this.myConnection;
        synchronized (jdbcOdbcConnection) {
            string2 = this.ODBCOBJ.jdbcGetInfoStr(this.myConnection.getHDBC(), 20);
        }
        return string2.compareTo(string) == 0;
    }

    public boolean allTablesAreSelectable() throws SQLException {
        String string = new String("Y");
        if (this.needTrace) {
            this.trace("DatabaseMetaData.allTablesAreSelectable()");
        }
        this.checkClosed(this.myConnection.isClosed());
        String string2 = null;
        JdbcOdbcConnection jdbcOdbcConnection = this.myConnection;
        synchronized (jdbcOdbcConnection) {
            string2 = this.ODBCOBJ.jdbcGetInfoStr(this.myConnection.getHDBC(), 19);
        }
        return string2.compareTo(string) == 0;
    }

    public boolean dataDefinitionCausesTransactionCommit() throws SQLException {
        if (this.needTrace) {
            this.trace("DatabaseMetaData.dataDefinitionCausesTransactionCommit()");
        }
        this.checkClosed(this.myConnection.isClosed());
        int n = 0;
        JdbcOdbcConnection jdbcOdbcConnection = this.myConnection;
        synchronized (jdbcOdbcConnection) {
            n = this.ODBCOBJ.jdbcGetInfoShort(this.myConnection.getHDBC(), 46);
        }
        return n == 3 || n == 2;
    }

    public boolean dataDefinitionIgnoredInTransactions() throws SQLException {
        if (this.needTrace) {
            this.trace("DatabaseMetaData.dataDefinitionIgnoredInTransactions()");
        }
        this.checkClosed(this.myConnection.isClosed());
        int n = 0;
        JdbcOdbcConnection jdbcOdbcConnection = this.myConnection;
        synchronized (jdbcOdbcConnection) {
            n = this.ODBCOBJ.jdbcGetInfoShort(this.myConnection.getHDBC(), 46);
        }
        return n == 4;
    }

    public boolean deletesAreDetected(int n) throws SQLException {
        if (this.needTrace) {
            this.trace("DatabaseMetaData.deletesAreDetected(" + n + ")");
        }
        this.checkClosed(this.myConnection.isClosed());
        switch (n) {
            case 1003: 
            case 1004: 
            case 1005: {
                return false;
            }
        }
        throw this.JDBCError("JERR_INV_CURSOR_TYPE", "DatabaseMetaData.deletesAreDetected(" + n + ")", null);
    }

    public boolean doesMaxRowSizeIncludeBlobs() throws SQLException {
        String string = new String("Y");
        if (this.needTrace) {
            this.trace("DatabaseMetaData.doesMaxRowSizeIncludeBlobs()");
        }
        this.checkClosed(this.myConnection.isClosed());
        String string2 = null;
        JdbcOdbcConnection jdbcOdbcConnection = this.myConnection;
        synchronized (jdbcOdbcConnection) {
            string2 = this.ODBCOBJ.jdbcGetInfoStr(this.myConnection.getHDBC(), 103);
        }
        return string2.compareTo(string) == 0;
    }

    public ResultSet getBestRowIdentifier(String string, String string2, String string3, int n, boolean bl) throws SQLException {
        if (this.needTrace) {
            this.trace("DatabaseMetaData.getBestRowIdentifier(" + string + "," + string2 + "," + string3 + "," + n + "," + bl + ")");
        }
        if (n != 2 && n != 0 && n != 1) {
            this.JDBCError("JERR_INV_SCOPE_VALUE", "DatabaseMetaData.getBestRowIdentifier(" + n + ")");
        }
        JdbcOdbcStatement jdbcOdbcStatement = null;
        JdbcOdbcConnection jdbcOdbcConnection = this.myConnection;
        synchronized (jdbcOdbcConnection) {
            this.checkClosed(this.myConnection.isClosed());
            jdbcOdbcStatement = new JdbcOdbcStatement(this.myConnection);
            try {
                this.ODBCOBJ.jdbcSpecialColumns(jdbcOdbcStatement.getHSTMT(), 1, string, string2, string3, n, bl);
            }
            catch (SQLException sQLException) {
                jdbcOdbcStatement.close();
                throw sQLException;
            }
        }
        return new JdbcOdbcResultSet(this.ODBCOBJ, jdbcOdbcStatement, true);
    }

    public ResultSet getCatalogs() throws SQLException {
        if (this.needTrace) {
            this.trace("DatabaseMetaData.getCatalogs()");
        }
        return (JdbcOdbcResultSet)this.getTablesMap(1);
    }

    public String getCatalogSeparator() throws SQLException {
        if (this.needTrace) {
            this.trace("DatabaseMetaData.getCatalogSeparator()");
        }
        this.checkClosed(this.myConnection.isClosed());
        JdbcOdbcConnection jdbcOdbcConnection = this.myConnection;
        synchronized (jdbcOdbcConnection) {
            String string = this.ODBCOBJ.jdbcGetInfoStr(this.myConnection.getHDBC(), 41);
            return string;
        }
    }

    public String getCatalogTerm() throws SQLException {
        if (this.needTrace) {
            this.trace("DatabaseMetaData.getCatalogTerm()");
        }
        this.checkClosed(this.myConnection.isClosed());
        JdbcOdbcConnection jdbcOdbcConnection = this.myConnection;
        synchronized (jdbcOdbcConnection) {
            String string = this.ODBCOBJ.jdbcGetInfoStr(this.myConnection.getHDBC(), 42);
            return string;
        }
    }

    public ResultSet getColumnPrivileges(String string, String string2, String string3, String string4) throws SQLException {
        this.trace("DatabaseMetaData.getColumnPrivileges(" + string + "," + string2 + "," + string3 + "," + string4 + ")");
        this.checkClosed(this.myConnection.isClosed());
        throw this.JDBCError("JERR_UNSUPPORT_OPERATION", "DatabaseMetaData.getColumnPrivileges()", null);
    }

    public ResultSet getColumns(String string, String string2, String string3, String string4) throws SQLException {
        if (this.needTrace) {
            this.trace("DatabaseMetaData.getColumns(" + string + "," + string2 + "," + string3 + "," + string4 + ")");
        }
        this.checkClosed(this.myConnection.isClosed());
        JdbcOdbcStatement jdbcOdbcStatement = null;
        JdbcOdbcConnection jdbcOdbcConnection = this.myConnection;
        synchronized (jdbcOdbcConnection) {
            jdbcOdbcStatement = new JdbcOdbcStatement(this.myConnection);
            try {
                this.ODBCOBJ.jdbcColumns(jdbcOdbcStatement.getHSTMT(), string, string2, string3, string4);
            }
            catch (SQLException sQLException) {
                jdbcOdbcStatement.close();
                throw sQLException;
            }
        }
        return new JdbcOdbcMetaDataResultSet(this.ODBCOBJ, jdbcOdbcStatement, true, 2);
    }

    public Connection getConnection() throws SQLException {
        if (this.needTrace) {
            this.trace("DatabaseMetaData.getConnection()");
        }
        this.checkClosed(this.myConnection.isClosed());
        return this.myConnection;
    }

    public ResultSet getCrossReference(String string, String string2, String string3, String string4, String string5, String string6) throws SQLException {
        if (this.needTrace) {
            this.trace("DatabaseMetaData.getCrossReference(" + string + "," + string2 + "," + string3 + "," + string4 + "," + string5 + "," + string6 + ")");
        }
        this.checkClosed(this.myConnection.isClosed());
        JdbcOdbcStatement jdbcOdbcStatement = null;
        JdbcOdbcConnection jdbcOdbcConnection = this.myConnection;
        synchronized (jdbcOdbcConnection) {
            jdbcOdbcStatement = new JdbcOdbcStatement(this.myConnection);
            try {
                this.ODBCOBJ.jdbcForeignKeys(jdbcOdbcStatement.getHSTMT(), string, string2, string3, string4, string5, string6);
            }
            catch (SQLException sQLException) {
                jdbcOdbcStatement.close();
                throw sQLException;
            }
        }
        return new JdbcOdbcResultSet(this.ODBCOBJ, jdbcOdbcStatement, true);
    }

    public String getDatabaseProductName() throws SQLException {
        if (this.needTrace) {
            this.trace("DatabaseMetaData.getDatabaseProductName()");
        }
        this.checkClosed(this.myConnection.isClosed());
        JdbcOdbcConnection jdbcOdbcConnection = this.myConnection;
        synchronized (jdbcOdbcConnection) {
            String string = this.ODBCOBJ.jdbcGetInfoStr(this.myConnection.getHDBC(), 17);
            return string;
        }
    }

    public String getDatabaseProductVersion() throws SQLException {
        if (this.needTrace) {
            this.trace("DatabaseMetaData.getDatabaseProductVersion()");
        }
        this.checkClosed(this.myConnection.isClosed());
        JdbcOdbcConnection jdbcOdbcConnection = this.myConnection;
        synchronized (jdbcOdbcConnection) {
            String string = this.ODBCOBJ.jdbcGetInfoStr(this.myConnection.getHDBC(), 18);
            return string;
        }
    }

    public int getDefaultTransactionIsolation() throws SQLException {
        int n = 0;
        if (this.needTrace) {
            this.trace("DatabaseMetaData.getDefaultTransactionIsolation()");
        }
        this.checkClosed(this.myConnection.isClosed());
        int n2 = 0;
        JdbcOdbcConnection jdbcOdbcConnection = this.myConnection;
        synchronized (jdbcOdbcConnection) {
            n2 = this.ODBCOBJ.jdbcGetInfoInt(this.myConnection.getHDBC(), 26);
        }
        switch (n2) {
            case 1: {
                n = 1;
                break;
            }
            case 2: {
                n = 2;
                break;
            }
            case 4: {
                n = 4;
                break;
            }
            case 8: {
                n = 8;
            }
        }
        return n;
    }

    public int getDriverMajorVersion() {
        if (this.needTrace) {
            this.trace("DatabaseMetaData.getDriverMajorVersion()");
        }
        return 1;
    }

    public int getDriverMinorVersion() {
        if (this.needTrace) {
            this.trace("DatabaseMetaData.getDriverMinorVersion()");
        }
        return 0;
    }

    public String getDriverName() throws SQLException {
        if (this.needTrace) {
            this.trace("DatabaseMetaData.getDriverName()");
        }
        this.checkClosed(this.myConnection.isClosed());
        return new String("dmJdbcOdbc");
    }

    public String getDriverVersion() throws SQLException {
        if (this.needTrace) {
            this.trace("DatabaseMetaData.getDriverVersion()");
        }
        this.checkClosed(this.myConnection.isClosed());
        int n = 1;
        String string = String.valueOf(n);
        n = 0;
        string = string + "." + String.valueOf(n);
        return string;
    }

    public ResultSet getExportedKeys(String string, String string2, String string3) throws SQLException {
        if (this.needTrace) {
            this.trace("DatabaseMetaData.getExportedKeys(" + string + "," + string2 + "," + string3 + ")");
        }
        this.checkClosed(this.myConnection.isClosed());
        JdbcOdbcStatement jdbcOdbcStatement = null;
        JdbcOdbcConnection jdbcOdbcConnection = this.myConnection;
        synchronized (jdbcOdbcConnection) {
            jdbcOdbcStatement = new JdbcOdbcStatement(this.myConnection);
            try {
                this.ODBCOBJ.jdbcForeignKeys(jdbcOdbcStatement.getHSTMT(), string, string2, string3, "", "", "");
            }
            catch (SQLException sQLException) {
                jdbcOdbcStatement.close();
                throw sQLException;
            }
        }
        return new JdbcOdbcResultSet(this.ODBCOBJ, jdbcOdbcStatement, true);
    }

    public String getExtraNameCharacters() throws SQLException {
        if (this.needTrace) {
            this.trace("DatabaseMetaData.getExtraNameCharacters()");
        }
        this.checkClosed(this.myConnection.isClosed());
        JdbcOdbcConnection jdbcOdbcConnection = this.myConnection;
        synchronized (jdbcOdbcConnection) {
            String string = this.ODBCOBJ.jdbcGetInfoStr(this.myConnection.getHDBC(), 94);
            return string;
        }
    }

    public String getIdentifierQuoteString() throws SQLException {
        if (this.needTrace) {
            this.trace("DatabaseMetaData.getIdentifierQuoteString()");
        }
        this.checkClosed(this.myConnection.isClosed());
        JdbcOdbcConnection jdbcOdbcConnection = this.myConnection;
        synchronized (jdbcOdbcConnection) {
            String string = this.ODBCOBJ.jdbcGetInfoStr(this.myConnection.getHDBC(), 29);
            return string;
        }
    }

    public ResultSet getImportedKeys(String string, String string2, String string3) throws SQLException {
        if (this.needTrace) {
            this.trace("DatabaseMetaData.getImportedKeys(" + string + "," + string2 + "," + string3 + ")");
        }
        this.checkClosed(this.myConnection.isClosed());
        JdbcOdbcStatement jdbcOdbcStatement = null;
        JdbcOdbcConnection jdbcOdbcConnection = this.myConnection;
        synchronized (jdbcOdbcConnection) {
            jdbcOdbcStatement = new JdbcOdbcStatement(this.myConnection);
            try {
                this.ODBCOBJ.jdbcForeignKeys(jdbcOdbcStatement.getHSTMT(), "", "", "", string, string2, string3);
            }
            catch (SQLException sQLException) {
                jdbcOdbcStatement.close();
                throw sQLException;
            }
        }
        return new JdbcOdbcResultSet(this.ODBCOBJ, jdbcOdbcStatement, true);
    }

    public ResultSet getIndexInfo(String string, String string2, String string3, boolean bl, boolean bl2) throws SQLException {
        if (this.needTrace) {
            this.trace("DatabaseMetaData.getIndexInfo(" + string + "," + string2 + "," + string3 + ")");
        }
        this.checkClosed(this.myConnection.isClosed());
        JdbcOdbcStatement jdbcOdbcStatement = null;
        JdbcOdbcConnection jdbcOdbcConnection = this.myConnection;
        synchronized (jdbcOdbcConnection) {
            jdbcOdbcStatement = new JdbcOdbcStatement(this.myConnection);
            try {
                this.ODBCOBJ.jdbcStatistics(jdbcOdbcStatement.getHSTMT(), string, string2, string3, bl, bl2);
            }
            catch (SQLException sQLException) {
                jdbcOdbcStatement.close();
                throw sQLException;
            }
        }
        return new JdbcOdbcResultSet(this.ODBCOBJ, jdbcOdbcStatement, true);
    }

    public int getMaxBinaryLiteralLength() throws SQLException {
        if (this.needTrace) {
            this.trace("DatabaseMetaData.getMaxBinaryLiteralLength()");
        }
        this.checkClosed(this.myConnection.isClosed());
        JdbcOdbcConnection jdbcOdbcConnection = this.myConnection;
        synchronized (jdbcOdbcConnection) {
            int n = this.ODBCOBJ.jdbcGetInfoInt(this.myConnection.getHDBC(), 112);
            return n;
        }
    }

    public int getMaxCatalogNameLength() throws SQLException {
        if (this.needTrace) {
            this.trace("DatabaseMetaData.getMaxCatalogNameLength()");
        }
        this.checkClosed(this.myConnection.isClosed());
        JdbcOdbcConnection jdbcOdbcConnection = this.myConnection;
        synchronized (jdbcOdbcConnection) {
            int n = this.ODBCOBJ.jdbcGetInfoShort(this.myConnection.getHDBC(), 34);
            return n;
        }
    }

    public int getMaxCharLiteralLength() throws SQLException {
        if (this.needTrace) {
            this.trace("DatabaseMetaData.getMaxCharLiteralLength()");
        }
        this.checkClosed(this.myConnection.isClosed());
        JdbcOdbcConnection jdbcOdbcConnection = this.myConnection;
        synchronized (jdbcOdbcConnection) {
            int n = this.ODBCOBJ.jdbcGetInfoInt(this.myConnection.getHDBC(), 108);
            return n;
        }
    }

    public int getMaxColumnNameLength() throws SQLException {
        if (this.needTrace) {
            this.trace("DatabaseMetaData.getMaxColumnNameLength()");
        }
        this.checkClosed(this.myConnection.isClosed());
        JdbcOdbcConnection jdbcOdbcConnection = this.myConnection;
        synchronized (jdbcOdbcConnection) {
            int n = this.ODBCOBJ.jdbcGetInfoShort(this.myConnection.getHDBC(), 30);
            return n;
        }
    }

    public int getMaxColumnsInGroupBy() throws SQLException {
        if (this.needTrace) {
            this.trace("DatabaseMetaData.getMaxColumnsInGroupBy()");
        }
        this.checkClosed(this.myConnection.isClosed());
        JdbcOdbcConnection jdbcOdbcConnection = this.myConnection;
        synchronized (jdbcOdbcConnection) {
            int n = this.ODBCOBJ.jdbcGetInfoShort(this.myConnection.getHDBC(), 97);
            return n;
        }
    }

    public int getMaxColumnsInIndex() throws SQLException {
        if (this.needTrace) {
            this.trace("DatabaseMetaData.getMaxColumnsInIndex()");
        }
        this.checkClosed(this.myConnection.isClosed());
        JdbcOdbcConnection jdbcOdbcConnection = this.myConnection;
        synchronized (jdbcOdbcConnection) {
            int n = this.ODBCOBJ.jdbcGetInfoShort(this.myConnection.getHDBC(), 98);
            return n;
        }
    }

    public int getMaxColumnsInOrderBy() throws SQLException {
        if (this.needTrace) {
            this.trace("DatabaseMetaData.getMaxColumnsInOrderBy()");
        }
        this.checkClosed(this.myConnection.isClosed());
        JdbcOdbcConnection jdbcOdbcConnection = this.myConnection;
        synchronized (jdbcOdbcConnection) {
            int n = this.ODBCOBJ.jdbcGetInfoShort(this.myConnection.getHDBC(), 99);
            return n;
        }
    }

    public int getMaxColumnsInSelect() throws SQLException {
        if (this.needTrace) {
            this.trace("DatabaseMetaData.getMaxColumnsInSelect()");
        }
        this.checkClosed(this.myConnection.isClosed());
        JdbcOdbcConnection jdbcOdbcConnection = this.myConnection;
        synchronized (jdbcOdbcConnection) {
            int n = this.ODBCOBJ.jdbcGetInfoShort(this.myConnection.getHDBC(), 100);
            return n;
        }
    }

    public int getMaxColumnsInTable() throws SQLException {
        if (this.needTrace) {
            this.trace("DatabaseMetaData.getMaxColumnsInTable()");
        }
        this.checkClosed(this.myConnection.isClosed());
        JdbcOdbcConnection jdbcOdbcConnection = this.myConnection;
        synchronized (jdbcOdbcConnection) {
            int n = this.ODBCOBJ.jdbcGetInfoShort(this.myConnection.getHDBC(), 101);
            return n;
        }
    }

    public int getMaxConnections() throws SQLException {
        if (this.needTrace) {
            this.trace("DatabaseMetaData.getMaxConnections()");
        }
        this.checkClosed(this.myConnection.isClosed());
        JdbcOdbcConnection jdbcOdbcConnection = this.myConnection;
        synchronized (jdbcOdbcConnection) {
            int n = this.ODBCOBJ.jdbcGetInfoShort(this.myConnection.getHDBC(), 0);
            return n;
        }
    }

    public int getMaxCursorNameLength() throws SQLException {
        if (this.needTrace) {
            this.trace("DatabaseMetaData.getMaxCursorNameLength()");
        }
        this.checkClosed(this.myConnection.isClosed());
        JdbcOdbcConnection jdbcOdbcConnection = this.myConnection;
        synchronized (jdbcOdbcConnection) {
            int n = this.ODBCOBJ.jdbcGetInfoShort(this.myConnection.getHDBC(), 31);
            return n;
        }
    }

    public int getMaxIndexLength() throws SQLException {
        if (this.needTrace) {
            this.trace("DatabaseMetaData.getMaxIndexLength()");
        }
        this.checkClosed(this.myConnection.isClosed());
        JdbcOdbcConnection jdbcOdbcConnection = this.myConnection;
        synchronized (jdbcOdbcConnection) {
            int n = this.ODBCOBJ.jdbcGetInfoInt(this.myConnection.getHDBC(), 102);
            return n;
        }
    }

    public int getMaxProcedureNameLength() throws SQLException {
        if (this.needTrace) {
            this.trace("DatabaseMetaData.getMaxProcedureNameLength()");
        }
        this.checkClosed(this.myConnection.isClosed());
        JdbcOdbcConnection jdbcOdbcConnection = this.myConnection;
        synchronized (jdbcOdbcConnection) {
            int n = this.ODBCOBJ.jdbcGetInfoShort(this.myConnection.getHDBC(), 33);
            return n;
        }
    }

    public int getMaxRowSize() throws SQLException {
        if (this.needTrace) {
            this.trace("DatabaseMetaData.getMaxRowSize()");
        }
        this.checkClosed(this.myConnection.isClosed());
        JdbcOdbcConnection jdbcOdbcConnection = this.myConnection;
        synchronized (jdbcOdbcConnection) {
            int n = this.ODBCOBJ.jdbcGetInfoInt(this.myConnection.getHDBC(), 104);
            return n;
        }
    }

    public int getMaxSchemaNameLength() throws SQLException {
        if (this.needTrace) {
            this.trace("DatabaseMetaData.getMaxSchemaNameLength()");
        }
        this.checkClosed(this.myConnection.isClosed());
        JdbcOdbcConnection jdbcOdbcConnection = this.myConnection;
        synchronized (jdbcOdbcConnection) {
            int n = this.ODBCOBJ.jdbcGetInfoShort(this.myConnection.getHDBC(), 32);
            return n;
        }
    }

    public int getMaxStatementLength() throws SQLException {
        if (this.needTrace) {
            this.trace("DatabaseMetaData.getMaxStatementLength()");
        }
        this.checkClosed(this.myConnection.isClosed());
        JdbcOdbcConnection jdbcOdbcConnection = this.myConnection;
        synchronized (jdbcOdbcConnection) {
            int n = this.ODBCOBJ.jdbcGetInfoInt(this.myConnection.getHDBC(), 105);
            return n;
        }
    }

    public int getMaxStatements() throws SQLException {
        if (this.needTrace) {
            this.trace("DatabaseMetaData.getMaxStatements()");
        }
        this.checkClosed(this.myConnection.isClosed());
        JdbcOdbcConnection jdbcOdbcConnection = this.myConnection;
        synchronized (jdbcOdbcConnection) {
            int n = this.ODBCOBJ.jdbcGetInfoInt(this.myConnection.getHDBC(), 10022);
            return n;
        }
    }

    public int getMaxTableNameLength() throws SQLException {
        if (this.needTrace) {
            this.trace("DatabaseMetaData.getMaxTableNameLength()");
        }
        this.checkClosed(this.myConnection.isClosed());
        JdbcOdbcConnection jdbcOdbcConnection = this.myConnection;
        synchronized (jdbcOdbcConnection) {
            int n = this.ODBCOBJ.jdbcGetInfoShort(this.myConnection.getHDBC(), 35);
            return n;
        }
    }

    public int getMaxTablesInSelect() throws SQLException {
        if (this.needTrace) {
            this.trace("DatabaseMetaData.getMaxTablesInSelect()");
        }
        this.checkClosed(this.myConnection.isClosed());
        JdbcOdbcConnection jdbcOdbcConnection = this.myConnection;
        synchronized (jdbcOdbcConnection) {
            int n = this.ODBCOBJ.jdbcGetInfoShort(this.myConnection.getHDBC(), 106);
            return n;
        }
    }

    public int getMaxUserNameLength() throws SQLException {
        if (this.needTrace) {
            this.trace("DatabaseMetaData.getMaxUserNameLength()");
        }
        this.checkClosed(this.myConnection.isClosed());
        JdbcOdbcConnection jdbcOdbcConnection = this.myConnection;
        synchronized (jdbcOdbcConnection) {
            int n = this.ODBCOBJ.jdbcGetInfoShort(this.myConnection.getHDBC(), 107);
            return n;
        }
    }

    public String getNumericFunctions() throws SQLException {
        String string = "";
        if (this.needTrace) {
            this.trace("DatabaseMetaData.getNumericFunctions()");
        }
        this.checkClosed(this.myConnection.isClosed());
        int n = 0;
        JdbcOdbcConnection jdbcOdbcConnection = this.myConnection;
        synchronized (jdbcOdbcConnection) {
            n = this.ODBCOBJ.jdbcGetInfoInt(this.myConnection.getHDBC(), 49);
        }
        if ((n & 1) != 0) {
            string = string + "ABS,";
        }
        if ((n & 2) != 0) {
            string = string + "ACOS,";
        }
        if ((n & 4) != 0) {
            string = string + "ASIN,";
        }
        if ((n & 8) != 0) {
            string = string + "ATAN,";
        }
        if ((n & 0x10) != 0) {
            string = string + "ATAN2,";
        }
        if ((n & 0x20) != 0) {
            string = string + "CEILING,";
        }
        if ((n & 0x40) != 0) {
            string = string + "COS,";
        }
        if ((n & 0x80) != 0) {
            string = string + "COT,";
        }
        if ((n & 0x40000) != 0) {
            string = string + "DEGREES,";
        }
        if ((n & 0x100) != 0) {
            string = string + "EXP,";
        }
        if ((n & 0x200) != 0) {
            string = string + "FLOOR,";
        }
        if ((n & 0x400) != 0) {
            string = string + "LOG,";
        }
        if ((n & 0x80000) != 0) {
            string = string + "LOG10,";
        }
        if ((n & 0x800) != 0) {
            string = string + "MOD,";
        }
        if ((n & 0x10000) != 0) {
            string = string + "PI,";
        }
        if ((n & 0x100000) != 0) {
            string = string + "POWER,";
        }
        if ((n & 0x200000) != 0) {
            string = string + "RADIANS,";
        }
        if ((n & 0x20000) != 0) {
            string = string + "RAND,";
        }
        if ((n & 0x400000) != 0) {
            string = string + "ROUND,";
        }
        if ((n & 0x1000) != 0) {
            string = string + "SIGN,";
        }
        if ((n & 0x2000) != 0) {
            string = string + "SIN,";
        }
        if ((n & 0x4000) != 0) {
            string = string + "SQRT,";
        }
        if ((n & 0x8000) != 0) {
            string = string + "TAN,";
        }
        if ((n & 0x800000) != 0) {
            string = string + "TRUNCATE,";
        }
        if (string.length() > 0) {
            string = string.substring(0, string.length() - 1);
        }
        return string;
    }

    public ResultSet getPrimaryKeys(String string, String string2, String string3) throws SQLException {
        if (this.needTrace) {
            this.trace("DatabaseMetaData.getPrimaryKeys(" + string + "," + string2 + "," + string3 + ")");
        }
        this.checkClosed(this.myConnection.isClosed());
        JdbcOdbcStatement jdbcOdbcStatement = null;
        JdbcOdbcConnection jdbcOdbcConnection = this.myConnection;
        synchronized (jdbcOdbcConnection) {
            jdbcOdbcStatement = new JdbcOdbcStatement(this.myConnection);
            try {
                this.ODBCOBJ.jdbcPrimaryKeys(jdbcOdbcStatement.getHSTMT(), string, string2, string3);
            }
            catch (SQLException sQLException) {
                jdbcOdbcStatement.close();
                throw sQLException;
            }
        }
        return new JdbcOdbcResultSet(this.ODBCOBJ, jdbcOdbcStatement, true);
    }

    public ResultSet getProcedureColumns(String string, String string2, String string3, String string4) throws SQLException {
        if (this.needTrace) {
            this.trace("DatabaseMetaData.getProcedureColumns(" + string2 + "," + string3 + "," + string4 + ")");
        }
        this.checkClosed(this.myConnection.isClosed());
        JdbcOdbcStatement jdbcOdbcStatement = null;
        JdbcOdbcConnection jdbcOdbcConnection = this.myConnection;
        synchronized (jdbcOdbcConnection) {
            jdbcOdbcStatement = new JdbcOdbcStatement(this.myConnection);
            try {
                this.ODBCOBJ.jdbcProcedureColumns(jdbcOdbcStatement.getHSTMT(), string, string2, string3, string4);
            }
            catch (SQLException sQLException) {
                jdbcOdbcStatement.close();
                throw sQLException;
            }
        }
        return new JdbcOdbcMetaDataResultSet(this.ODBCOBJ, jdbcOdbcStatement, true, 1);
    }

    public ResultSet getProcedures(String string, String string2, String string3) throws SQLException {
        if (this.needTrace) {
            this.trace("DatabaseMetaData.getProcedures(" + string + "," + string2 + "," + string3 + ")");
        }
        this.checkClosed(this.myConnection.isClosed());
        JdbcOdbcStatement jdbcOdbcStatement = null;
        JdbcOdbcConnection jdbcOdbcConnection = this.myConnection;
        synchronized (jdbcOdbcConnection) {
            jdbcOdbcStatement = new JdbcOdbcStatement(this.myConnection);
            try {
                this.ODBCOBJ.jdbcProcedures(jdbcOdbcStatement.getHSTMT(), string, string2, string3);
            }
            catch (SQLException sQLException) {
                jdbcOdbcStatement.close();
                throw sQLException;
            }
        }
        return new JdbcOdbcResultSet(this.ODBCOBJ, jdbcOdbcStatement, true);
    }

    public String getProcedureTerm() throws SQLException {
        if (this.needTrace) {
            this.trace("DatabaseMetaData.getProcedureTerm()");
        }
        this.checkClosed(this.myConnection.isClosed());
        JdbcOdbcConnection jdbcOdbcConnection = this.myConnection;
        synchronized (jdbcOdbcConnection) {
            String string = this.ODBCOBJ.jdbcGetInfoStr(this.myConnection.getHDBC(), 40);
            return string;
        }
    }

    public ResultSet getSchemas() throws SQLException {
        if (this.needTrace) {
            this.trace("DatabaseMetaData.getSchemas()");
        }
        return this.getSchemas("", "%");
    }

    public ResultSet getSchemas(String string, String string2) throws SQLException {
        if (this.needTrace) {
            this.trace("DatabaseMetaData.getSchemas(String catalog, String schemaPattern)");
        }
        JdbcOdbcStatement jdbcOdbcStatement = new JdbcOdbcStatement(this.myConnection);
        int n = this.myConnection.getOptionInt(28);
        String string3 = this.myConnection.getCatalog();
        String string4 = "select distinct TABLE_OWNER as TABLE_SCHEM, '";
        string4 = string4 + string3;
        string4 = string4 + "' as TABLE_CATALOG from SYSTEM.SYSTABLE";
        if (n == 1) {
            if (string != null) {
                string = string.toUpperCase();
            }
            if (string2 != null) {
                string2 = string2.toUpperCase();
            }
        }
        if (string != null && string.length() != 0) {
            string4 = string4 + " where '" + string3 + "' like '" + string + "'";
            if (string2 != null && string2.length() != 0) {
                string4 = string4 + " and TABLE_OWNER like '" + string2 + "'";
            }
        } else if (string2 != null && string2.length() != 0) {
            string4 = string4 + " where TABLE_OWNER like '" + string2 + "'";
        }
        string4 = string4 + " order by TABLE_OWNER";
        ResultSet resultSet = jdbcOdbcStatement.executeQuery(string4);
        return resultSet;
    }

    public String getSchemaTerm() throws SQLException {
        if (this.needTrace) {
            this.trace("DatabaseMetaData.getSchemaTerm()");
        }
        this.checkClosed(this.myConnection.isClosed());
        JdbcOdbcConnection jdbcOdbcConnection = this.myConnection;
        synchronized (jdbcOdbcConnection) {
            String string = this.ODBCOBJ.jdbcGetInfoStr(this.myConnection.getHDBC(), 39);
            return string;
        }
    }

    public String getSearchStringEscape() throws SQLException {
        if (this.needTrace) {
            this.trace("DatabaseMetaData.getSearchStringEscape()");
        }
        this.checkClosed(this.myConnection.isClosed());
        JdbcOdbcConnection jdbcOdbcConnection = this.myConnection;
        synchronized (jdbcOdbcConnection) {
            String string = this.ODBCOBJ.jdbcGetInfoStr(this.myConnection.getHDBC(), 14);
            return string;
        }
    }

    public String getSQLKeywords() throws SQLException {
        if (this.needTrace) {
            this.trace("DatabaseMetaData.getSQLKeywords()");
        }
        this.checkClosed(this.myConnection.isClosed());
        JdbcOdbcConnection jdbcOdbcConnection = this.myConnection;
        synchronized (jdbcOdbcConnection) {
            String string = this.ODBCOBJ.jdbcGetInfoStr(this.myConnection.getHDBC(), 89);
            return string;
        }
    }

    public String getStringFunctions() throws SQLException {
        String string = "";
        if (this.needTrace) {
            this.trace("DatabaseMetaData.getStringFunctions()");
        }
        this.checkClosed(this.myConnection.isClosed());
        int n = 0;
        JdbcOdbcConnection jdbcOdbcConnection = this.myConnection;
        synchronized (jdbcOdbcConnection) {
            n = this.ODBCOBJ.jdbcGetInfoInt(this.myConnection.getHDBC(), 50);
        }
        if ((n & 0x2000) != 0) {
            string = string + "ASCII,";
        }
        if ((n & 0x80000) != 0) {
            string = string + "BIT_LENGTH,";
        }
        if ((n & 0x4000) != 0) {
            string = string + "CHAR,";
        }
        if ((n & 0x200000) != 0) {
            string = string + "CHARACTER_LENGTH,";
        }
        if ((n & 0x100000) != 0) {
            string = string + "CHAR_LENGTH,";
        }
        if ((n & 1) != 0) {
            string = string + "CONCAT,";
        }
        if ((n & 0x8000) != 0) {
            string = string + "DIFFERENCE,";
        }
        if ((n & 2) != 0) {
            string = string + "INSERT,";
        }
        if ((n & 0x40) != 0) {
            string = string + "LCASE,";
        }
        if ((n & 4) != 0) {
            string = string + "LEFT,";
        }
        if ((n & 0x10) != 0) {
            string = string + "LENGTH,";
        }
        if ((n & 0x20) != 0) {
            string = string + "LOCATE,";
        }
        if ((n & 0x10000) != 0) {
            string = string + "LOCATE_2,";
        }
        if ((n & 8) != 0) {
            string = string + "LTRIM,";
        }
        if ((n & 0x400000) != 0) {
            string = string + "OCTET_LENGTH,";
        }
        if ((n & 0x800000) != 0) {
            string = string + "POSITION,";
        }
        if ((n & 0x80) != 0) {
            string = string + "REPEAT,";
        }
        if ((n & 0x100) != 0) {
            string = string + "REPLACE,";
        }
        if ((n & 0x200) != 0) {
            string = string + "RIGHT,";
        }
        if ((n & 0x400) != 0) {
            string = string + "RTRIM,";
        }
        if ((n & 0x20000) != 0) {
            string = string + "SOUNDEX,";
        }
        if ((n & 0x40000) != 0) {
            string = string + "SPACE,";
        }
        if ((n & 0x800) != 0) {
            string = string + "SUBSTRING,";
        }
        if ((n & 0x1000) != 0) {
            string = string + "UCASE,";
        }
        if (string.length() > 0) {
            string = string.substring(0, string.length() - 1);
        }
        return string;
    }

    public String getSystemFunctions() throws SQLException {
        String string = "";
        if (this.needTrace) {
            this.trace("DatabaseMetaData.getSystemFunctions()");
        }
        this.checkClosed(this.myConnection.isClosed());
        int n = 0;
        JdbcOdbcConnection jdbcOdbcConnection = this.myConnection;
        synchronized (jdbcOdbcConnection) {
            n = this.ODBCOBJ.jdbcGetInfoInt(this.myConnection.getHDBC(), 51);
        }
        if ((n & 2) != 0) {
            string = string + "DBNAME,";
        }
        if ((n & 4) != 0) {
            string = string + "IFNULL,";
        }
        if ((n & 1) != 0) {
            string = string + "USERNAME,";
        }
        if (string.length() > 0) {
            string = string.substring(0, string.length() - 1);
        }
        return string;
    }

    public ResultSet getTablePrivileges(String string, String string2, String string3) throws SQLException {
        if (this.needTrace) {
            this.trace("DatabaseMetaData.getTablePrivileges()");
        }
        this.checkClosed(this.myConnection.isClosed());
        throw this.JDBCError("JERR_UNSUPPORT_OPERATION", "DatabaseMetaData.getTablePrivileges()", null);
    }

    protected ResultSet getTablesMap(int n) throws SQLException {
        return this.getTablesMap(n, "", "", "", "");
    }

    protected ResultSet getTablesMap(int n, String string, String string2, String string3, String string4) throws SQLException {
        int[] nArray = null;
        JdbcOdbcResultSet jdbcOdbcResultSet = null;
        if (this.needTrace) {
            this.trace("DatabaseMetaData.getTableMap(" + n + ")");
        }
        this.checkClosed(this.myConnection.isClosed());
        switch (n) {
            case 1: {
                nArray = new int[]{1};
                string = "%";
                break;
            }
            case 2: {
                nArray = new int[]{4};
                string4 = "%";
                break;
            }
            case 3: {
                nArray = new int[]{2};
                if (string2 != null && string2.length() != 0) break;
                string2 = "%";
                break;
            }
        }
        JdbcOdbcStatement jdbcOdbcStatement = null;
        JdbcOdbcConnection jdbcOdbcConnection = this.myConnection;
        synchronized (jdbcOdbcConnection) {
            jdbcOdbcStatement = new JdbcOdbcStatement(this.myConnection);
            try {
                this.ODBCOBJ.jdbcTables(jdbcOdbcStatement.getHSTMT(), string, string2, string3, string4);
            }
            catch (SQLException sQLException) {
                jdbcOdbcStatement.close();
                throw sQLException;
            }
        }
        jdbcOdbcResultSet = new JdbcOdbcResultSet(this.ODBCOBJ, jdbcOdbcStatement, true);
        jdbcOdbcStatement.setColumnMapping(nArray);
        jdbcOdbcResultSet.needRemap = jdbcOdbcStatement.colMapLength() > 0;
        return jdbcOdbcResultSet;
    }

    public ResultSet getTables(String string, String string2, String string3, String[] stringArray) throws SQLException {
        Object object;
        String string4 = "";
        if (this.needTrace) {
            this.trace("DatabaseMetaData.getTables(" + string + "," + string2 + "," + string3 + "," + stringArray + ")");
        }
        this.checkClosed(this.myConnection.isClosed());
        if (stringArray != null) {
            string4 = "";
            int n = 0;
            n = 0;
            while (n < stringArray.length) {
                object = stringArray[n];
                if (n > 0) {
                    string4 = string4 + ",";
                }
                string4 = string4 + (String)object;
                n = (short)(n + 1);
            }
        } else {
            string4 = "%";
        }
        JdbcOdbcStatement jdbcOdbcStatement = null;
        object = this.myConnection;
        synchronized (object) {
            jdbcOdbcStatement = new JdbcOdbcStatement(this.myConnection);
            try {
                this.ODBCOBJ.jdbcTables(jdbcOdbcStatement.getHSTMT(), string, string2, string3, string4);
            }
            catch (SQLException sQLException) {
                jdbcOdbcStatement.close();
                throw sQLException;
            }
        }
        return new JdbcOdbcResultSet(this.ODBCOBJ, jdbcOdbcStatement, true);
    }

    public ResultSet getTableTypes() throws SQLException {
        if (this.needTrace) {
            this.trace("DatabaseMetaData.getTableTypes()");
        }
        return (JdbcOdbcResultSet)this.getTablesMap(2);
    }

    public String getTimeDateFunctions() throws SQLException {
        String string = "";
        if (this.needTrace) {
            this.trace("DatabaseMetaData.getTimeDateFunctions()");
        }
        this.checkClosed(this.myConnection.isClosed());
        int n = 0;
        JdbcOdbcConnection jdbcOdbcConnection = this.myConnection;
        synchronized (jdbcOdbcConnection) {
            n = this.ODBCOBJ.jdbcGetInfoInt(this.myConnection.getHDBC(), 52);
        }
        if ((n & 2) != 0) {
            string = string + "CURDATE,";
        }
        if ((n & 0x20000) != 0) {
            string = string + "CURRENT_DATE,";
        }
        if ((n & 0x40000) != 0) {
            string = string + "CURRENT_TIME,";
        }
        if ((n & 0x80000) != 0) {
            string = string + "CURRENT_TIMESTAMP,";
        }
        if ((n & 0x200) != 0) {
            string = string + "CURTIME,";
        }
        if ((n & 0x8000) != 0) {
            string = string + "DAYNAME,";
        }
        if ((n & 4) != 0) {
            string = string + "DAYOFMONTH,";
        }
        if ((n & 8) != 0) {
            string = string + "DAYOFWEEK,";
        }
        if ((n & 0x10) != 0) {
            string = string + "DAYOFYEAR,";
        }
        if ((n & 0x100000) != 0) {
            string = string + "EXTRACT,";
        }
        if ((n & 0x400) != 0) {
            string = string + "HOUR,";
        }
        if ((n & 0x800) != 0) {
            string = string + "MINUTE,";
        }
        if ((n & 0x20) != 0) {
            string = string + "MONTH,";
        }
        if ((n & 0x10000) != 0) {
            string = string + "MONTHNAME,";
        }
        if ((n & 1) != 0) {
            string = string + "NOW,";
        }
        if ((n & 0x40) != 0) {
            string = string + "QUARTER,";
        }
        if ((n & 0x1000) != 0) {
            string = string + "SECOND,";
        }
        if ((n & 0x2000) != 0) {
            string = string + "TIMESTAMPADD,";
        }
        if ((n & 0x4000) != 0) {
            string = string + "TIMESTAMPDIFF,";
        }
        if ((n & 0x80) != 0) {
            string = string + "WEEK,";
        }
        if ((n & 0x100) != 0) {
            string = string + "YEAR,";
        }
        if (string.length() > 0) {
            string = string.substring(0, string.length() - 1);
        }
        return string;
    }

    public ResultSet getTypeInfo() throws SQLException {
        if (this.needTrace) {
            this.trace("DatabaseMetaData.getTypeInfo()");
        }
        this.checkClosed(this.myConnection.isClosed());
        JdbcOdbcStatement jdbcOdbcStatement = null;
        JdbcOdbcConnection jdbcOdbcConnection = this.myConnection;
        synchronized (jdbcOdbcConnection) {
            jdbcOdbcStatement = new JdbcOdbcStatement(this.myConnection);
            try {
                this.ODBCOBJ.jdbcGetTypeInfo(jdbcOdbcStatement.getHSTMT(), 0);
            }
            catch (SQLException sQLException) {
                jdbcOdbcStatement.close();
                throw sQLException;
            }
        }
        return new JdbcOdbcResultSet(this.ODBCOBJ, jdbcOdbcStatement, true);
    }

    public ResultSet getUDTs(String string, String string2, String string3, int[] nArray) throws SQLException {
        if (this.needTrace) {
            this.trace("DatabaseMetaData.getUDTs()");
        }
        this.checkClosed(this.myConnection.isClosed());
        return null;
    }

    public String getURL() throws SQLException {
        if (this.needTrace) {
            this.trace("DatabaseMetaData.getURL()");
        }
        this.checkClosed(this.myConnection.isClosed());
        return this.myConnection.getURL();
    }

    public String getUserName() throws SQLException {
        if (this.needTrace) {
            this.trace("DatabaseMetaData.getUserName()");
        }
        this.checkClosed(this.myConnection.isClosed());
        JdbcOdbcConnection jdbcOdbcConnection = this.myConnection;
        synchronized (jdbcOdbcConnection) {
            String string = this.ODBCOBJ.jdbcGetInfoStr(this.myConnection.getHDBC(), 47);
            return string;
        }
    }

    public ResultSet getVersionColumns(String string, String string2, String string3) throws SQLException {
        if (this.needTrace) {
            this.trace("DatabaseMetaData.getVersionColumns(" + string + "," + string2 + "," + string3 + ")");
        }
        this.checkClosed(this.myConnection.isClosed());
        JdbcOdbcStatement jdbcOdbcStatement = null;
        JdbcOdbcConnection jdbcOdbcConnection = this.myConnection;
        synchronized (jdbcOdbcConnection) {
            jdbcOdbcStatement = new JdbcOdbcStatement(this.myConnection);
            try {
                this.ODBCOBJ.jdbcSpecialColumns(jdbcOdbcStatement.getHSTMT(), 1, string, string2, string3, 0, false);
            }
            catch (SQLException sQLException) {
                jdbcOdbcStatement.close();
                throw sQLException;
            }
        }
        return new JdbcOdbcResultSet(this.ODBCOBJ, jdbcOdbcStatement, true);
    }

    public boolean insertsAreDetected(int n) throws SQLException {
        if (this.needTrace) {
            this.trace("DatabaseMetaData.insertsAreDetected(" + n + ")");
        }
        this.checkClosed(this.myConnection.isClosed());
        switch (n) {
            case 1003: 
            case 1004: 
            case 1005: {
                return false;
            }
        }
        throw this.JDBCError("JERR_INV_CURSOR_TYPE", "DatabaseMetaData.insertsAreDetected(" + n + ")", null);
    }

    public boolean isCatalogAtStart() throws SQLException {
        if (this.needTrace) {
            this.trace("DatabaseMetaData.isCatalogAtStart()");
        }
        this.checkClosed(this.myConnection.isClosed());
        int n = 0;
        JdbcOdbcConnection jdbcOdbcConnection = this.myConnection;
        synchronized (jdbcOdbcConnection) {
            n = this.ODBCOBJ.jdbcGetInfoShort(this.myConnection.getHDBC(), 114);
        }
        return n == 1;
    }

    public boolean isReadOnly() throws SQLException {
        String string = new String("Y");
        if (this.needTrace) {
            this.trace("DatabaseMetaData.isReadOnly()");
        }
        this.checkClosed(this.myConnection.isClosed());
        String string2 = null;
        JdbcOdbcConnection jdbcOdbcConnection = this.myConnection;
        synchronized (jdbcOdbcConnection) {
            string2 = this.ODBCOBJ.jdbcGetInfoStr(this.myConnection.getHDBC(), 25);
        }
        return string2.compareTo(string) == 0;
    }

    public boolean nullPlusNonNullIsNull() throws SQLException {
        if (this.needTrace) {
            this.trace("DatabaseMetaData.nullPlusNonNullIsNull()");
        }
        this.checkClosed(this.myConnection.isClosed());
        int n = 0;
        JdbcOdbcConnection jdbcOdbcConnection = this.myConnection;
        synchronized (jdbcOdbcConnection) {
            n = this.ODBCOBJ.jdbcGetInfoShort(this.myConnection.getHDBC(), 22);
        }
        return n == 0;
    }

    public boolean nullsAreSortedAtEnd() throws SQLException {
        if (this.needTrace) {
            this.trace("DatabaseMetaData.nullsAreSortedAtEnd()");
        }
        this.checkClosed(this.myConnection.isClosed());
        int n = 0;
        JdbcOdbcConnection jdbcOdbcConnection = this.myConnection;
        synchronized (jdbcOdbcConnection) {
            n = this.ODBCOBJ.jdbcGetInfoShort(this.myConnection.getHDBC(), 85);
        }
        return n == 4;
    }

    public boolean nullsAreSortedAtStart() throws SQLException {
        if (this.needTrace) {
            this.trace("DatabaseMetaData.nullsAreSortedAtStart()");
        }
        this.checkClosed(this.myConnection.isClosed());
        int n = 0;
        JdbcOdbcConnection jdbcOdbcConnection = this.myConnection;
        synchronized (jdbcOdbcConnection) {
            n = this.ODBCOBJ.jdbcGetInfoShort(this.myConnection.getHDBC(), 85);
        }
        return n == 2;
    }

    public boolean nullsAreSortedHigh() throws SQLException {
        if (this.needTrace) {
            this.trace("DatabaseMetaData.nullsAreSortedHigh()");
        }
        this.checkClosed(this.myConnection.isClosed());
        int n = 0;
        JdbcOdbcConnection jdbcOdbcConnection = this.myConnection;
        synchronized (jdbcOdbcConnection) {
            n = this.ODBCOBJ.jdbcGetInfoShort(this.myConnection.getHDBC(), 85);
        }
        return n == 0;
    }

    public boolean nullsAreSortedLow() throws SQLException {
        if (this.needTrace) {
            this.trace("DatabaseMetaData.nullsAreSortedLow()");
        }
        this.checkClosed(this.myConnection.isClosed());
        int n = 0;
        JdbcOdbcConnection jdbcOdbcConnection = this.myConnection;
        synchronized (jdbcOdbcConnection) {
            n = this.ODBCOBJ.jdbcGetInfoShort(this.myConnection.getHDBC(), 85);
        }
        return (n & 1) != 0;
    }

    public boolean othersDeletesAreVisible(int n) throws SQLException {
        if (this.needTrace) {
            this.trace("DatabaseMetaData.othersDeletesAreVisible(" + n + ")");
        }
        this.checkClosed(this.myConnection.isClosed());
        switch (n) {
            case 1003: 
            case 1004: 
            case 1005: {
                return false;
            }
        }
        throw this.JDBCError("JERR_INV_CURSOR_TYPE", "DatabaseMetaData.othersDeletesAreVisible(" + n + ")", null);
    }

    public boolean othersInsertsAreVisible(int n) throws SQLException {
        if (this.needTrace) {
            this.trace("DatabaseMetaData.othersInsertsAreVisible(" + n + ")");
        }
        this.checkClosed(this.myConnection.isClosed());
        switch (n) {
            case 1003: 
            case 1004: 
            case 1005: {
                return false;
            }
        }
        throw this.JDBCError("JERR_INV_CURSOR_TYPE", "DatabaseMetaData.othersInsertsAreVisible(" + n + ")", null);
    }

    public boolean othersUpdatesAreVisible(int n) throws SQLException {
        if (this.needTrace) {
            this.trace("DatabaseMetaData.othersUpdatesAreVisible(" + n + ")");
        }
        this.checkClosed(this.myConnection.isClosed());
        switch (n) {
            case 1003: 
            case 1004: 
            case 1005: {
                return false;
            }
        }
        throw this.JDBCError("JERR_INV_CURSOR_TYPE", "DatabaseMetaData.othersUpdatesAreVisible(" + n + ")", null);
    }

    public boolean ownDeletesAreVisible(int n) throws SQLException {
        if (this.needTrace) {
            this.trace("DatabaseMetaData.ownDeletesAreVisible(" + n + ")");
        }
        this.checkClosed(this.myConnection.isClosed());
        switch (n) {
            case 1003: 
            case 1004: 
            case 1005: {
                return true;
            }
        }
        throw this.JDBCError("JERR_INV_CURSOR_TYPE", "DatabaseMetaData.ownDeletesAreVisible(" + n + ")", null);
    }

    public boolean ownInsertsAreVisible(int n) throws SQLException {
        if (this.needTrace) {
            this.trace("DatabaseMetaData.ownInsertsAreVisible(" + n + ")");
        }
        this.checkClosed(this.myConnection.isClosed());
        switch (n) {
            case 1003: 
            case 1004: 
            case 1005: {
                return true;
            }
        }
        throw this.JDBCError("JERR_INV_CURSOR_TYPE", "DatabaseMetaData.ownInsertsAreVisible(" + n + ")", null);
    }

    public boolean ownUpdatesAreVisible(int n) throws SQLException {
        if (this.needTrace) {
            this.trace("DatabaseMetaData.ownUpdatesAreVisible(" + n + ")");
        }
        this.checkClosed(this.myConnection.isClosed());
        switch (n) {
            case 1003: 
            case 1004: 
            case 1005: {
                return true;
            }
        }
        throw this.JDBCError("JERR_INV_CURSOR_TYPE", "DatabaseMetaData.ownUpdatesAreVisible(" + n + ")", null);
    }

    public boolean storesLowerCaseIdentifiers() throws SQLException {
        if (this.needTrace) {
            this.trace("DatabaseMetaData.storesLowerCaseIdentifiers()");
        }
        this.checkClosed(this.myConnection.isClosed());
        return this.gbDbCase == 2;
    }

    public boolean storesLowerCaseQuotedIdentifiers() throws SQLException {
        if (this.needTrace) {
            this.trace("DatabaseMetaData.storesLowerCaseQuotedIdentifiers()");
        }
        this.checkClosed(this.myConnection.isClosed());
        int n = 0;
        JdbcOdbcConnection jdbcOdbcConnection = this.myConnection;
        synchronized (jdbcOdbcConnection) {
            n = this.ODBCOBJ.jdbcGetInfoShort(this.myConnection.getHDBC(), 93);
        }
        return n == 2;
    }

    public boolean storesMixedCaseIdentifiers() throws SQLException {
        if (this.needTrace) {
            this.trace("DatabaseMetaData.storesMixedCaseIdentifiers()");
        }
        this.checkClosed(this.myConnection.isClosed());
        return this.gbDbCase == 4;
    }

    public boolean storesMixedCaseQuotedIdentifiers() throws SQLException {
        if (this.needTrace) {
            this.trace("DatabaseMetaData.storesMixedCaseQuotedIdentifiers()");
        }
        this.checkClosed(this.myConnection.isClosed());
        int n = 0;
        JdbcOdbcConnection jdbcOdbcConnection = this.myConnection;
        synchronized (jdbcOdbcConnection) {
            n = this.ODBCOBJ.jdbcGetInfoShort(this.myConnection.getHDBC(), 93);
        }
        return n == 4;
    }

    public boolean storesUpperCaseIdentifiers() throws SQLException {
        if (this.needTrace) {
            this.trace("DatabaseMetaData.storesUpperCaseIdentifiers()");
        }
        this.checkClosed(this.myConnection.isClosed());
        return this.gbDbCase == 1;
    }

    public boolean storesUpperCaseQuotedIdentifiers() throws SQLException {
        if (this.needTrace) {
            this.trace("DatabaseMetaData.storesUpperCaseQuotedIdentifiers()");
        }
        this.checkClosed(this.myConnection.isClosed());
        int n = 0;
        JdbcOdbcConnection jdbcOdbcConnection = this.myConnection;
        synchronized (jdbcOdbcConnection) {
            n = this.ODBCOBJ.jdbcGetInfoShort(this.myConnection.getHDBC(), 93);
        }
        return n == 1;
    }

    public boolean supportsAlterTableWithAddColumn() throws SQLException {
        if (this.needTrace) {
            this.trace("DatabaseMetaData.supportsAlterTableWithAddColumn()");
        }
        this.checkClosed(this.myConnection.isClosed());
        int n = 0;
        JdbcOdbcConnection jdbcOdbcConnection = this.myConnection;
        synchronized (jdbcOdbcConnection) {
            n = this.ODBCOBJ.jdbcGetInfoInt(this.myConnection.getHDBC(), 86);
        }
        return (n & 1) != 0;
    }

    public boolean supportsAlterTableWithDropColumn() throws SQLException {
        if (this.needTrace) {
            this.trace("DatabaseMetaData.supportsAlterTableWithDropColumn()");
        }
        this.checkClosed(this.myConnection.isClosed());
        int n = 0;
        JdbcOdbcConnection jdbcOdbcConnection = this.myConnection;
        synchronized (jdbcOdbcConnection) {
            n = this.ODBCOBJ.jdbcGetInfoInt(this.myConnection.getHDBC(), 86);
        }
        return (n & 2) != 0;
    }

    public boolean supportsANSI92EntryLevelSQL() throws SQLException {
        if (this.needTrace) {
            this.trace("DatabaseMetaData.supportsANSI92EntryLevelSQL()");
        }
        this.checkClosed(this.myConnection.isClosed());
        int n = 0;
        JdbcOdbcConnection jdbcOdbcConnection = this.myConnection;
        synchronized (jdbcOdbcConnection) {
            n = this.ODBCOBJ.jdbcGetInfoInt(this.myConnection.getHDBC(), 118);
        }
        return n == 1 || n == 2 || n == 4 || n == 8;
    }

    public boolean supportsANSI92FullSQL() throws SQLException {
        if (this.needTrace) {
            this.trace("DatabaseMetaData.supportsANSI92FullSQL()");
        }
        this.checkClosed(this.myConnection.isClosed());
        int n = 0;
        JdbcOdbcConnection jdbcOdbcConnection = this.myConnection;
        synchronized (jdbcOdbcConnection) {
            n = this.ODBCOBJ.jdbcGetInfoInt(this.myConnection.getHDBC(), 118);
        }
        return n == 8;
    }

    public boolean supportsANSI92IntermediateSQL() throws SQLException {
        if (this.needTrace) {
            this.trace("DatabaseMetaData.supportsANSI92IntermediateSQL()");
        }
        this.checkClosed(this.myConnection.isClosed());
        int n = 0;
        JdbcOdbcConnection jdbcOdbcConnection = this.myConnection;
        synchronized (jdbcOdbcConnection) {
            n = this.ODBCOBJ.jdbcGetInfoInt(this.myConnection.getHDBC(), 118);
        }
        return n == 4 || n == 8;
    }

    public boolean supportsBatchUpdates() throws SQLException {
        if (this.needTrace) {
            this.trace("DatabaseMetaData.supportsBatchUpdates()");
        }
        this.checkClosed(this.myConnection.isClosed());
        return false;
    }

    public boolean supportsCatalogsInDataManipulation() throws SQLException {
        if (this.needTrace) {
            this.trace("DatabaseMetaData.supportsCatalogsInDataManipulation()");
        }
        this.checkClosed(this.myConnection.isClosed());
        int n = 0;
        JdbcOdbcConnection jdbcOdbcConnection = this.myConnection;
        synchronized (jdbcOdbcConnection) {
            n = this.ODBCOBJ.jdbcGetInfoInt(this.myConnection.getHDBC(), 92);
        }
        return (n & 1) != 0;
    }

    public boolean supportsCatalogsInIndexDefinitions() throws SQLException {
        if (this.needTrace) {
            this.trace("DatabaseMetaData.supportsCatalogsInIndexDefinitions()");
        }
        this.checkClosed(this.myConnection.isClosed());
        int n = 0;
        JdbcOdbcConnection jdbcOdbcConnection = this.myConnection;
        synchronized (jdbcOdbcConnection) {
            n = this.ODBCOBJ.jdbcGetInfoInt(this.myConnection.getHDBC(), 92);
        }
        return (n & 8) != 0;
    }

    public boolean supportsCatalogsInPrivilegeDefinitions() throws SQLException {
        if (this.needTrace) {
            this.trace("DatabaseMetaData.supportsCatalogsInPrivilegeDefinitions()");
        }
        if (this.myConnection.isClosed()) {
            this.JDBCError("JERR_OBJECT_IS_CLOSED", "DatabaseMetaData.supportsCatalogsInPrivilegeDefinitions()");
        }
        int n = 0;
        JdbcOdbcConnection jdbcOdbcConnection = this.myConnection;
        synchronized (jdbcOdbcConnection) {
            n = this.ODBCOBJ.jdbcGetInfoInt(this.myConnection.getHDBC(), 92);
        }
        return (n & 0x10) != 0;
    }

    public boolean supportsCatalogsInProcedureCalls() throws SQLException {
        if (this.needTrace) {
            this.trace("DatabaseMetaData.supportsCatalogsInProcedureCalls()");
        }
        this.checkClosed(this.myConnection.isClosed());
        int n = 0;
        JdbcOdbcConnection jdbcOdbcConnection = this.myConnection;
        synchronized (jdbcOdbcConnection) {
            n = this.ODBCOBJ.jdbcGetInfoInt(this.myConnection.getHDBC(), 92);
        }
        return (n & 2) != 0;
    }

    public boolean supportsCatalogsInTableDefinitions() throws SQLException {
        if (this.needTrace) {
            this.trace("DatabaseMetaData.supportsCatalogsInTableDefinitions()");
        }
        this.checkClosed(this.myConnection.isClosed());
        int n = 0;
        JdbcOdbcConnection jdbcOdbcConnection = this.myConnection;
        synchronized (jdbcOdbcConnection) {
            n = this.ODBCOBJ.jdbcGetInfoInt(this.myConnection.getHDBC(), 92);
        }
        return (n & 4) != 0;
    }

    public boolean supportsColumnAliasing() throws SQLException {
        String string = new String("Y");
        if (this.needTrace) {
            this.trace("DatabaseMetaData.supportsColumnAliasing()");
        }
        this.checkClosed(this.myConnection.isClosed());
        String string2 = null;
        JdbcOdbcConnection jdbcOdbcConnection = this.myConnection;
        synchronized (jdbcOdbcConnection) {
            string2 = this.ODBCOBJ.jdbcGetInfoStr(this.myConnection.getHDBC(), 87);
        }
        return string2.compareTo(string) == 0;
    }

    public boolean supportsConvert() throws SQLException {
        if (this.needTrace) {
            this.trace("DatabaseMetaData.supportsConvert()");
        }
        this.checkClosed(this.myConnection.isClosed());
        int n = 0;
        JdbcOdbcConnection jdbcOdbcConnection = this.myConnection;
        synchronized (jdbcOdbcConnection) {
            n = this.ODBCOBJ.jdbcGetInfoInt(this.myConnection.getHDBC(), 48);
        }
        return n != 0;
    }

    public boolean supportsConvert(int n, int n2) throws SQLException {
        int n3;
        int n4 = 0;
        int n5 = 0;
        if (this.needTrace) {
            this.trace("DatabaseMetaData.supportsConvert()");
        }
        this.checkClosed(this.myConnection.isClosed());
        switch (n) {
            case -7: {
                n4 = 55;
                break;
            }
            case -6: {
                n4 = 68;
                break;
            }
            case 5: {
                n4 = 65;
                break;
            }
            case 4: {
                n4 = 61;
                break;
            }
            case -5: {
                n4 = 53;
                break;
            }
            case 6: {
                n4 = 60;
                break;
            }
            case 7: {
                n4 = 64;
                break;
            }
            case 8: {
                n4 = 59;
                break;
            }
            case 2: {
                n4 = 63;
                break;
            }
            case 3: {
                n4 = 58;
                break;
            }
            case 1: {
                n4 = 56;
                break;
            }
            case 12: {
                n4 = 70;
                break;
            }
            case -1: 
            case 2005: {
                n4 = 62;
                break;
            }
            case 91: {
                n4 = 57;
                break;
            }
            case 92: {
                n4 = 66;
                break;
            }
            case 93: {
                n4 = 67;
                break;
            }
            case -2: {
                n4 = 54;
                break;
            }
            case -3: {
                n4 = 69;
                break;
            }
            case -4: 
            case 2004: {
                n4 = 71;
                break;
            }
            default: {
                this.JDBCError("JERR_INV_JDBC_DATA_TYPE", "DatabaseMetaData.supportsConvert(" + n4 + ")");
            }
        }
        JdbcOdbcConnection jdbcOdbcConnection = this.myConnection;
        synchronized (jdbcOdbcConnection) {
            try {
                n3 = this.ODBCOBJ.jdbcGetInfoInt(this.myConnection.getHDBC(), n4);
            }
            catch (SQLException sQLException) {
                boolean bl = false;
                return bl;
            }
        }
        switch (n2) {
            case -7: {
                n5 = 55;
                break;
            }
            case -6: {
                n5 = 68;
                break;
            }
            case 5: {
                n5 = 65;
                break;
            }
            case 4: {
                n5 = 61;
                break;
            }
            case -5: {
                n5 = 53;
                break;
            }
            case 6: {
                n5 = 60;
                break;
            }
            case 7: {
                n5 = 64;
                break;
            }
            case 8: {
                n5 = 59;
                break;
            }
            case 2: {
                n5 = 63;
                break;
            }
            case 3: {
                n5 = 58;
                break;
            }
            case 1: {
                n5 = 56;
                break;
            }
            case 12: {
                n5 = 70;
                break;
            }
            case -1: 
            case 2005: {
                n5 = 62;
                break;
            }
            case 91: {
                n5 = 57;
                break;
            }
            case 92: {
                n5 = 66;
                break;
            }
            case 93: {
                n5 = 67;
                break;
            }
            case -2: {
                n5 = 54;
                break;
            }
            case -3: {
                n5 = 69;
                break;
            }
            case -4: 
            case 2004: {
                n5 = 71;
                break;
            }
            default: {
                this.JDBCError("JERR_INV_JDBC_DATA_TYPE", "DatabaseMetaData.supportsConvert(" + n2 + ")");
            }
        }
        return (n3 & n5) != 0;
    }

    public boolean supportsCoreSQLGrammar() throws SQLException {
        if (this.needTrace) {
            this.trace("DatabaseMetaData.supportsCoreSQLGrammar()");
        }
        this.checkClosed(this.myConnection.isClosed());
        int n = 0;
        JdbcOdbcConnection jdbcOdbcConnection = this.myConnection;
        synchronized (jdbcOdbcConnection) {
            n = this.ODBCOBJ.jdbcGetInfoShort(this.myConnection.getHDBC(), 15);
        }
        return n == 1 || n == 2;
    }

    public boolean supportsCorrelatedSubqueries() throws SQLException {
        if (this.needTrace) {
            this.trace("DatabaseMetaData.supportsCorrelatedSubqueries()");
        }
        this.checkClosed(this.myConnection.isClosed());
        int n = 0;
        JdbcOdbcConnection jdbcOdbcConnection = this.myConnection;
        synchronized (jdbcOdbcConnection) {
            n = this.ODBCOBJ.jdbcGetInfoInt(this.myConnection.getHDBC(), 95);
        }
        return (n & 0x10) != 0;
    }

    public boolean supportsDataDefinitionAndDataManipulationTransactions() throws SQLException {
        if (this.needTrace) {
            this.trace("DatabaseMetaData.supportsDataDefinitionAndDataManipulationTransactions()");
        }
        this.checkClosed(this.myConnection.isClosed());
        int n = 0;
        JdbcOdbcConnection jdbcOdbcConnection = this.myConnection;
        synchronized (jdbcOdbcConnection) {
            n = this.ODBCOBJ.jdbcGetInfoShort(this.myConnection.getHDBC(), 46);
        }
        return n == 2;
    }

    public boolean supportsDataManipulationTransactionsOnly() throws SQLException {
        if (this.needTrace) {
            this.trace("DatabaseMetaData.supportsDataManipulationTransactionsOnly()");
        }
        this.checkClosed(this.myConnection.isClosed());
        int n = 0;
        JdbcOdbcConnection jdbcOdbcConnection = this.myConnection;
        synchronized (jdbcOdbcConnection) {
            n = this.ODBCOBJ.jdbcGetInfoShort(this.myConnection.getHDBC(), 46);
        }
        return n == 1;
    }

    public boolean supportsDifferentTableCorrelationNames() throws SQLException {
        if (this.needTrace) {
            this.trace("DatabaseMetaData.supportsDifferentTableCorrelationNames()");
        }
        this.checkClosed(this.myConnection.isClosed());
        int n = 0;
        JdbcOdbcConnection jdbcOdbcConnection = this.myConnection;
        synchronized (jdbcOdbcConnection) {
            n = this.ODBCOBJ.jdbcGetInfoShort(this.myConnection.getHDBC(), 74);
        }
        return n == 1;
    }

    public boolean supportsExpressionsInOrderBy() throws SQLException {
        String string = new String("Y");
        if (this.needTrace) {
            this.trace("DatabaseMetaData.supportsExpressionsInOrderBy()");
        }
        if (this.myConnection.isClosed()) {
            this.JDBCError("JERR_OBJECT_IS_CLOSED", "DatabaseMetaData.supportsExpressionsInOrderBy()");
        }
        String string2 = null;
        JdbcOdbcConnection jdbcOdbcConnection = this.myConnection;
        synchronized (jdbcOdbcConnection) {
            string2 = this.ODBCOBJ.jdbcGetInfoStr(this.myConnection.getHDBC(), 27);
        }
        return string2.compareTo(string) == 0;
    }

    public boolean supportsExtendedSQLGrammar() throws SQLException {
        if (this.needTrace) {
            this.trace("DatabaseMetaData.supportsExtendedSQLGrammar()");
        }
        this.checkClosed(this.myConnection.isClosed());
        int n = 0;
        JdbcOdbcConnection jdbcOdbcConnection = this.myConnection;
        synchronized (jdbcOdbcConnection) {
            n = this.ODBCOBJ.jdbcGetInfoShort(this.myConnection.getHDBC(), 15);
        }
        return n == 2;
    }

    public boolean supportsFullOuterJoins() throws SQLException {
        String string = new String("F");
        if (this.needTrace) {
            this.trace("DatabaseMetaData.supportsFullOuterJoins()");
        }
        this.checkClosed(this.myConnection.isClosed());
        String string2 = null;
        JdbcOdbcConnection jdbcOdbcConnection = this.myConnection;
        synchronized (jdbcOdbcConnection) {
            string2 = this.ODBCOBJ.jdbcGetInfoStr(this.myConnection.getHDBC(), 38);
        }
        return string2.compareTo(string) == 0;
    }

    public boolean supportsGroupBy() throws SQLException {
        if (this.needTrace) {
            this.trace("DatabaseMetaData.supportsGroupBy()");
        }
        this.checkClosed(this.myConnection.isClosed());
        int n = 0;
        JdbcOdbcConnection jdbcOdbcConnection = this.myConnection;
        synchronized (jdbcOdbcConnection) {
            n = this.ODBCOBJ.jdbcGetInfoShort(this.myConnection.getHDBC(), 88);
        }
        return n != 0;
    }

    public boolean supportsGroupByBeyondSelect() throws SQLException {
        if (this.needTrace) {
            this.trace("DatabaseMetaData.supportsGroupByBeyondSelect()");
        }
        this.checkClosed(this.myConnection.isClosed());
        int n = 0;
        JdbcOdbcConnection jdbcOdbcConnection = this.myConnection;
        synchronized (jdbcOdbcConnection) {
            n = this.ODBCOBJ.jdbcGetInfoShort(this.myConnection.getHDBC(), 88);
        }
        return n == 2;
    }

    public boolean supportsGroupByUnrelated() throws SQLException {
        if (this.needTrace) {
            this.trace("DatabaseMetaData.supportsGroupByUnrelated()");
        }
        this.checkClosed(this.myConnection.isClosed());
        int n = 0;
        JdbcOdbcConnection jdbcOdbcConnection = this.myConnection;
        synchronized (jdbcOdbcConnection) {
            n = this.ODBCOBJ.jdbcGetInfoShort(this.myConnection.getHDBC(), 88);
        }
        return n == 3;
    }

    public boolean supportsIntegrityEnhancementFacility() throws SQLException {
        String string = new String("Y");
        if (this.needTrace) {
            this.trace("DatabaseMetaData.supportsIntegrityEnhancementFacility()");
        }
        this.checkClosed(this.myConnection.isClosed());
        String string2 = null;
        JdbcOdbcConnection jdbcOdbcConnection = this.myConnection;
        synchronized (jdbcOdbcConnection) {
            string2 = this.ODBCOBJ.jdbcGetInfoStr(this.myConnection.getHDBC(), 73);
        }
        return string2.compareTo(string) == 0;
    }

    public boolean supportsLikeEscapeClause() throws SQLException {
        String string = new String("Y");
        if (this.needTrace) {
            this.trace("DatabaseMetaData.supportsLikeEscapeClause()");
        }
        this.checkClosed(this.myConnection.isClosed());
        String string2 = null;
        JdbcOdbcConnection jdbcOdbcConnection = this.myConnection;
        synchronized (jdbcOdbcConnection) {
            string2 = this.ODBCOBJ.jdbcGetInfoStr(this.myConnection.getHDBC(), 113);
        }
        return string2.compareTo(string) == 0;
    }

    public boolean supportsLimitedOuterJoins() throws SQLException {
        String string = new String("N");
        if (this.needTrace) {
            this.trace("DatabaseMetaData.supportsLimitedOuterJoins()");
        }
        this.checkClosed(this.myConnection.isClosed());
        String string2 = null;
        JdbcOdbcConnection jdbcOdbcConnection = this.myConnection;
        synchronized (jdbcOdbcConnection) {
            string2 = this.ODBCOBJ.jdbcGetInfoStr(this.myConnection.getHDBC(), 38);
        }
        return string2.compareTo(string) != 0;
    }

    public boolean supportsMinimumSQLGrammar() throws SQLException {
        if (this.needTrace) {
            this.trace("DatabaseMetaData.supportsMinimumSQLGrammar()");
        }
        this.checkClosed(this.myConnection.isClosed());
        int n = 0;
        JdbcOdbcConnection jdbcOdbcConnection = this.myConnection;
        synchronized (jdbcOdbcConnection) {
            n = this.ODBCOBJ.jdbcGetInfoShort(this.myConnection.getHDBC(), 15);
        }
        return n == 0 || n == 1 || n == 2;
    }

    public boolean supportsMixedCaseIdentifiers() throws SQLException {
        if (this.needTrace) {
            this.trace("DatabaseMetaData.supportsMixedCaseIdentifiers()");
        }
        this.checkClosed(this.myConnection.isClosed());
        return (this.gbDbCase & 3) != 0;
    }

    public boolean supportsMixedCaseQuotedIdentifiers() throws SQLException {
        if (this.needTrace) {
            this.trace("DatabaseMetaData.supportsMixedCaseQuotedIdentifiers()");
        }
        this.checkClosed(this.myConnection.isClosed());
        int n = 0;
        JdbcOdbcConnection jdbcOdbcConnection = this.myConnection;
        synchronized (jdbcOdbcConnection) {
            n = this.ODBCOBJ.jdbcGetInfoShort(this.myConnection.getHDBC(), 93);
        }
        return (n & 3) != 0;
    }

    public boolean supportsMultipleResultSets() throws SQLException {
        String string = new String("Y");
        if (this.needTrace) {
            this.trace("DatabaseMetaData.supportsMultipleResultSets()");
        }
        this.checkClosed(this.myConnection.isClosed());
        String string2 = null;
        JdbcOdbcConnection jdbcOdbcConnection = this.myConnection;
        synchronized (jdbcOdbcConnection) {
            string2 = this.ODBCOBJ.jdbcGetInfoStr(this.myConnection.getHDBC(), 36);
        }
        return string2.compareTo(string) == 0;
    }

    public boolean supportsMultipleTransactions() throws SQLException {
        String string = new String("Y");
        if (this.needTrace) {
            this.trace("DatabaseMetaData.supportsMultipleTransactions()");
        }
        this.checkClosed(this.myConnection.isClosed());
        String string2 = null;
        JdbcOdbcConnection jdbcOdbcConnection = this.myConnection;
        synchronized (jdbcOdbcConnection) {
            string2 = this.ODBCOBJ.jdbcGetInfoStr(this.myConnection.getHDBC(), 37);
        }
        return string2.compareTo(string) == 0;
    }

    public boolean supportsNonNullableColumns() throws SQLException {
        if (this.needTrace) {
            this.trace("DatabaseMetaData.supportsNonNullableColumns()");
        }
        this.checkClosed(this.myConnection.isClosed());
        int n = 0;
        JdbcOdbcConnection jdbcOdbcConnection = this.myConnection;
        synchronized (jdbcOdbcConnection) {
            n = this.ODBCOBJ.jdbcGetInfoShort(this.myConnection.getHDBC(), 75);
        }
        return n == 1;
    }

    public boolean supportsOpenCursorsAcrossCommit() throws SQLException {
        if (this.needTrace) {
            this.trace("DatabaseMetaData.supportsOpenCursorsAcrossCommit()");
        }
        this.checkClosed(this.myConnection.isClosed());
        int n = 0;
        JdbcOdbcConnection jdbcOdbcConnection = this.myConnection;
        synchronized (jdbcOdbcConnection) {
            n = this.ODBCOBJ.jdbcGetInfoShort(this.myConnection.getHDBC(), 23);
        }
        return n == 2;
    }

    public boolean supportsOpenCursorsAcrossRollback() throws SQLException {
        if (this.needTrace) {
            this.trace("DatabaseMetaData.supportsOpenCursorsAcrossRollback()");
        }
        this.checkClosed(this.myConnection.isClosed());
        int n = 0;
        JdbcOdbcConnection jdbcOdbcConnection = this.myConnection;
        synchronized (jdbcOdbcConnection) {
            n = this.ODBCOBJ.jdbcGetInfoShort(this.myConnection.getHDBC(), 24);
        }
        return n == 2;
    }

    public boolean supportsOpenStatementsAcrossCommit() throws SQLException {
        if (this.needTrace) {
            this.trace("DatabaseMetaData.supportsOpenStatementsAcrossCommit()");
        }
        this.checkClosed(this.myConnection.isClosed());
        int n = 0;
        JdbcOdbcConnection jdbcOdbcConnection = this.myConnection;
        synchronized (jdbcOdbcConnection) {
            n = this.ODBCOBJ.jdbcGetInfoShort(this.myConnection.getHDBC(), 23);
        }
        return n == 2 || n == 1;
    }

    public boolean supportsOpenStatementsAcrossRollback() throws SQLException {
        if (this.needTrace) {
            this.trace("DatabaseMetaData.supportsOpenStatementsAcrossRollback()");
        }
        this.checkClosed(this.myConnection.isClosed());
        int n = 0;
        JdbcOdbcConnection jdbcOdbcConnection = this.myConnection;
        synchronized (jdbcOdbcConnection) {
            n = this.ODBCOBJ.jdbcGetInfoShort(this.myConnection.getHDBC(), 24);
        }
        return n == 2 || n == 1;
    }

    public boolean supportsOrderByUnrelated() throws SQLException {
        String string = new String("Y");
        if (this.needTrace) {
            this.trace("DatabaseMetaData.supportsOrderByUnrelated()");
        }
        this.checkClosed(this.myConnection.isClosed());
        String string2 = null;
        JdbcOdbcConnection jdbcOdbcConnection = this.myConnection;
        synchronized (jdbcOdbcConnection) {
            string2 = this.ODBCOBJ.jdbcGetInfoStr(this.myConnection.getHDBC(), 90);
        }
        return string2.compareTo(string) == 0;
    }

    public boolean supportsOuterJoins() throws SQLException {
        String string = new String("Y");
        if (this.needTrace) {
            this.trace("DatabaseMetaData.supportsOuterJoins()");
        }
        this.checkClosed(this.myConnection.isClosed());
        String string2 = null;
        JdbcOdbcConnection jdbcOdbcConnection = this.myConnection;
        synchronized (jdbcOdbcConnection) {
            string2 = this.ODBCOBJ.jdbcGetInfoStr(this.myConnection.getHDBC(), 38);
        }
        return string2.compareTo(string) == 0;
    }

    public boolean supportsPositionedDelete() throws SQLException {
        if (this.needTrace) {
            this.trace("DatabaseMetaData.supportsPositionedDelete()");
        }
        this.checkClosed(this.myConnection.isClosed());
        int n = 0;
        JdbcOdbcConnection jdbcOdbcConnection = this.myConnection;
        synchronized (jdbcOdbcConnection) {
            n = this.ODBCOBJ.jdbcGetInfoInt(this.myConnection.getHDBC(), 80);
        }
        return (n & 1) != 0;
    }

    public boolean supportsPositionedUpdate() throws SQLException {
        if (this.needTrace) {
            this.trace("DatabaseMetaData.supportsPositionedUpdate()");
        }
        this.checkClosed(this.myConnection.isClosed());
        int n = 0;
        JdbcOdbcConnection jdbcOdbcConnection = this.myConnection;
        synchronized (jdbcOdbcConnection) {
            n = this.ODBCOBJ.jdbcGetInfoInt(this.myConnection.getHDBC(), 80);
        }
        return (n & 2) != 0;
    }

    public boolean supportsResultSetConcurrency(int n, int n2) throws SQLException {
        if (this.needTrace) {
            this.trace("DatabaseMetaData.supportsResultSetConcurrency(" + n + "," + n2 + ")");
        }
        this.checkClosed(this.myConnection.isClosed());
        if (n == 1004 || n == 1003 || n == 1005) {
            if (n2 == 1007 || n2 == 1008) {
                return true;
            }
            this.JDBCError("JERR_INV_RS_CONCUR", "DatabaseMetaData.supportsResultSetConcurrency(" + n2 + ")");
        } else {
            this.JDBCError("JERR_INV_CURSOR_TYPE", "DatabaseMetaData.supportsResultSetConcurrency(" + n + ")");
        }
        return false;
    }

    public boolean supportsResultSetType(int n) throws SQLException {
        if (this.needTrace) {
            this.trace("DatabaseMetaData.supportsResultSetType(" + n + ")");
        }
        this.checkClosed(this.myConnection.isClosed());
        switch (n) {
            case 1003: 
            case 1004: 
            case 1005: {
                return true;
            }
        }
        throw this.JDBCError("JERR_INV_CURSOR_TYPE", "DatabaseMetaData.supportsResultSetType(" + n + ")", null);
    }

    public boolean supportsSchemasInDataManipulation() throws SQLException {
        if (this.needTrace) {
            this.trace("DatabaseMetaData.supportsSchemasInDataManipulation()");
        }
        this.checkClosed(this.myConnection.isClosed());
        int n = 0;
        JdbcOdbcConnection jdbcOdbcConnection = this.myConnection;
        synchronized (jdbcOdbcConnection) {
            n = this.ODBCOBJ.jdbcGetInfoInt(this.myConnection.getHDBC(), 91);
        }
        return (n & 1) != 0;
    }

    public boolean supportsSchemasInIndexDefinitions() throws SQLException {
        if (this.needTrace) {
            this.trace("DatabaseMetaData.supportsSchemasInIndexDefinitions()");
        }
        this.checkClosed(this.myConnection.isClosed());
        int n = 0;
        JdbcOdbcConnection jdbcOdbcConnection = this.myConnection;
        synchronized (jdbcOdbcConnection) {
            n = this.ODBCOBJ.jdbcGetInfoInt(this.myConnection.getHDBC(), 91);
        }
        return (n & 8) != 0;
    }

    public boolean supportsSchemasInPrivilegeDefinitions() throws SQLException {
        if (this.needTrace) {
            this.trace("DatabaseMetaData.supportsSchemasInPrivilegeDefinitions()");
        }
        this.checkClosed(this.myConnection.isClosed());
        int n = 0;
        JdbcOdbcConnection jdbcOdbcConnection = this.myConnection;
        synchronized (jdbcOdbcConnection) {
            n = this.ODBCOBJ.jdbcGetInfoInt(this.myConnection.getHDBC(), 91);
        }
        return (n & 0x10) != 0;
    }

    public boolean supportsSchemasInProcedureCalls() throws SQLException {
        if (this.needTrace) {
            this.trace("DatabaseMetaData.supportsSchemasInProcedureCalls()");
        }
        this.checkClosed(this.myConnection.isClosed());
        int n = 0;
        JdbcOdbcConnection jdbcOdbcConnection = this.myConnection;
        synchronized (jdbcOdbcConnection) {
            n = this.ODBCOBJ.jdbcGetInfoInt(this.myConnection.getHDBC(), 91);
        }
        return (n & 2) != 0;
    }

    public boolean supportsSchemasInTableDefinitions() throws SQLException {
        if (this.needTrace) {
            this.trace("DatabaseMetaData.supportsSchemasInTableDefinitions()");
        }
        this.checkClosed(this.myConnection.isClosed());
        int n = 0;
        JdbcOdbcConnection jdbcOdbcConnection = this.myConnection;
        synchronized (jdbcOdbcConnection) {
            n = this.ODBCOBJ.jdbcGetInfoInt(this.myConnection.getHDBC(), 91);
        }
        return (n & 4) != 0;
    }

    public boolean supportsSelectForUpdate() throws SQLException {
        if (this.needTrace) {
            this.trace("DatabaseMetaData.supportsSelectForUpdate()");
        }
        this.checkClosed(this.myConnection.isClosed());
        int n = 0;
        JdbcOdbcConnection jdbcOdbcConnection = this.myConnection;
        synchronized (jdbcOdbcConnection) {
            n = this.ODBCOBJ.jdbcGetInfoInt(this.myConnection.getHDBC(), 80);
        }
        return (n & 4) != 0;
    }

    public boolean supportsStoredProcedures() throws SQLException {
        String string = new String("Y");
        if (this.needTrace) {
            this.trace("DatabaseMetaData.supportsStoredProcedures()");
        }
        this.checkClosed(this.myConnection.isClosed());
        String string2 = null;
        JdbcOdbcConnection jdbcOdbcConnection = this.myConnection;
        synchronized (jdbcOdbcConnection) {
            string2 = this.ODBCOBJ.jdbcGetInfoStr(this.myConnection.getHDBC(), 21);
        }
        return string2.compareTo(string) == 0;
    }

    public boolean supportsSubqueriesInComparisons() throws SQLException {
        if (this.needTrace) {
            this.trace("DatabaseMetaData.supportsSubqueriesInComparisons()");
        }
        this.checkClosed(this.myConnection.isClosed());
        int n = 0;
        JdbcOdbcConnection jdbcOdbcConnection = this.myConnection;
        synchronized (jdbcOdbcConnection) {
            n = this.ODBCOBJ.jdbcGetInfoInt(this.myConnection.getHDBC(), 95);
        }
        return (n & 1) != 0;
    }

    public boolean supportsSubqueriesInExists() throws SQLException {
        if (this.needTrace) {
            this.trace("DatabaseMetaData.supportsSubqueriesInExists()");
        }
        this.checkClosed(this.myConnection.isClosed());
        int n = 0;
        JdbcOdbcConnection jdbcOdbcConnection = this.myConnection;
        synchronized (jdbcOdbcConnection) {
            n = this.ODBCOBJ.jdbcGetInfoInt(this.myConnection.getHDBC(), 95);
        }
        return (n & 2) != 0;
    }

    public boolean supportsSubqueriesInIns() throws SQLException {
        if (this.needTrace) {
            this.trace("DatabaseMetaData.supportsSubqueriesInIns()");
        }
        this.checkClosed(this.myConnection.isClosed());
        int n = 0;
        JdbcOdbcConnection jdbcOdbcConnection = this.myConnection;
        synchronized (jdbcOdbcConnection) {
            n = this.ODBCOBJ.jdbcGetInfoInt(this.myConnection.getHDBC(), 95);
        }
        return (n & 4) != 0;
    }

    public boolean supportsSubqueriesInQuantifieds() throws SQLException {
        if (this.needTrace) {
            this.trace("DatabaseMetaData.supportsSubqueriesInQuantifieds()");
        }
        this.checkClosed(this.myConnection.isClosed());
        int n = 0;
        JdbcOdbcConnection jdbcOdbcConnection = this.myConnection;
        synchronized (jdbcOdbcConnection) {
            n = this.ODBCOBJ.jdbcGetInfoInt(this.myConnection.getHDBC(), 95);
        }
        return (n & 8) != 0;
    }

    public boolean supportsTableCorrelationNames() throws SQLException {
        if (this.needTrace) {
            this.trace("DatabaseMetaData.supportsTableCorrelationNames()");
        }
        this.checkClosed(this.myConnection.isClosed());
        int n = 0;
        JdbcOdbcConnection jdbcOdbcConnection = this.myConnection;
        synchronized (jdbcOdbcConnection) {
            n = this.ODBCOBJ.jdbcGetInfoShort(this.myConnection.getHDBC(), 74);
        }
        return n != 0;
    }

    public boolean supportsTransactionIsolationLevel(int n) throws SQLException {
        int n2 = 0;
        if (this.needTrace) {
            this.trace("DatabaseMetaData.supportsTransactionIsolationLevel()");
        }
        this.checkClosed(this.myConnection.isClosed());
        switch (n) {
            case 1: {
                n2 = 1;
                break;
            }
            case 2: {
                n2 = 2;
                break;
            }
            case 4: {
                n2 = 4;
                break;
            }
            case 8: {
                n2 = 8;
                break;
            }
            default: {
                this.JDBCError("JERR_INV_TRANS_ISOLATION_VAL", "DatabaseMetaData.supportsTransactionIsolationLevel(" + n + ")");
            }
        }
        int n3 = 0;
        JdbcOdbcConnection jdbcOdbcConnection = this.myConnection;
        synchronized (jdbcOdbcConnection) {
            n3 = this.ODBCOBJ.jdbcGetInfoInt(this.myConnection.getHDBC(), 72);
        }
        return (n3 & n2) != 0;
    }

    public boolean supportsTransactions() throws SQLException {
        if (this.needTrace) {
            this.trace("DatabaseMetaData.supportsTransactions()");
        }
        this.checkClosed(this.myConnection.isClosed());
        int n = 0;
        JdbcOdbcConnection jdbcOdbcConnection = this.myConnection;
        synchronized (jdbcOdbcConnection) {
            n = this.ODBCOBJ.jdbcGetInfoShort(this.myConnection.getHDBC(), 46);
        }
        return n != 0;
    }

    public boolean supportsUnion() throws SQLException {
        if (this.needTrace) {
            this.trace("DatabaseMetaData.supportsUnion()");
        }
        this.checkClosed(this.myConnection.isClosed());
        int n = 0;
        JdbcOdbcConnection jdbcOdbcConnection = this.myConnection;
        synchronized (jdbcOdbcConnection) {
            n = this.ODBCOBJ.jdbcGetInfoInt(this.myConnection.getHDBC(), 96);
        }
        return (n & 1) != 0;
    }

    public boolean supportsUnionAll() throws SQLException {
        if (this.needTrace) {
            this.trace("DatabaseMetaData.supportsUnionAll()");
        }
        this.checkClosed(this.myConnection.isClosed());
        int n = 0;
        JdbcOdbcConnection jdbcOdbcConnection = this.myConnection;
        synchronized (jdbcOdbcConnection) {
            n = this.ODBCOBJ.jdbcGetInfoInt(this.myConnection.getHDBC(), 96);
        }
        return (n & 2) != 0;
    }

    public boolean updatesAreDetected(int n) throws SQLException {
        if (this.needTrace) {
            this.trace("DatabaseMetaData.updatesAreDeleted(" + n + ")");
        }
        this.checkClosed(this.myConnection.isClosed());
        switch (n) {
            case 1003: 
            case 1004: 
            case 1005: {
                return false;
            }
        }
        throw this.JDBCError("JERR_INV_CURSOR_TYPE", "DatabaseMetaData.updatesAreDeleted(" + n + ")", null);
    }

    public boolean usesLocalFilePerTable() throws SQLException {
        if (this.needTrace) {
            this.trace("DatabaseMetaData.usesLocalFilePerTable()");
        }
        this.checkClosed(this.myConnection.isClosed());
        return false;
    }

    public boolean usesLocalFiles() throws SQLException {
        if (this.needTrace) {
            this.trace("DatabaseMetaData.usesLocalFiles()");
        }
        this.checkClosed(this.myConnection.isClosed());
        return false;
    }

    protected ResourceBundle getResourceBundle() {
        return this.myConnection.getResourceBundle();
    }
}

