/*
 * Decompiled with CFR 0.152.
 */
package org.msgpack.template.builder;

import java.lang.annotation.Annotation;
import java.lang.reflect.AccessibleObject;
import java.lang.reflect.Field;
import java.lang.reflect.Modifier;
import java.lang.reflect.Type;
import java.util.ArrayList;
import org.msgpack.annotation.Beans;
import org.msgpack.annotation.Ignore;
import org.msgpack.annotation.Index;
import org.msgpack.annotation.Message;
import org.msgpack.annotation.MessagePackBeans;
import org.msgpack.annotation.MessagePackMessage;
import org.msgpack.annotation.MessagePackOrdinalEnum;
import org.msgpack.annotation.NotNullable;
import org.msgpack.annotation.Optional;
import org.msgpack.annotation.OrdinalEnum;
import org.msgpack.template.FieldList;
import org.msgpack.template.FieldOption;
import org.msgpack.template.Template;
import org.msgpack.template.TemplateRegistry;
import org.msgpack.template.builder.DefaultFieldEntry;
import org.msgpack.template.builder.FieldEntry;
import org.msgpack.template.builder.TemplateBuildException;
import org.msgpack.template.builder.TemplateBuilder;

public abstract class AbstractTemplateBuilder
implements TemplateBuilder {
    protected TemplateRegistry registry;

    /*
     * WARNING - void declaration
     */
    protected AbstractTemplateBuilder(TemplateRegistry registry) {
        void var1_1;
        this.registry = var1_1;
    }

    @Override
    public <T> Template<T> buildTemplate(Type targetType) throws TemplateBuildException {
        Class clazz = (Class)targetType;
        this.checkClassValidation(clazz);
        FieldEntry[] fieldEntryArray = this.getFieldOption(clazz);
        fieldEntryArray = this.toFieldEntries(clazz, (FieldOption)fieldEntryArray);
        return this.buildTemplate(clazz, fieldEntryArray);
    }

    /*
     * WARNING - void declaration
     */
    @Override
    public <T> Template<T> buildTemplate(Class<T> targetClass, FieldList fieldList) throws TemplateBuildException {
        void var1_1;
        FieldEntry[] fieldEntryArray;
        this.checkClassValidation(targetClass);
        fieldEntryArray = AbstractTemplateBuilder.a(targetClass, (FieldList)fieldEntryArray);
        return this.buildTemplate((Class<T>)var1_1, fieldEntryArray);
    }

    protected abstract <T> Template<T> buildTemplate(Class<T> var1, FieldEntry[] var2);

    /*
     * WARNING - void declaration
     */
    protected void checkClassValidation(Class<?> targetClass) {
        if (targetClass.isInterface()) {
            throw new TemplateBuildException("Cannot build template for interface: " + targetClass.getName());
        }
        if (Modifier.isAbstract(targetClass.getModifiers())) {
            throw new TemplateBuildException("Cannot build template for abstract class: " + targetClass.getName());
        }
        if (targetClass.isArray()) {
            throw new TemplateBuildException("Cannot build template for array class: " + targetClass.getName());
        }
        if (targetClass.isPrimitive()) {
            void var1_1;
            throw new TemplateBuildException("Cannot build template of primitive type: " + var1_1.getName());
        }
    }

    protected FieldOption getFieldOption(Class<?> targetClass) {
        MessagePackMessage messagePackMessage;
        Message message = targetClass.getAnnotation(Message.class);
        if (message == null) {
            return FieldOption.DEFAULT;
        }
        if ((messagePackMessage = ((Class)((Object)messagePackMessage)).getAnnotation(MessagePackMessage.class)) == null) {
            return FieldOption.DEFAULT;
        }
        return message.value();
    }

    private static FieldEntry[] a(Class<?> clazz, FieldList object) {
        object = ((FieldList)object).getList();
        FieldEntry[] fieldEntryArray = new FieldEntry[object.size()];
        for (int i2 = 0; i2 < object.size(); ++i2) {
            FieldList.Entry entry = (FieldList.Entry)object.get(i2);
            if (entry.isAvailable()) {
                try {
                    fieldEntryArray[i2] = new DefaultFieldEntry(clazz.getDeclaredField(entry.getName()), entry.getOption());
                    continue;
                }
                catch (SecurityException securityException) {
                    throw new TemplateBuildException(securityException);
                }
                catch (NoSuchFieldException noSuchFieldException) {
                    throw new TemplateBuildException(noSuchFieldException);
                }
            }
            fieldEntryArray[i2] = new DefaultFieldEntry();
        }
        return fieldEntryArray;
    }

    /*
     * Could not resolve type clashes
     * Unable to fully structure code
     */
    protected FieldEntry[] toFieldEntries(Class<?> targetClass, FieldOption from) {
        var9_3 = targetClass;
        var1_1 = new ArrayList();
        var11_5 = 0;
        for (var3_7 = var9_3; var3_7 != Object.class; var3_7 = var3_7.getSuperclass()) {
            var4_8 = var3_7.getDeclaredFields();
            var11_5 += var4_8.length;
            var1_1.add(var4_8);
        }
        var3_7 = new Field[var11_5];
        var4_9 = 0;
        for (var5_10 = var1_1.size() - 1; var5_10 >= 0; --var5_10) {
            var6_11 = (Field[])var1_1.get(var5_10);
            System.arraycopy(var6_11, 0, var3_7, var4_9, var6_11.length);
            var4_9 += var6_11.length;
        }
        var1_1 = var3_7;
        var3_7 = new ArrayList<E>();
        var4_9 = -1;
        for (Field var7_14 : var1_1) {
            block14: {
                block15: {
                    block13: {
                        var10_16 = from;
                        var9_3 = var7_14;
                        var11_5 = var7_14.getModifiers();
                        if (!Modifier.isStatic(var11_5) && !Modifier.isFinal(var11_5) && !Modifier.isTransient(var11_5)) break block13;
                        v0 = FieldOption.IGNORE;
                        break block14;
                    }
                    if (!AbstractTemplateBuilder.isAnnotated((AccessibleObject)var9_3, Ignore.class)) break block15;
                    v0 = FieldOption.IGNORE;
                    break block14;
                }
                if (AbstractTemplateBuilder.isAnnotated((AccessibleObject)var9_3, Optional.class)) ** GOTO lbl-1000
                if (AbstractTemplateBuilder.isAnnotated((AccessibleObject)var9_3, NotNullable.class)) {
                    v0 = FieldOption.NOTNULLABLE;
                } else if (var10_16 != FieldOption.DEFAULT) {
                    v0 = var10_16;
                } else if (var9_3.getType().isPrimitive()) {
                    v0 = FieldOption.NOTNULLABLE;
                } else lbl-1000:
                // 2 sources

                {
                    v0 = var8_15 = FieldOption.OPTIONAL;
                }
            }
            if (v0 == FieldOption.IGNORE) continue;
            var10_17 = var4_9;
            var9_3 = var7_14;
            var11_6 = var9_3.getAnnotation(Index.class);
            v1 = var9_4 = var11_6 == null ? var10_17 + 1 : var11_6.value();
            if (var3_7.size() > var9_4 && var3_7.get(var9_4) != null) {
                throw new TemplateBuildException("duplicated index: " + var9_4);
            }
            if (var9_4 < 0) {
                throw new TemplateBuildException("invalid index: " + var9_4);
            }
            while (var3_7.size() <= var9_4) {
                var3_7.add(null);
            }
            var3_7.set(var9_4, new DefaultFieldEntry(var7_14, var8_15));
            if (var4_9 >= var9_4) continue;
            var4_9 = var9_4;
        }
        var1_1 = new FieldEntry[var4_9 + 1];
        for (var5_10 = 0; var5_10 < var3_7.size(); ++var5_10) {
            var6_13 = (FieldEntry)var3_7.get(var5_10);
            var1_1[var5_10] = var6_13 == null ? new DefaultFieldEntry() : var6_13;
        }
        return var1_1;
    }

    /*
     * WARNING - void declaration
     */
    @Override
    public void writeTemplate(Type targetType, String directoryName) {
        void var1_1;
        throw new UnsupportedOperationException(var1_1.toString());
    }

    @Override
    public <T> Template<T> loadTemplate(Type targetType) {
        return null;
    }

    /*
     * WARNING - void declaration
     */
    public static boolean isAnnotated(Class<?> targetClass, Class<? extends Annotation> with) {
        void var1_1;
        return targetClass.getAnnotation(var1_1) != null;
    }

    /*
     * WARNING - void declaration
     */
    public static boolean isAnnotated(AccessibleObject accessibleObject, Class<? extends Annotation> with) {
        void var1_1;
        return accessibleObject.getAnnotation(var1_1) != null;
    }

    public static boolean matchAtClassTemplateBuilder(Class<?> targetClass, boolean hasAnnotation) {
        Class<?> clazz;
        if (hasAnnotation) {
            return AbstractTemplateBuilder.isAnnotated(targetClass, Message.class) || AbstractTemplateBuilder.isAnnotated(targetClass, MessagePackMessage.class);
        }
        return !targetClass.isEnum() && !clazz.isInterface();
    }

    /*
     * WARNING - void declaration
     */
    public static boolean matchAtBeansClassTemplateBuilder(Type targetType, boolean hasAnnotation) {
        void var1_1;
        Class clazz = (Class)targetType;
        if (var1_1 != false) {
            Type type;
            return AbstractTemplateBuilder.isAnnotated((Class)targetType, Beans.class) || AbstractTemplateBuilder.isAnnotated((Class)type, MessagePackBeans.class);
        }
        return !clazz.isEnum() || !clazz.isInterface();
    }

    public static boolean matchAtArrayTemplateBuilder(Class<?> targetClass, boolean hasAnnotation) {
        return targetClass.isArray();
    }

    public static boolean matchAtOrdinalEnumTemplateBuilder(Class<?> targetClass, boolean hasAnnotation) {
        Class<?> clazz;
        if (hasAnnotation) {
            return AbstractTemplateBuilder.isAnnotated(targetClass, OrdinalEnum.class) || AbstractTemplateBuilder.isAnnotated(targetClass, MessagePackOrdinalEnum.class);
        }
        return clazz.isEnum();
    }
}

