/*
 * Decompiled with CFR 0.152.
 */
package javassist.compiler;

import javassist.ClassPool;
import javassist.CtClass;
import javassist.CtPrimitiveType;
import javassist.NotFoundException;
import javassist.compiler.CodeGen;
import javassist.compiler.CompileError;
import javassist.compiler.JvstCodeGen;
import javassist.compiler.MemberResolver;
import javassist.compiler.TypeChecker;
import javassist.compiler.ast.ASTList;
import javassist.compiler.ast.ASTree;
import javassist.compiler.ast.CallExpr;
import javassist.compiler.ast.CastExpr;
import javassist.compiler.ast.Expr;
import javassist.compiler.ast.Member;
import javassist.compiler.ast.Symbol;

public class JvstTypeChecker
extends TypeChecker {
    private JvstCodeGen a;

    /*
     * WARNING - void declaration
     */
    public JvstTypeChecker(CtClass cc, ClassPool cp, JvstCodeGen gen) {
        super((CtClass)var1_1, (ClassPool)var2_2);
        void var3_3;
        void var2_2;
        void var1_1;
        this.a = var3_3;
    }

    public void addNullIfVoid() {
        if (this.exprType == 344) {
            this.exprType = 307;
            this.arrayDim = 0;
            this.className = "java/lang/Object";
        }
    }

    /*
     * WARNING - void declaration
     */
    @Override
    public void atMember(Member mem) throws CompileError {
        void var1_1;
        String string = mem.get();
        if (string.equals(this.a.b)) {
            this.exprType = 307;
            this.arrayDim = 1;
            this.className = "java/lang/Object";
            return;
        }
        if (string.equals("$sig")) {
            this.exprType = 307;
            this.arrayDim = 1;
            this.className = "java/lang/Class";
            return;
        }
        if (string.equals("$type") || string.equals("$class")) {
            this.exprType = 307;
            this.arrayDim = 0;
            this.className = "java/lang/Class";
            return;
        }
        super.atMember((Member)var1_1);
    }

    /*
     * WARNING - void declaration
     */
    @Override
    protected void atFieldAssign(Expr expr, int op, ASTree left, ASTree right) throws CompileError {
        void var3_3;
        int n2;
        CtClass[] ctClassArray;
        if (left instanceof Member && ((Member)left).get().equals(this.a.b)) {
            right.accept(this);
            ctClassArray = this.a.d;
            if (this.a.d == null) {
                return;
            }
            n2 = ctClassArray.length;
            for (int i2 = 0; i2 < n2; ++i2) {
                this.compileUnwrapValue(ctClassArray[i2]);
            }
            return;
        }
        super.atFieldAssign((Expr)ctClassArray, n2, (ASTree)var3_3, right);
    }

    /*
     * WARNING - void declaration
     */
    @Override
    public void atCastExpr(CastExpr expr) throws CompileError {
        void var1_1;
        ASTree aSTree;
        Object object = expr.getClassName();
        if (object != null && expr.getArrayDim() == 0 && (aSTree = ((ASTList)object).head()) instanceof Symbol && ((ASTList)object).tail() == null) {
            object = ((Symbol)aSTree).get();
            if (((String)object).equals(this.a.f)) {
                this.atCastToRtype(expr);
                return;
            }
            if (((String)object).equals("$w")) {
                this.atCastToWrapper(expr);
                return;
            }
        }
        super.atCastExpr((CastExpr)var1_1);
    }

    protected void atCastToRtype(CastExpr expr) throws CompileError {
        CtPrimitiveType ctPrimitiveType;
        CtClass ctClass = this.a.e;
        ((CastExpr)((Object)ctPrimitiveType)).getOprand().accept(this);
        if (this.exprType == 344 || CodeGen.isRefType(this.exprType) || this.arrayDim > 0) {
            this.compileUnwrapValue(ctClass);
            return;
        }
        if (ctClass instanceof CtPrimitiveType) {
            int n2;
            ctPrimitiveType = (CtPrimitiveType)ctClass;
            this.exprType = n2 = MemberResolver.descToType(ctPrimitiveType.getDescriptor());
            this.arrayDim = 0;
            this.className = null;
        }
    }

    protected void atCastToWrapper(CastExpr expr) throws CompileError {
        expr.getOprand().accept(this);
        if (CodeGen.isRefType(this.exprType) || this.arrayDim > 0) {
            return;
        }
        CtClass ctClass = this.resolver.lookupClass(this.exprType, this.arrayDim, this.className);
        if (ctClass instanceof CtPrimitiveType) {
            this.exprType = 307;
            this.arrayDim = 0;
            this.className = "java/lang/Object";
        }
    }

    /*
     * WARNING - void declaration
     */
    @Override
    public void atCallExpr(CallExpr expr) throws CompileError {
        void var1_1;
        Object object = expr.oprand1();
        if (object instanceof Member) {
            object = ((Member)object).get();
            if (this.a.h != null && ((String)object).equals(this.a.g)) {
                this.a.h.setReturnType(this, (ASTList)expr.oprand2());
                return;
            }
            if (((String)object).equals("$cflow")) {
                this.atCflow((ASTList)expr.oprand2());
                return;
            }
        }
        super.atCallExpr((CallExpr)var1_1);
    }

    protected void atCflow(ASTList cname) throws CompileError {
        this.exprType = 324;
        this.arrayDim = 0;
        this.className = null;
    }

    public boolean isParamListName(ASTList args) {
        if (this.a.d != null && args != null && args.tail() == null) {
            ASTree aSTree;
            return (aSTree = ((ASTList)aSTree).head()) instanceof Member && ((Member)aSTree).get().equals(this.a.c);
        }
        return false;
    }

    @Override
    public int getMethodArgsLength(ASTList args) {
        String string = this.a.c;
        int n2 = 0;
        while (args != null) {
            ASTree aSTree = args.head();
            if (aSTree instanceof Member && ((Member)aSTree).get().equals(string)) {
                if (this.a.d != null) {
                    n2 += this.a.d.length;
                }
            } else {
                ++n2;
            }
            args = args.tail();
        }
        return n2;
    }

    @Override
    public void atMethodArgs(ASTList args, int[] types, int[] dims, String[] cnames) throws CompileError {
        CtClass[] ctClassArray = this.a.d;
        String string = this.a.c;
        int n2 = 0;
        while (args != null) {
            ASTree aSTree = args.head();
            if (aSTree instanceof Member && ((Member)aSTree).get().equals(string)) {
                if (ctClassArray != null) {
                    int n3 = ctClassArray.length;
                    for (int i2 = 0; i2 < n3; ++i2) {
                        CtClass ctClass = ctClassArray[i2];
                        this.setType(ctClass);
                        types[n2] = this.exprType;
                        dims[n2] = this.arrayDim;
                        cnames[n2] = this.className;
                        ++n2;
                    }
                }
            } else {
                aSTree.accept(this);
                types[n2] = this.exprType;
                dims[n2] = this.arrayDim;
                cnames[n2] = this.className;
                ++n2;
            }
            args = args.tail();
        }
    }

    /*
     * WARNING - void declaration
     */
    protected void compileUnwrapValue(CtClass type) throws CompileError {
        void var1_1;
        if (type == CtClass.voidType) {
            this.addNullIfVoid();
            return;
        }
        this.setType((CtClass)var1_1);
    }

    /*
     * WARNING - void declaration
     */
    public void setType(CtClass type) throws CompileError {
        void var1_1;
        this.a((CtClass)var1_1, 0);
    }

    private void a(CtClass ctClass, int n2) throws CompileError {
        if (ctClass.isPrimitive()) {
            ctClass = (CtPrimitiveType)ctClass;
            this.exprType = MemberResolver.descToType(((CtPrimitiveType)ctClass).getDescriptor());
            this.arrayDim = n2;
            this.className = null;
            return;
        }
        if (ctClass.isArray()) {
            try {
                this.a(ctClass.getComponentType(), n2 + 1);
                return;
            }
            catch (NotFoundException notFoundException) {
                throw new CompileError("undefined type: " + ctClass.getName());
            }
        }
        this.exprType = 307;
        this.arrayDim = n2;
        this.className = MemberResolver.javaToJvmName(ctClass.getName());
    }
}

