/*
 * Decompiled with CFR 0.152.
 */
package javassist.bytecode;

import java.io.DataInputStream;
import java.io.IOException;
import java.util.Map;
import javassist.bytecode.AttributeInfo;
import javassist.bytecode.ByteArray;
import javassist.bytecode.ConstPool;

public class BootstrapMethodsAttribute
extends AttributeInfo {
    public static final String tag = "BootstrapMethods";

    /*
     * WARNING - void declaration
     */
    BootstrapMethodsAttribute(ConstPool cp, int n2, DataInputStream in) throws IOException {
        super((ConstPool)var1_1, (int)var2_2, (DataInputStream)var3_3);
        void var3_3;
        void var2_2;
        void var1_1;
    }

    /*
     * WARNING - void declaration
     */
    public BootstrapMethodsAttribute(ConstPool cp, BootstrapMethod[] methods) {
        super((ConstPool)var1_1, tag);
        void var1_1;
        int n2 = 2;
        for (int i2 = 0; i2 < methods.length; ++i2) {
            n2 += 4 + (methods[i2].arguments.length << 1);
        }
        byte[] byArray = new byte[n2];
        ByteArray.write16bit(methods.length, byArray, 0);
        n2 = 2;
        for (int i3 = 0; i3 < methods.length; ++i3) {
            ByteArray.write16bit(methods[i3].methodRef, byArray, n2);
            ByteArray.write16bit(methods[i3].arguments.length, byArray, n2 + 2);
            int[] nArray = methods[i3].arguments;
            n2 += 4;
            for (int i4 = 0; i4 < nArray.length; ++i4) {
                ByteArray.write16bit(nArray[i4], byArray, n2);
                n2 += 2;
            }
        }
        this.set(byArray);
    }

    public BootstrapMethod[] getMethods() {
        byte[] byArray = this.get();
        int n2 = ByteArray.readU16bit(byArray, 0);
        BootstrapMethod[] bootstrapMethodArray = new BootstrapMethod[n2];
        int n3 = 2;
        for (int i2 = 0; i2 < n2; ++i2) {
            int n4 = ByteArray.readU16bit(byArray, n3);
            int n5 = ByteArray.readU16bit(byArray, n3 + 2);
            int[] nArray = new int[n5];
            n3 += 4;
            for (int i3 = 0; i3 < n5; ++i3) {
                nArray[i3] = ByteArray.readU16bit(byArray, n3);
                n3 += 2;
            }
            bootstrapMethodArray[i2] = new BootstrapMethod(n4, nArray);
        }
        return bootstrapMethodArray;
    }

    /*
     * WARNING - void declaration
     */
    @Override
    public AttributeInfo copy(ConstPool newCp, Map classnames) {
        void var1_1;
        BootstrapMethod[] bootstrapMethodArray = this.getMethods();
        ConstPool constPool = this.getConstPool();
        for (int i2 = 0; i2 < bootstrapMethodArray.length; ++i2) {
            BootstrapMethod bootstrapMethod = bootstrapMethodArray[i2];
            bootstrapMethodArray[i2].methodRef = constPool.copy(bootstrapMethod.methodRef, newCp, classnames);
            for (int i3 = 0; i3 < bootstrapMethod.arguments.length; ++i3) {
                bootstrapMethod.arguments[i3] = constPool.copy(bootstrapMethod.arguments[i3], newCp, classnames);
            }
        }
        return new BootstrapMethodsAttribute((ConstPool)var1_1, bootstrapMethodArray);
    }

    public static class BootstrapMethod {
        public int methodRef;
        public int[] arguments;

        /*
         * WARNING - void declaration
         */
        public BootstrapMethod(int method, int[] args) {
            void var2_2;
            void var1_1;
            this.methodRef = var1_1;
            this.arguments = var2_2;
        }
    }
}

