/*
 * Decompiled with CFR 0.152.
 */
package dbmaster.jdbc.ws.client;

import dbmaster.jdbc.ws.client.Connection2;
import java.sql.Connection;
import java.sql.SQLException;
import java.util.HashSet;
import java.util.Iterator;
import javax.sql.ConnectionEvent;
import javax.sql.ConnectionEventListener;
import javax.sql.StatementEventListener;

public class PooledConnection
implements javax.sql.PooledConnection {
    protected Connection physicalConn;
    protected Connection logicalConn;
    protected boolean isClose = false;
    protected HashSet<ConnectionEventListener> connectionEventListenerS = new HashSet(12);
    protected HashSet<StatementEventListener> statementEventListenerS = new HashSet(12);
    protected int CONN_CLOSE = 1;
    protected int CONN_ERROR = 2;

    PooledConnection(Connection connection) throws SQLException {
        this.physicalConn = connection;
    }

    @Override
    public void addConnectionEventListener(ConnectionEventListener connectionEventListener) {
        this.connectionEventListenerS.add(connectionEventListener);
    }

    @Override
    public void addStatementEventListener(StatementEventListener statementEventListener) {
        this.statementEventListenerS.add(statementEventListener);
    }

    @Override
    public void close() throws SQLException {
        if (this.isClose) {
            return;
        }
        this.physicalConn.close();
        SQLException sQLException = new SQLException("physical connection had been closed");
        this.callListener(this.CONN_ERROR, sQLException);
    }

    private void callListener(int n, SQLException sQLException) {
        ConnectionEvent connectionEvent = new ConnectionEvent(this, sQLException);
        Iterator<ConnectionEventListener> iterator = this.connectionEventListenerS.iterator();
        while (iterator.hasNext()) {
            if (n == this.CONN_CLOSE) {
                iterator.next().connectionClosed(connectionEvent);
                continue;
            }
            iterator.next().connectionErrorOccurred(connectionEvent);
        }
    }

    @Override
    public Connection getConnection() throws SQLException {
        this.logicalConn = new Connection2(this, this.physicalConn);
        return this.logicalConn;
    }

    @Override
    public void removeConnectionEventListener(ConnectionEventListener connectionEventListener) {
        this.connectionEventListenerS.remove(connectionEventListener);
    }

    @Override
    public void removeStatementEventListener(StatementEventListener statementEventListener) {
        this.statementEventListenerS.remove(statementEventListener);
    }

    public void logicalClose() throws SQLException {
        this.callListener(this.CONN_CLOSE, null);
    }
}

