LEX = flex -B --never-interactive
YACC = bison
include Makefile.in
RM = rm
CC = cc -fpic  -I. -I/APP_HOME/include
BINDIR=bin
SODIR=lib

SOOBJS=$(SODIR)/$(UDF_NAME).tab.o\
        $(SODIR)/$(UDF_NAME)udf.o\
        $(SODIR)/lex.$(UDF_NAME).o\
        $(SODIR)/hash.o

BINOBJS=$(BINDIR)/$(UDF_NAME).tab.o\
        $(BINDIR)/lex.$(UDF_NAME).o\
        $(BINDIR)/hash.o

all : buildso

buildso : $(SOOBJS)
	ld -Bshareable -o $(UDF_NAME).so $(SOOBJS)

testbin : $(BINOBJS)
	$(CC) -o $(UDF_NAME) $(BINOBJS)

$(SODIR)/%.o : %.c $(SODIR)
	$(CC) -DBUILD_UDF=1 -c -o $@ $<

$(BINDIR)/%.o : %.c $(BINDIR)
	$(CC) -DBUILD_MAIN=1 -c -o $@ $<

$(SODIR) :
	if [ ! -d $(SODIR) ] ; then mkdir $(SODIR) ; fi

$(BINDIR) :
	if [ ! -d $(BINDIR) ] ; then mkdir $(BINDIR) ; fi

$(UDF_NAME).tab.c: $(UDF_NAME).y
	$(YACC) -l -d -v -o $(UDF_NAME).tab.c -p $(UDF_NAME) $(UDF_NAME).y

lex.$(UDF_NAME).c: $(UDF_NAME).l
	$(LEX) -L $(UDF_NAME).l

clean:
	$(RM) *.tab.*  lex.* *.output *.o *.bak
	if exist $(SODIR) rmdir $(SODIR)
	if exist $(BINDIR) rmdir $(BINDIR)


