/* RSA_MD5.H - header file for RSA_MD5C.C
 * $Id: rsa_md5.h,v 1.1.1.1 2001/12/18 09:59:11 yu Exp $
 */

/* Copyright (C) 1991-2, RSA Data Security, Inc. Created 1991. All
rights reserved.

License to copy and use this software is granted provided that it
is identified as the "RSA Data Security, Inc. MD5 Message-Digest
Algorithm" in all material mentioning or referencing this software
or this function.

License is also granted to make and use derivative works provided
that such works are identified as "derived from the RSA Data
Security, Inc. MD5 Message-Digest Algorithm" in all material
mentioning or referencing the derived work.

RSA Data Security, Inc. makes no representations concerning either
the merchantability of this software or the suitability of this
software for any particular purpose. It is provided "as is"
without express or implied warranty of any kind.

These notices must be retained in any copies of any part of this
documentation and/or software.
 */

#ifndef _SYS_RSA_MD5_H_
#define _SYS_RSA_MD5_H_
/* MD5 context. */
typedef unsigned int ui32;
typedef struct RSA_MD5Context {
  ui32 state[4];	/* state (ABCD) */
  ui32 count[2];	/* number of bits, modulo 2^64 (lsb first) */
  unsigned char buffer[64];	/* input buffer */
} RSA_MD5_CTX;

void   RSA_MD5Init (RSA_MD5_CTX *);
void   RSA_MD5Update (RSA_MD5_CTX *, const unsigned char *, unsigned int);
void   RSA_MD5Pad (RSA_MD5_CTX *);
void   RSA_MD5Final (unsigned char [16], RSA_MD5_CTX *);
char * MD5End(RSA_MD5_CTX *, char *);
char * MD5File(const char *, char *);
char * MD5Data(const char *, unsigned int, char *);
#endif /* _SYS_RSA_MD5_H_ */
