################################################################################
# Copyright(c) 1998-2010 SYSCOM
# All rights reserved.
################################################################################
# 1. Sample purpose:
#    (1) Demonstrate TRIGGER CALL SQL SP.
# 2. To create the SQL Stored Procedure
#    (1) Run the script "createtable.sql" to create the schema objects which be 
#        used in this Procedure in advance. For more information, please see
#        the file "createtable.sql".
#    (2) Use DMSQL tool to create the SQL SP, SQL command like:
#        connect to "DBSAMPLE5" "SYSADM" "";
#        // for Windows:
#        create procedure from '@APP_HOME@\samples\SQLSP\updateonduty.sp';
#        // for Linux:
#        create procedure from '/APP_HOME/samples/SQLSP/updateonduty.sp';
#    (3) use JDBATool to create the SQL SP:
#        connect to the database.
#        create-procedure-wizard => select language SQL => import updateonduty.sp 
#        => finish.
# 3. To call the SQL Stored Procedure
#    (1) use DMSQL tool
#        CALL SQLSP_UPDATEONDUTY(1,'2010-5-10','10:10:10');
#
# For more information, see the README file in the same directory.
################################################################################

CREATE PROCEDURE SQLSP_UPDATEONDUTY(
  IN  iEmpId      INT,
  IN  iDutyDate   DATE,
  IN  iFlushTime  TIME)
LANGUAGE SQL
BEGIN
  DECLARE fgExist INT DEFAULT 0;
  DECLARE cur1 CURSOR FOR SELECT COUNT(*) FROM sqlsp_doorcardonduty 
    WHERE empid = iEmpId AND dutydate = iDutyDate;
    
  OPEN cur1;
  FETCH cur1 INTO fgExist;
  CLOSE cur1;
  
  IF fgExist <= 0 THEN
    INSERT INTO sqlsp_doorcardonduty VALUES(iEmpId, iDutyDate, iFlushTime, 
      iFlushTime);
  ELSE
    UPDATE sqlsp_doorcardonduty SET outTime = iFlushTime 
      WHERE empid = iEmpId AND dutydate = iDutyDate;
  END IF;
END;
