################################################################################
# Copyright(c) 1998-2025 SYSCOM
# All rights reserved.
################################################################################

CREATE or replace PROCEDURE SP_DELETE(in tbname varchar(128), in wherestr varchar(1024), nCommit int)
LANGUAGE SQL
TRANSACTION
BEGIN
    declare i integer;
    declare var1 integer;
    declare sql1 char(2048);
    declare sql2 char(256);

    set sql1='select 0 from ' || tbname || ' where ' || wherestr || ' FOR UPDATE';
    set sql2='delete from ' || tbname || ' where current of cur';

    set i=0;
    prepare selstmt from sql1;
    prepare delstmt from sql2;

    DECLARE cur CURSOR FOR selstmt;

    open cur;

    loop
        set i = i + 1;
        fetch from cur into var1;
        if SQLCODE != 0 then
            break;
        end if;

        // execute delete where current of
        execute delstmt;

        // commit every nCommit records
        if i > nCommit then
            commit;
            set i=0;
        end if;

    end loop;

    //free
    close cur;
    DEALLOCATE PREPARE selstmt;
    DEALLOCATE PREPARE delstmt;

    commit;
end;
