################################################################################
# Copyright(c) 1998-2010 SYSCOM
# All rights reserved.
################################################################################
# 1. Sample purpose:
#    (1) Demonstrate IF-THEN-ELSE statement.
#    (2) Demonstrate LOOP statement.
#    (3) Demonstrate CONTINUE-HANDLER.
# 2. To create the SQL Stored Procedure
#    (1) Run the script "createtable.sql" to create the schema objects which be 
#        used in this Procedure in advance. For more information, please see
#        the file "createtable.sql".
#    (2) Use DMSQL tool to create the SQL SP, SQL command like:
#        connect to "DBSAMPLE5" "SYSADM" "";
#        // for Windows:
#        create procedure from '@APP_HOME@\samples\SQLSP\loopif.sp';
#        // for Linux:
#        create procedure from '/APP_HOME/samples/SQLSP/loopif.sp';
#    (3) use JDBATool to create the SQL SP:
#        connect to the database.
#        create-procedure-wizard => select language SQL => import loopif.sp 
#        => finish.
# 3. To call the SQL Stored Procedure
#    (1) use DMSQL tool
#        CALL SQLSP_LOOPIF(1002,?,?,?);
#
# For more information, see the README file in the same directory.
################################################################################

# This procedure will calculate the number of different levels(A,B,C) for a 
# course.
#   A: grade >= 85
#   B: grade >= 60 and grade < 85
#   C: grade < 60 or grade is NULL
CREATE PROCEDURE SQLSP_LOOPIF(
  IN  iCid  INT, 
  OUT oALvl INT, 
  OUT oBLvl INT, 
  OUT oCLvl INT)
LANGUAGE SQL
BEGIN
  DECLARE tmpGrade INT DEFAULT 0;
  DECLARE noData INT;
  DECLARE cur1 CURSOR FOR SELECT grade FROM sqlsp_grade WHERE cid = iCid;
  DECLARE CONTINUE HANDLER FOR NOT FOUND SET noData = 1;
  
  SET noData = 0;
  SET oALvl = 0;
  SET oBLvl = 0;
  SET oCLvl = 0;
  
  OPEN cur1;
  FETCH cur1 INTO tmpGrade;
  LOOP
    IF noData = 1 THEN
      BREAK;
    END IF;
    
    IF tmpGrade >= 85 THEN
      SET oALvl = oALvl + 1;
    ELSEIF tmpGrade >= 60 THEN
      SET oBLvl = oBLvl + 1;
    ELSE 
      SET oCLvl = oCLvl + 1;
    END IF;
    
    FETCH cur1 INTO tmpGrade;
  END LOOP;
  CLOSE cur1;
END;

