################################################################################
# Copyright(c) 1998-2010 SYSCOM
# All rights reserved.
################################################################################
# 1. Sample purpose:
#    (1) Demonstrate INPUT PARAMETER in SQL SP.
#    (2) Demonstrate DATA TYPE in SQL SP.
#    (3) Demonstrate ASSIGNMENT statement.
#    (4) Demonstrate EXPRESSION in SQL SP.
#    (5) Demonstrate BUILT-IN FUNCTIONS in SQL SP.
# 2. To create the SQL Stored Procedure
#    (1) Run the script "createtable.sql" to create the schema objects which be 
#        used in this Procedure in advance. For more information, please see
#        the file "createtable.sql".
#    (2) Use DMSQL tool to create the SQL SP, SQL command like:
#        connect to "DBSAMPLE5" "SYSADM" "";
#        // for Windows:
#        create procedure from '@APP_HOME@\samples\SQLSP\inputparam.sp';
#        // for Linux:
#        create procedure from '/APP_HOME/samples/SQLSP/inputparam.sp';
#    (3) use JDBATool to create the SQL SP:
#        connect to the database.
#        create-procedure-wizard => select language SQL => import inputparam.sp 
#        => finish.
# 3. To call the SQL Stored Procedure
#    (1) use DMSQL tool
#         CALL SQLSP_INPUTPARAM(123,1234567890,1234567890123456789,1234.567,
#             1234567890.12345,12345678901234567890.123456789012345678,
#             '41424344454647484950'x,'CHAR TYPE FIELD','VARCHAR TYPE FIELD',
#             N'NCHAR TYPE FIELD', N'NVARCHAR TYPE FIELD', '2010-04-13',
#             '13:34:45','2010-04-13 13:34:45');
#
# For more information, see the README file in the same directory.
################################################################################

CREATE PROCEDURE SQLSP_INPUTPARAM(
  IN  C1_I16        SMALLINT,
  IN  C2_I32        INT,
  IN  C3_I64        BIGINT,
  IN  C4_REAL       REAL,
  IN  C5_DOUBLE     DOUBLE,
  IN  C6_DEC        DECIMAL(38,18),
  IN  C7_BINARY     BINARY(20),
  IN  C8_CHAR       CHAR(20),
  IN  C9_VARCHAR    VARCHAR(20),
  IN  C10_NCHAR     NCHAR(20),
  IN  C11_NVARCHAR  NVARCHAR(20),
  IN  C12_DATE      DATE,
  IN  C13_TIME      TIME,
  IN  C14_TIMESTAMP TIMESTAMP)
LANGUAGE SQL
BEGIN
  # insert values into table directly.
  INSERT INTO SQLSP_ALLTYPE VALUES(NULL, 
    C1_I16,     C2_I32,       C3_I64,       C4_REAL,
    C5_DOUBLE,  C6_DEC,       C7_BINARY,    C8_CHAR,
    C9_VARCHAR, C10_NCHAR,    C11_NVARCHAR, C12_DATE,
    C13_TIME,   C14_TIMESTAMP);
    
  # insert expression with input parameter.
  # for numeric type, can use +,-,*,/ operator.
  # for character type, can use || to concatenate.
  INSERT INTO SQLSP_ALLTYPE VALUES(DEFAULT, 
    -1*C1_I16,     -1*C2_I32,       -1*C3_I64,
    -1*C4_REAL,    -1*C5_DOUBLE,    -1*C6_DEC,
    C7_BINARY,     
    '-1' || SUBSTRING(C8_CHAR,1,18),
    '-1' || SUBSTRING(C9_VARCHAR,1,10),
    '-1' || TRIM(SUBSTRING(C10_NCHAR,1,10)) || CAST(RAND() AS CHAR(10)),    
    '-1' || C11_NVARCHAR, 
    ADD_DAYS(C12_DATE, -1),
    ADD_HOURS(C13_TIME, -1),  
    TIMESTAMPADD('Y', 2, C14_TIMESTAMP));
    
  # process input parameter, then insert into table.
  # database built-in functions can be used in SET statement
  SET C1_I16 = C1_I16/10 + 1;
  SET C2_I32 = C2_I32/100 + MOD(C2_I32,2);
  SET C3_I64 = C3_I64/1000 - ABS(ROUND(C4_REAL));
  SET C6_DEC = C6_DEC/10000000000000000.9999999999 + 1234567890.123456789;
  SET C8_CHAR = 'PRE_' || SUBSTRING(C8_CHAR,1,5);
  SET C12_DATE = DATEPART(NOW());
  SET C13_TIME = TIMEPART(NOW());
  SET C14_TIMESTAMP = NOW();
  INSERT INTO SQLSP_ALLTYPE VALUES(NULL, 
    C1_I16,     C2_I32,       C3_I64,       C4_REAL,
    C5_DOUBLE,  C6_DEC,       C7_BINARY,    C8_CHAR,
    C9_VARCHAR, C10_NCHAR,    C11_NVARCHAR, C12_DATE,
    C13_TIME,   C14_TIMESTAMP);
END;
