################################################################################
# Copyright(c) 1998-2010 SYSCOM
# All rights reserved.
################################################################################
# 1. Sample purpose:
#    (1) Demonstrate FOR statement.
#    (2) Demonstrate CASE statement.
# 2. To create the SQL Stored Procedure
#    (1) Run the script "createtable.sql" to create the schema objects which be 
#        used in this Procedure in advance. For more information, please see
#        the file "createtable.sql".
#    (2) Use DMSQL tool to create the SQL SP, SQL command like:
#        connect to "DBSAMPLE5" "SYSADM" "";
#        create procedure from '<DBMASTER_HOME>/samples/SQLSP/forcase.sp';
#    (3) use JDBATool to create the SQL SP:
#        connect to the database.
#        create-procedure-wizard => select language SQL => import forcase.sp 
#        => finish.
# 3. To call the SQL Stored Procedure
#    (1) use DMSQL tool
#        CALL SQLSP_FORCASE(1002,?,?,?);
#
# For more information, see the README file in the same directory.
################################################################################

# This procedure will calculate the number of different levels(A,B,C) for a 
# course.
#   A: grade >= 85
#   B: grade >= 60 and grade < 85
#   C: grade < 60 or grade is NULL
CREATE PROCEDURE SQLSP_FORCASE(
  IN  iCid  INT, 
  OUT oALvl INT, 
  OUT oBLvl INT, 
  OUT oCLvl INT)
LANGUAGE SQL
BEGIN
  DECLARE tmpGrade INT DEFAULT 0;

  DECLARE aLvl INT DEFAULT 0;
  DECLARE bLvl INT DEFAULT 0;
  DECLARE cLvl INT DEFAULT 0;
  DECLARE switch CHAR(1);
  
  FOR ln AS 
  SELECT 
    CASE 
      WHEN grade >= 85 THEN 'A' 
      WHEN grade >= 60 THEN 'B'
      ELSE  'C' 
    END AS lvl
    FROM sqlsp_grade WHERE cid = iCid 
  DO
    SET switch = ln.lvl;
    CASE switch
      WHEN 'A' THEN
        SET aLvl = aLvl + 1;
      WHEN 'B' THEN
        SET bLvl = bLvl + 1;
      WHEN 'C' THEN
        SET cLvl = cLvl + 1;
    END CASE;
  END FOR;
  
  SET oALvl = aLvl;
  SET oBLvl = bLvl;
  SET oCLvl = cLvl;
END;
