////////////////////////////////////////////////////////////////////////////////
// Copyright(c) 1998-2010 SYSCOM.
// All rights reserved.
////////////////////////////////////////////////////////////////////////////////
// This SQL script is used to create the schema objects for SQL Stored Procedure
// samples. Before create a SQL Stored Procedure sample, you should run this 
// script in dmSQL to create related schema objects.
//
// To run this script:
//    1. start database "DBSAMPLE5" with DBMaster Server.
//    2. start dmSQL tool.
//    3. connect to the database, SQL Command like:
//       connect to "DBSAMPLE5" "SYSADM" "";
//    4. run script in dmSQL, SQL command like:
//       // for Windows:
//       run "C:\DBMaster\5.4\samples\SQLSP\createtable.sql";
//       // for Linux:
//       run "/APP_HOME/samples/SQLSP/createtable.sql";
////////////////////////////////////////////////////////////////////////////////

///////////////////////////////////////////////
// clear all related object
drop table sqlsp_alltype;
drop table sqlsp_grade;
drop table sqlsp_student;
drop table sqlsp_course;
drop table sqlsp_DoorCard;
drop table sqlsp_DoorCardOnDuty;
drop table sqlsp_t1;

///////////////////////////////////////////////
// sqlsp_alltype: all ordinary type
create table sqlsp_alltype(
  c0  serial(1),
  c1  smallint, 
  c2  int, 
  c3  bigint,
  c4  real, 
  c5  double, 
  c6  decimal(38,18), 
  c7  binary(20), 
  c8  char(20), 
  c9  varchar(20), 
  c10 nchar(20), 
  c11 nvarchar(20), 
  c12 date, 
  c13 time, 
  c14 timestamp);

/////////////////////////////////////////////////
// sqlsp_student:
create table sqlsp_student(
  sid   bigserial(1),
  sname char(30),
  primary key(sid));
insert into sqlsp_student values(?,?);
1,'Zhang';
2,'Wang';
3,'Li';
4,'Zhao';
5,'Liu';
end;

/////////////////////////////////////////////////
// sqlsp_course:
create table sqlsp_course(
  cid   serial(1001) primary key,
  cname char(30));
insert into sqlsp_course values(?,?);
null,'Chinese';
null,'English';
null,'Math';
null,'Geography';
end;

/////////////////////////////////////////////////
// sqlsp_grade:
create table sqlsp_grade(
  sid   bigint,
  cid   int,
  grade int,
  primary key(sid,cid),
  foreign key fk1(sid) references sqlsp_student(sid),
  foreign key fk2(cid) references sqlsp_course(cid));
insert into sqlsp_grade values(?,?,?);
1,1001,80;
1,1002,90;
1,1003,100;
1,1004,98;
2,1001,60;
2,1002,55;
2,1003,88;
3,1002,59;
3,1004,80;
4,1003,99;
end;

//////////////////////////////////////////////////
// sqlsp_DoorCard:
create table sqlsp_DoorCard(
  empid     int,
  flushDate date,
  flushTime time);
  
//////////////////////////////////////////////////
// sqlsp_DoorCardOnDuty:
create table sqlsp_DoorCardOnDuty(
  empid     int,
  dutyDate  date,
  inTime    time,
  outTime   time,
  primary key(empid,dutyDate));

/////////////////////////////////////////////////
// sqlsp_t1:
create table sqlsp_t1(c1 int);
