/******************************************************************************
 * Copyright(c) 1998-2010 SYSCOM
 * All rights reserved.
 ******************************************************************************
 * 1. Sample purpose:
 *    (1) Demonstrate CALL a SQL SP in C#.
 * 2. To Compile and run this C# program
 *    (1) Start command window(cmd.exe), add the path of C# compiler(csc.exe) 
 *        into environment variable PATH, such as:
 *        SET PATH=%PATH%;"C:\WINDOWS\Microsoft.NET\Framework\v3.5"
 *    (2) Compile the program, command like:
 *        csc callsqlsp.cs
 *    (3) Run the program:
 *        callsqlsp.exe
 * Note: 
 *   Compiling this program need .Net Framework 2.0 or later.
 *   Please firstly start database DBSAMPLE5 and create related table and 
 *   SQL SP. The dependency relationship like below:
 *      callsqlsp(C#) 
 *           +--> sqlsp_nest1(SQL SP) -> sqlsp_student(TABLE).
 *           +--> sqlsp_resultset(SQL SP) -> sqlsp_alltype(TABLE).
 *
 * For more information, see the README file in the same directory.
 ******************************************************************************/

using System;
using System.Data;
using System.Data.Odbc;

namespace CallSqlSp
{
  public class CallSqlSp
  {
    public string ConnectionString;
    public CallSqlSp(string cnStr)
    {
      ConnectionString = cnStr;
    }
    public CallSqlSp():this("Driver={DBMaster 5.4 Driver};Database=DBSAMPLE5;Uid=SYSADM;Pwd=;")
    {
    }
    
    public void TestInOutParam(int iSid)
    {
      OdbcConnection cn = new OdbcConnection(ConnectionString);
      OdbcCommand cmd = cn.CreateCommand();
      
      cmd.CommandText = "call sqlsp_nest1(?,?)";
      cmd.Parameters.Add("psid",OdbcType.Int).Value = iSid;
      cmd.Parameters.Add("psname",OdbcType.Char,30);
      cmd.Parameters["psname"].Direction = ParameterDirection.Output;
      cmd.Parameters["psname"].IsNullable = true;
      
      try
      {
        cn.Open();
        cmd.ExecuteNonQuery();
        if (cmd.Parameters["psname"].Value == DBNull.Value)
          Console.WriteLine("sname = " + "NULL");
        else
          Console.WriteLine("sname = " + cmd.Parameters["psname"].Value.ToString());
      }
      catch(Exception ex)
      {
        Console.WriteLine(ex.Message);
      }
      finally
      {
        if (cn != null) cn.Close();
      }
    }
    
    public void TestResultSet()
    {
      OdbcConnection cn = new OdbcConnection(ConnectionString);
      OdbcCommand cmd = cn.CreateCommand();
      OdbcDataReader reader = null;
      
      cmd.CommandText = "call sqlsp_resultset(?)";
      cmd.Parameters.Add("ptop",OdbcType.Int).Value = 2;
      
      try
      {
        cn.Open();
        reader = cmd.ExecuteReader();
        for(int i=0; i<reader.FieldCount; i++)
          Console.Write('\t' + reader.GetName(i));
        Console.WriteLine();
        while(reader.Read())
        {
          for(int i=0; i<reader.FieldCount; i++)
            if (reader.IsDBNull(i))
              Console.Write("\t" + "NULL");
            else
              Console.Write("\t" + reader[i]);
          Console.WriteLine();
        }
      }
      catch(Exception ex)
      {
        Console.WriteLine(ex.Message);
      }
      finally
      {
        if (reader != null) reader.Close();
        if (cn != null) cn.Close();
      }
    }
  }
  
  public class Program
  {
    public static void Main(string[] args)
    {
      CallSqlSp sp = new CallSqlSp();
      //sp.ConnectionString = "Driver={DBMaster 5.2 Driver};Database=SHORYDB;Uid=SHORY;Pwd=;";
      sp.TestInOutParam(1);
      sp.TestInOutParam(2);
      
      sp.TestResultSet();
    }
  }
}
