#!/usr/bin/env python
# -*- coding: UTF-8 -*-

import sys
import pyodbc

# initialize
table='py_transact'
field1='c1 int'
field2='c2 char(6)'
dbh=pyodbc.connect('DSN=dbsample5;uid=sysadm;pwd=')

print ('Connected to DB...')

# build a cursor handle 'sth'
sth=dbh.cursor()

# create table
try:
   sth.execute("drop table %(table)s" % (vars()))
except:
   pass
sth.execute("create table %(table)s (%(field1)s,%(field2)s)" %(vars()))

# modify the connection option --> set autocommit off
print ('modify AUTOCOMMIT to OFF')
dbh.autocommit=0

# insert 10 data
print ('begin a transaction to insert data')
print ('insert data...')
for i in range(10):
   sth.execute("insert into %s values(?,?)" %table,(i,'%s DBMaster'%i))

# commit and set autocommit on
print ('commit and finish a transaction')
print ('modify AUTOCOMMIT to ON')
dbh.commit()
dbh.autocommit=True

# select data
print ('')
sth.execute("select * from %s"%table)
result=sth.fetchall()

print ('data in table:')
for i in range(10):
   print (result[i],)
   if i == 4 or i == 9:
      print ('')

# update data

print ('update data to set c1=0 if c1>5')
sth.execute("update %s set c1=0 where c1>5"%table)
sth.execute("select * from %s"%table)
result=sth.fetchall()
print ('data in table:')
for i in range(10):
   print (result[i],)
   if i == 4 or i == 9:
      print ('')

# delete data
print ('delete data where c1=0')
sth.execute("delete from %s where c1=0"%table)
sth.execute("select * from %s"%table)
result=sth.fetchall()
print ('data in table:')
for i in range(len(result)):
   print (result[i],)
   if i == 4:
      print ('')

# drop table
sth.execute("drop table %s"%table)
print ('drop table')

# disconnect to DB
print ('Disconnect to DB')
sth.close()
dbh.close()