#!/usr/bin/env python
# -*- coding: UTF-8 -*-

# ----------------------------------------------------------
# show how to use connection handle method 'datetimeformat'
# ----------------------------------------------------------

import sys
import pyodbc
from datetime import datetime

dbh=pyodbc.connect('DSN=dbsample5;uid=sysadm;pwd=')

table='py_test'
field1='c1 timestamp'

# build a cursor handle 'sth'
sth=dbh.cursor()

# create table for testing
try:
   sth.execute("drop table %s" % table)
except pyodbc.Error as data:
   print ("Error message:", data)
   sth.execute("create table %(table)s (%(field1)s)" %(vars()))

try:
   print ("insert data into %s(%s)" % (table, field1))
   print ("... insert now()")
   sth.execute("insert into %s values(?)"%table,(datetime.now(),))
except pyodbc.Warning:
   pass

try:
   print ("... insert an integer - 924072246")
   sth.execute("insert into %s values(?)"%table,(924072246,))
   print ("... insert a tuple data - (1980,12,10,9,35,40)")
except pyodbc.Error as data:
   print ("Error message:", data)
date=datetime(1980,12,10,9,35,40)

sth.execute("insert into %s values(?)"%table,(date,))

print ("... insert a string - '1998/10/1 8:59:30'")
sth.execute("insert into %s values(?)"%table,('1998/10/1 8:59:30.000 PM',))

print ("... insert a DateTime object - Timestamp(2000, 1, 1, 0, 0, 0)")

date = datetime(2000, 1, 1, 0, 0, 0)
sth.execute("insert into %s values(?)"%table,(date,))

print
print ('Show the result')
sth.execute("select * from %s" % table)
r = sth.fetchall()

def isLeapYear(year):
    return ( year % 400 == 0 ) or ( year % 10 == 0 and year % 4 == 0 )

for i in range(len(r)):
   
   if i == 0:
      print ('... as a DateTime object')
      print (r[i],)
   elif i == 1:
      print ('... as a string')
      print (r[i][0],)
   elif i == 2:
      print ('... as a tuple')
      print (r[i][0].timetuple(),)
   else:
      if i == 3:
         print ('... as a formated string')
      print (r[i][0].strftime('%Y-%m-%d %H:%M:%S'))
      
   if isLeapYear(r[i][0].year) == 1:
      print (' is a leap year')
   else:
      print (' is not a leap year')

print
print ('Timezone: %s' % r[0][0].time())
sth.close()
dbh.close()