#!/usr/bin/perl

use strict;
use DBI;

my $DB   = "DBSAMPLE5";
my $USER = "SYSADM";
my $PASS = "";
#
# conncet to database
#
my $dbh = DBI->connect( "dbi:DBMaster:$DB", $USER, $PASS)
          ||die "Database connection not made:$DBI::errstr";

#
# We use do method to create table. The table name is pl_Employees
#
print "We use do method to create table. The table name is pl_Employees.\n";
$dbh->{PrintError} = 0;
my $sql = qq{ Drop TABLE pl_Employees };
$dbh->do($sql);
$dbh->{PrintError} = 1;
$sql = qq{ CREATE TABLE pl_Employees ( Id    INTEGER NOT NULL, 
                                    Name  VARCHAR(20), 
                                    Title VARCHAR(20), 
                                    Phone CHAR(10) 
				  )};
$dbh->do($sql) || die "$DBI::errstr";
print "Creating Table OK!!The Table Name:pl_Employees.\n";

#
# We use 'do' method to insert 10 records into pl_Employees.
#
print "We use 'do' method to insert 10 records into pl_Employees\n";
for (my $i=1; $i<=10; $i++){
	$sql = qq{INSERT INTO pl_Employees values($i,'Paul','Manager$i','27418010')};
        $dbh->do($sql) || die "$DBI::errstr";	
}
print "Inserting 10 records into pl_Employees!!\n";

#
# We use bind_columns and fetch method to show pl_Employees.
#
print "We use bind_columns and fetch method to show pl_Employees.\n";
$sql = qq{ SELECT Id,Name,Title,Phone FROM pl_Employees };
my $sth = $dbh->prepare( $sql );
$sth->execute()||die "$DBI::errstr";
my( $Id, $Name, $Title, $Phone );
$sth->bind_columns( undef, \$Id, \$Name, \$Title, \$Phone );
while( $sth->fetch() ) {  
#	print "$Id,$Name, $Title, $Phone\n";
	printf("%4d %-10s %-10s %-10s\n", $Id, $Name, $Title, $Phone);
}

#
# We Use do method to Update even Id in pl_Employees.
#
print "We Use do method to Update records in pl_Employees.\n";
for (my $i=1;$i<=10;$i++){
	if ($i%2==0) {
        	$dbh->do("Update pl_Employees set Title='Senior SE' where Id=".$i)
        	      || die "$DBI::errstr";
	}	
}
print "Updating Ok!!!\n";

#
# We Use prepare, execute and fetchrow_array to show pl_Employees.
#
print "We Use prepare,execute and fetchrow_array to show pl_Employees.\n";
$sth = $dbh->prepare("SELECT Id,Name,Title,Phone FROM pl_Employees");
$sth->execute();
###field Name
printf("%4d %-10s %-10s %-10s\n",
       $sth->{NAME}->[0], $sth->{NAME}->[1], $sth->{NAME}->[2], $sth->{NAME}->[3]);
while(my @ary=$sth->fetchrow_array){
	printf("%4d %-10s %-10s %-10s\n",
	       $ary[0],$ary[1],$ary[2],$ary[3]);
}


#
# We Use do method to Delete all records in pl_Employees
#
print "We Use do method to Delete all records in pl_Employees.\n";
$dbh->do("Delete from pl_Employees") || die "$DBI::errstr";
print "Deleting all records in pl_Employees Ok!!\n";

#
# We Use prepare,bind_param and execute method to insert 10 records
# into pl_Employees.
#
print "We Use prepare,bind_param and execute method to insert 10 records\n";
print "into pl_Employees.\n";
$sql = qq{INSERT INTO pl_Employees values(?,'Paul',?,'27418010')};
$sth = $dbh->prepare($sql);
for (my $i=1;$i<=10;$i++){
        $sth->bind_param(1,$i);
        $sth->bind_param(2,"Manager$i");
	$sth->execute()||die "$DBI::errstr";
}
print "Inserting 10 records into pl_Employees!!\n";

#
# We Use prepare,execute and fetchrow_arrayref to show pl_Employees.
# 
print "We Use prepare and fetchrow_arrayref to show pl_Employees.\n";
my $sth = $dbh->prepare("SELECT Id,Name,Title,Phone FROM pl_Employees");
$sth->execute();
print"fetchrow_arrayref:\n";
while (my $ary_ref=$sth->fetchrow_arrayref){
	printf("%4d %-10s %-10s %-10s\n",
	       $ary_ref->[0],$ary_ref->[1],$ary_ref->[2],$ary_ref->[3]);
}

#
# We Use execute(@value),prepare and execute method to update even Id
# in pl_Employees.
#
print "We Use execute, prepare and execute method to update even Id\n";
print "in pl_Employees.\n";
for (my $i=1;$i<=10;$i++){
	if ($i%2==0) {
        	$sth = $dbh->prepare("Update pl_Employees set Title='Senior SE' where Id=?")
        	       || die "$DBI::errstr";
		$sth->execute($i);
	}	
}
print "We Update OK.\n";

#
# We use prepare, execute and fetchrow_hash to show pl_Employees.
#
print "We use prepare, execute and fetchrow_hash to show pl_Employees.\n";
$sth = $dbh->prepare("SELECT Id,Name,Title,Phone FROM pl_Employees");
$sth->execute();
while (my $hash_ref = $sth->fetchrow_hashref){
	printf("%4d %-10s %-10s %-10s\n",
	       $hash_ref->{"ID"},$hash_ref->{"NAME"},$hash_ref->{"TITLE"},$hash_ref->{"PHONE"});
}


#
# We use execute method to delete all records in pl_Employees.
#
print "We use execute method to delete all records in pl_Employees.\n";
$sth = $dbh->prepare("Delete FROM pl_Employees");
$sth->execute();
$dbh->commit();
print "Delete Ok!!\n";

#
# We Use do method to Drop Table. Transaction method
#
$dbh->{RaiseError}=1;
$dbh->{AutoCommit}=0;
print "We use do method to Drop pl_Employees.\n";
eval {
  	$sql = qq{drop table pl_Employees};
  	$dbh->do( $sql );
};
if ($@) {
  	$dbh->rollback();
	print "Rollback. $DBI::errstr\n";	
} 
else {
  	$dbh->commit();
	print "Drop OK.\n";
}


$sth->finish();
$dbh->disconnect();

