-- dmdbi sample

-- load dmdbi module
local dmdbi = assert(require 'dmdbi')
print("Load dmdbi module")

-- connect to db DBSAMPLE5
local con = assert(dmdbi.New("DBSAMPLE5", "SYSADM", ""))
print("Connect to Database DBSAMPLE5")
-- set autocommit on
assert(con:autocommit(true))
print("Set autocommit on")

-- ping db
local function ping()
    local p = con:ping()
    if p then
        print("DB connect")
    else
        print("DB disconnect")
    end
end
ping()

-- create table and insert data
assert(con:execdirect("create table T1(C1 serial, C2 int, C3 varchar(20))"))
print("Create table T1")
assert(con:execdirect("insert into T1 values(, 2, 'varchar01')"))
assert(con:execdirect("insert into T1 values(, 4, 'varchar02')"))
print("Insert data into T1 with execdirect")

-- use prepare and execute to insert data
local p1 = assert(con:prepare("insert into T1 values(, ?, ?)"))
assert(p1:execute(6, 'varchar03'))
assert(p1:execute(8, 'varchar04'))
print("Insert data into T1 with prepare and execute")

-- get last serial id
print("Last serial id is: ", con:last_id())

print("Get table T1 data with rows() iterator")
-- rows() iterator to get data
local stmt = assert(con:execdirect("select * from T1"))
-- get column names
local col_names = assert(stmt:columns())
local col = ""
for _, v in ipairs(col_names) do
    col = col .. v .. "\t"
end
print(col)
-- fetch data with rows iterator
local row = nil
for row in assert(stmt:rows()) do
    local data = ""
    for _, v in ipairs(row) do
        data = data .. v .. "\t"
    end
    print(data)
end
print()

-- update data
print("Update table T1.C2 * 2 where C1 > 2")
local upd = assert(con:execdirect("update T1 set C2 = C2 * 2 where C1 > 2"))

-- fetch() to get data"
print("Get table T1 data with fetch()")
print(col)
stmt = assert(con:execdirect("select * from T1"))
row = assert(stmt:fetch())
while row do
    local data = ""
    for _, v in ipairs(row) do
        data = data .. v .. "\t"
    end
    print(data)
    
    row = stmt:fetch()
end
print()

-- get sqlcount
print(assert(upd:rowcount()), "rows updated")
print()

-- delete data
print("Delete table T1.C2 where C1 <= 2")
local del = assert(con:execdirect("delete from T1 where C1 <= 2"))

-- fetch(true) to get data
print("Get table T1 data with fetch(false)")
print(col)
stmt = assert(con:execdirect("select * from T1"))
row = assert(stmt:fetch(true))
col_names = assert(stmt:columns())
while row do
    local data = ""
    for i = 1, #col_names do
        data = data .. row[col_names[i]] .. "\t"
    end
    print(data)
    
    row = stmt:fetch(true)
end
print()

-- get sqlcount
print(assert(del:rowcount()), "rows deleted")
print()

-- drop table
print("Drop table T1")
assert(con:execdirect("drop table T1"))

-- commit
assert(con:commit())

-- rollback
assert(con:rollback())

-- close connection
print("Disconnect db")
assert(con:close())
