local dmdbi = require "dmdbi"
local tb = "py_transact"
local field1 = "c1 int"
local field2 = "c2 char(6)"

-- connect db
local con = assert(dmdbi.New("DBSAMPLE5", "SYSADM", ""))
print "Connected to DB..."

-- create table
assert(con:execdirect(string.format("drop table %s", tb)))
assert(con:execdirect(string.format("create table %s(%s, %s)", tb, field1, field2)))

-- set autocommit off
assert(con:autocommit(false))
print "modify AUTOCOMMIT to OFF"

-- insert 10 data
print "begin a transaction to insert data"
print "insert data..."

-- create cursor
local cursor = assert(con:prepare(string.format("insert into %s values(?, ?)", tb)))
for i = 0, 9 do
    assert(cursor:execute(i, tostring(i)))
end

-- commit and set autocommit on
assert(con:commit())
assert(con:autocommit(true))

print "commit and finish a transaction"
print "modify AUTOCOMMIT to ON"

local function print_table(line)
    local exec = assert(con:execdirect(string.format("select * from %s", tb)))
    
    -- get column name
    local col_names = assert(exec:columns())
    local col = ""
    for _, v in ipairs(col_names) do
        col = col .. v .. "\t"
    end
    print(col)
    
    local cnt = 1
    local result = exec:fetch()
    while result do
        for _, v in ipairs(result) do
            io.write(v.."\t")
        end
        print()
        
        if cnt == 4 then print() end
        if not line and cnt == 9 then
            print()
        end
    
        result = exec:fetch()
        cnt = cnt + 1
    end
    
end

-- select data
print 'data in table:'
print_table()

-- update data
print()
print "update data to set c1=0 if c1>5"
assert(con:execdirect(string.format("update %s set c1 = 0 where c1 > 5", tb)))
print_table()

-- delete data
print()
print "delete data where c1=0"
assert(con:execdirect(string.format("delete from %s where c1 = 0", tb)))
print_table(true)

-- drop table
assert(con:execdirect(string.format("drop table %s", tb)))

-- disconnect db
print "Disconnect to DB"
con:close()