local dmdbi = require 'dmdbi'
local con = assert(dmdbi.New("DBSAMPLE5", "SYSADM", ""))
local tb = 'py_test'
local field1 = 'c1 timestamp'

-- show how to use connection handle method 'datetimeformat'

-- create table
assert(con:execdirect(string.format("drop table %s", tb)))
assert(con:execdirect(string.format("create table %s(%s)", tb, field1)))

print(string.format("insert data into %s(%s)", tb, field1))
print "insert now()"
local cursor = assert(con:prepare(string.format("insert into %s values(?)", tb)))
assert(cursor:execute(os.date()))

print "... insert an integer - 1234567"
assert(cursor:execute(1234567))

print "... insert a string - '1998/10/1 8:59:30'"
assert(cursor:execute('1998/10/1 8:59:30.000 PM'))

print()
print "Show the result"

local exec = assert(con:execdirect(string.format("select * from %s", tb)))

-- print column names
local col_names = assert(exec:columns())
local col = ""
for _, v in ipairs(col_names) do
    col = col .. v .. "\t"
end
print(col)

local row = nil
for row in assert(exec:rows()) do
    local data = ""
    for _, v in ipairs(row) do
        data = data .. v .. "\t"
    end
    print(data)
end

print()
print ("Timezone:", os.date('%z'))
