local dmdbi = require 'dmdbi'
local con = assert(dmdbi.New("DBSAMPLE5", "SYSADM", ""))

-- show how to use connection handle method "cursor"

print "Try how many Corsor objects can DBMaster create ..."

local tb = {}
local cnt1, cnt2

local function create_cursor()
    while true do
        local cursor = con:prepare("select 1")
        
        if cursor then
            table.insert(tb, cursor)
        else
            break
        end
    end
end

local function free_cursor()
    for k in ipairs(tb) do
        assert(tb[k]:close())
        tb[k] = nil
    end
end

create_cursor()
cnt1 = #tb

print ("(1) The maximum number of DBMaster cursors is ", cnt1)
print "Free all Cursors created ..."
free_cursor()

print "Second round ..."
create_cursor()
cnt2 = #tb

print ("(2) The maximum number of DBMaster cursors is", cnt2)
print "Free all Cursors created ..."
free_cursor()

if cnt1 ~= cnt2 then
    print "Not all Cursors createed are released successfully!!"
else
    print "All Cursors created can be released successfully."
end
print()

-- show how to use cursor handle method "getcursorname" & "setcursorname"

print "Try to get and set Cursor's name ..."
local cursor = assert(con:prepare("select 1"))
--show the cursorname now
local str = assert(cursor:getcursorname())
print("cursorname =", str)

-- modify the cursorname
assert(cursor:setcursorname("cursor_now"))
str = assert(cursor:getcursorname())
print("cursorname after modified =", str)
assert(cursor:close())
print()

-- show how to use 2 cursor to handle "update" & "delete" data

print 'Use 2 cursor to handle "update" & "delete" data'
print "Create table: py_cursor"
local d = con:execdirect("drop table py_cursor")
assert(con:execdirect("create table py_cursor(c1 int, c2 varchar(20))"))

print "Insert data into py_cursor"
cursor = assert(con:prepare("insert into py_cursor values(?, ?)"))
for i = 0, 9 do
    assert(cursor:execute(i, 'test cursor'))
end
assert(cursor:close())

print "show data before update & delete"
local function print_table()
    print "c1              c2"
    print "==     ===================="
    cursor = assert(con:execdirect("select * from py_cursor"))
    for row in assert(cursor:rows()) do
        local data = ""
        for _, v in ipairs(row) do
            data = data .. v .. "\t"
        end
        print(data)    
    end
    print()
    assert(cursor:close())
end
print_table()

cursor = assert(con:prepare("select * from py_cursor for update"))
str = assert(cursor:getcursorname())
assert(cursor:execute())

local cur1 = assert(con:prepare(string.format("update py_cursor set c2 = ? where current of %s", str)))
local cur2 = assert(con:prepare(string.format("delete from py_cursor where current of %s", str)))

while true do
    local buf = cursor:fetch()
    if not buf then
        break
    end
    if buf[1] % 2 == 0 then
        assert(cur1:execute("***"..buf[2].."***"))
    else
        assert(cur2:execute())
    end
end

print "show data after update & delete"
print_table()
assert(con:execdirect("drop table py_cursor"))
