local dmdbi = require 'dmdbi'
-- connect db
local con = assert(dmdbi.New("DBSAMPLE5", "SYSADM", ""))

-- show systable information

-- create cursor
local cursor = assert(con:prepare("select TABLE_NAME, TABLE_TYPE, REMARKS from SYSTABLE"))
assert(cursor:execute())

-- trim tail
local function trim(str)
    str = string.gsub(str, "%s+", "")
    return str
end

-- print column names
print "all tables belong to owner SYSADM"
local col_names = assert(cursor:columns())
local col = ""
for _, v in ipairs(col_names) do
    col = col .. v .. "\t"
end
print(col)

-- print data
local row = cursor:fetch()
while row do
    local data = ""
    for _, v in ipairs(row) do
        data = data .. trim(v) .. "\t\t"
    end
    print(data)
    
    row = cursor:fetch()
end
print()

-- show syscolumn information

cursor = assert(con:prepare("select TABLE_NAME, COLUMN_NAME, TYPE_NAME from SYSCOLUMN"))
assert(cursor:execute())

-- print column names
print "columns in all table belong to owner SYSADM"
col_names = assert(cursor:columns())
col = ""
for _, v in ipairs(col_names) do
    col = col .. v .. "\t"
end
print(col)

-- print data
row = cursor:fetch()
while row do
    local data = ""
    for _, v in ipairs(row) do
        data = data .. trim(v) .. "\t\t"
    end
    print(data)
    
    row = cursor:fetch()
end
print()

-- show sysprocinfo information

cursor = assert(con:prepare("select NAME, NUM_INPUT_PARAMS, NUM_OUTPUT_PARAMS, NUM_RESULT_SETS, PROC_TYPE from SYSPROCINFO"))
assert(cursor:execute())

-- print column names
print "all procedures belong to owner SYSADM"
col_names = assert(cursor:columns())
col = ""
for _, v in ipairs(col_names) do
    col = col .. v .. "\t"
end
print(col)

-- print data
row = cursor:fetch()
while row do
    local data = ""
    for _, v in ipairs(row) do
        data = data .. trim(v) .. "\t\t"
    end
    print(data)
    
    row = cursor:fetch()
end
print()

-- show sysprocinfoparam information

cursor = assert(con:prepare("select PROC_NAME, PARAM_NAME, PARAM_TYPE, DATA_TYPE, TYPE_NAME from SYSPROCPARAM;"))
assert(cursor:execute())

-- print column names
print "all procedurecolumns belong to owner SYSADM"
col_names = assert(cursor:columns())
col = ""
for _, v in ipairs(col_names) do
    col = col .. v .. "\t"
end
print(col)

-- print data
row = cursor:fetch()
while row do
    local data = ""
    for _, v in ipairs(row) do
        data = data .. trim(v) .. "\t\t"
    end
    print(data)
    
    row = cursor:fetch()
end
print()

