/*****************************************************************
 *  Copyright(C) 1995 - 2007 CASEMaker Inc. All rights reserved.
 *
 *  ex_ExecuteParam - show how to insert data with parameters
 *
 *  Descriptor - We will insert data by two methods.
 *               One method is inserting constant data
 *               and another method is inserting data with parameters
 *  Table Name - jdbc_employee
 *  Table Schema - four columns (id int, name char(20), salary float, hired_date date)
 *  Insert data - We will insert 6 tuples into jdbc_employee.
 *                (1, 'Charles Brown', 555.32, '1999/01/01')
 *                (2, 'Bart Simpson', 232555.3332, '1988/01/01')
 *                (3, 'Homer Simpson', 1232555.3332, '1970/01/01')
 *                (4, 'Mickey Mouse', 32322555.3332, '1950/01/01')
 *                (5, 'Donald Duck', 322555.3332, '1960/01/01')
 *                (6, 'Goofy Dog', 44322555.3332, '1983/01/01')
 *  Function =
 *      1. register dbmaster driver
 *      2. connect to database
 *      3. create table jdbc_employee
 *      4. insert constant data into table jdbc_employee
 *      5. insert data into table jdbc_employee with parameters
 *      6. commit work
 *      7. drop table jdbc_employee
 *      8. close statements
 *      9. close connection
 *
 *****************************************************************/
import java.io.*;
import java.sql.*;

public class ex_ExecuteParam {
  /***************************************************************
   *  define static fields
   ***************************************************************/
  private static final String dbUser = "SAMPLEUSER";
  private static final String dbPwd = "";
  private static final String dbSrc = "DBSAMPLE5";

  /***************************************************************
   *  main()
   ***************************************************************/
  public static void main(String argv[]) {

  /***************************************************************
   *  print program title
   ***************************************************************/
  System.out.println("+----------------------------------------------------+\n");
  System.out.println("+---------- ex_ExecuteParam JDBC example ------------+\n");
  System.out.println("+----------------------------------------------------+\n");

  /***************************************************************
   *  register dbmaster driver
   ***************************************************************/
  System.out.println("1. register dbmaster driver \n");
  try {

  String jdbcDriver = "dbmaster.sql.JdbcOdbcDriver";
  Class.forName(jdbcDriver).newInstance();

  /***************************************************************
   *  connect to database
   ***************************************************************/
  System.out.println("2. connect to database \n");
  Connection conn = DriverManager.getConnection("jdbc:dbmaster:"+dbSrc, dbUser, dbPwd);

  /***************************************************************
   *  get a statement object to create table jdbc_employee
   ***************************************************************/
  System.out.println("3. create table jdbc_employee \n");
  Statement stmt = conn.createStatement();
  stmt.executeUpdate("create table jdbc_employee (id int, name char(20), salay float, hired_date date)");

  /***************************************************************
   *  insert constant data into table jdbc_employee
   ***************************************************************/
  System.out.println("4. insert constant data into table jdbc_employee \n");
  System.out.println("   (1) insert tuple (1, 'Charles Brown', 555.32, '1999/01/01') \n");
  stmt.executeUpdate("insert into jdbc_employee values (1, 'Charles Brown', 555.32, '1999/01/01')");
  System.out.println("   (2) insert tuple (2, 'Bart Simpson', 232555.3332, '1988/01/01') \n");
  stmt.executeUpdate("insert into jdbc_employee values (2, 'Bart Simpson', 232555.3332, '1988/01/01')");
  System.out.println("   (3) insert tuple (3, 'Homer Simpson', 1232555.3332, '1970/01/01') \n");
  stmt.executeUpdate("insert into jdbc_employee values (3, 'Homer Simpson', 1232555.3332, '1970/01/01')");
  System.out.println("   -- insert constant data success !! \n");

  /***************************************************************
   *  insert data into table jdbc_employee with parameters
   ***************************************************************/
  System.out.println("5. insert data into table jdbc_employee with parameters \n");
  PreparedStatement pstmt = conn.prepareStatement("insert into jdbc_employee values(?,?,?,?)");

  System.out.println("   (1) insert tuple (4, 'Mickey Mouse', 32322555.3332, '1950/01/01') \n");
  pstmt.setInt(1, 4);
  pstmt.setString(2, "Mickey Mouse");
  pstmt.setFloat(3, (float)32322555.3332);
  // insert date = 1950-01-01
  Date date_object = new Date(50, 0, 1);
  pstmt.setDate(4, date_object);
  pstmt.executeUpdate();

  System.out.println("   (2) insert tuple (5, 'Donald Duck', 322555.3332, '1960/01/01') \n");
  pstmt.setInt(1, 5);
  pstmt.setString(2, "Donald Duck");
  pstmt.setFloat(3, (float)322555.3332);
  // insert date = 1960-01-01
  date_object = new Date(60, 0, 1);
  pstmt.setDate(4, date_object);
  pstmt.executeUpdate();

  System.out.println("   (3) insert tuple (6, 'Goofy Dog', 44322555.3332, '1983/01/01') \n");
  pstmt.setInt(1, 6);
  pstmt.setString(2, "Goofy Dog");
  pstmt.setFloat(3, (float)44322555.3332);
  // insert date = 1983-01-01
  date_object = new Date(83, 0, 1);
  pstmt.setDate(4, date_object);
  pstmt.executeUpdate();

  System.out.println("   -- insert data with parameters success !! \n");

  /***************************************************************
   *  commit work
   ***************************************************************/
  System.out.println("6. commit work \n");
  conn.commit();

  /***************************************************************
   *  drop table jdbc_employee
   ***************************************************************/
  System.out.println("7. drop table jdbc_employee \n");
  stmt.executeUpdate("drop table jdbc_employee");

  /***************************************************************
   *  close statements
   ***************************************************************/
  System.out.println("8. close statements \n");
  stmt.close();
  pstmt.close();

  /***************************************************************
   *  close connection
   ***************************************************************/
  System.out.println("9. close connection \n");
  conn.close();

  /***************************************************************
   *  map "try {" of register driver
   ***************************************************************/
  } catch( Exception ex )
    {
    System.out.println(ex.getMessage());
    ex.printStackTrace();
    }

  /***************************************************************
   *  print program end title
   ***************************************************************/
  System.out.println("+----------------------------------------------------+\n");
  System.out.println("+------------- END of ex_ExecuteParam ---------------+\n");
  System.out.println("+----------------------------------------------------+\n");


 }  /* end of main() */
}   /* end of class */