/**
 *
 * Driver class: The driver class for the DBMaster database is dbmaster.sql.type4.Driver.
 *
 * JDBC URL format:
 *     jdbc:dbmaster:type4://host:port/database
 * 	   jdbc:dbmaster:type4://host:port/database;user=userName&password=password
 *     jdbc:dbmaster:type4://host:port/database;errlcode=ZH_TW.BIG5;atcmt=0;ctimo=10;strsz=600;strop=0;dscmt=1;ltimo=10;netzc=1
 *                  errlcode:  set client's error message character set,refer to the DB_ERRLCODE
 *                  atcmt: set the auto-commit mode,refer to the DB_ATCMT
 *                  ctimo: set the connection time-out value,refer to the DB_CTIMO
 *                  strsz: set the length of returned data of STRING type,refer to the DB_STRSZ
 *                  strop: set the space padding,refer to the DB_STROP
 *                  dscmt: set whether to issue a commit before disconnecting from the database,refer to the DB_DSCMT
 *                  ltimo: set the idle timeout interval,refer to the DB_LTIMO
 *                  netzc: set the data compression when deliver data between server and client,refer to the DB_NETZC
 *
 * Connection URL:  The connection URL for the dbmaster database is jdbc:dbmaster:type4://localhost:2453/dbsample5
 *                  jdbc:dbmaster:type4 is a fixed format for jdbc driver type 4
 * 				    localhost is the server name on which dbmaster is running, we may also use IP address
 * 				    2453 is the port number
 * 				    dbsample5 is the database name
 * 				    sysadm is the default username for the dbmaster database
 * 				    Password: It is the password given by the user at the time of installing the dbmaster database
 *
 * Sample Output:
 * 		DBMaster JDBC Driver Registered...
 * 		Connection successfully established...
 *
 * 		123 Kaly Beijing
 * 		122 Rahul Shanghai
 */
import java.sql.Connection;
import java.sql.DriverManager;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.sql.Statement;

public class JdbcType4Example {

	public static void main(String[] args) {

		Connection connection = null;

		try {
			Class.forName("dbmaster.sql.type4.Driver");
			System.out.println("DBMaster JDBC Driver Registered...");
		} catch (ClassNotFoundException e) {
			System.out.println("DBMaster JDBC Driver not found");
			e.printStackTrace();
			return;
		}

		try {
			connection = DriverManager
					.getConnection("jdbc:dbmaster:type4://localhost:2453/dbsample5", "sysadm", "");
			System.out.println( "Connection successfully established...\n" );

		} catch (SQLException e) {
			System.out.println("Not connected to the database schema, please check username/password");
			e.printStackTrace();
			return;
		}

		if (connection != null) {
			try {
				Statement statement = connection.createStatement();

				statement.executeUpdate( "insert into sample.employee( id, Name, Address ) values( 122, 'Rahul', 'Shanghai' )" );

				ResultSet resultSet = statement.executeQuery("select id, Name, Address from sample.employee order by ID Desc");
				while (resultSet.next()) {
					int id = resultSet.getInt("id");
					String firstName = resultSet.getString("name");
					String addRess = resultSet.getString("address");

					System.out.println(id + " " + firstName + " " + addRess);
				}

				resultSet.close();
				statement.close();

			} catch (SQLException e) {
				System.out.println("Exception while creating statement");
				e.printStackTrace();
			}

			try {
				connection.close();
			} catch (SQLException sqle) {
				sqle.printStackTrace();
			}
		}
	}

}