/*****************************************************************
 *  Copyright(C) 2011 CASEMaker Inc. All rights reserved.
 *
 *  Employee - show how to insert, select data
 *
 *  Descriptor - This sample demostrates the usage of inserting
 *               data and retrieving data with type 3 client
 *  Table Name - jdbc_employee
 *  Table Schema - four columns (id int, name char(20), salary float, hired_date date)
 *  Insert data - We will insert 6 tuples into jdbc_employee.
 *                (1, 'Charles Brown', 555.32, '1999/01/01')
 *                (2, 'Bart Simpson', 232555.3332, '1988/01/01')
 *                (3, 'Homer Simpson', 1232555.3332, '1970/01/01')
 *                (4, 'Mickey Mouse', 32322555.3332, '1950/01/01')
 *                (5, 'Donald Duck', 322555.3332, '1960/01/01')
 *                (6, 'Goofy Dog', 44322555.3332, '1983/01/01')
 *  Function =
 *      1. register dbmaster driver
 *      2. connect to database
 *      3. create table jdbc_employee
 *      4. insert data into table jdbc_employee
 *      5. select data from table jdbc_employee
 *      6. close statements
 *      7. close connection
 *
 *****************************************************************/
import java.io.*;
import java.sql.*;
import java.util.*;

public class Employee {

  /***************************************************************
   *  main()
   ***************************************************************/
  public static void main(String[] argc)
  {
        Connection con;
        String driver = "dbmaster.jdbc.ws.client.Driver";
        String url = "jdbc:dbmaster:type3://127.0.0.1:8083/DBSAMPLE5";
        ResultSet rs = null;
        DatabaseMetaData dbmd = null;
        String user = "SAMPLEUSER";
        ResultSetMetaData rsmd = null;
        int cols, i;

        System.out.println("+----------------------------------------------------+\n");
        System.out.println("+----------- Employee Type 3 JDBC example -----------+\n");
        System.out.println("+----------------------------------------------------+\n");

        try
	      {
          /***************************************************************
           *  register dbmaster driver
           ***************************************************************/
          System.out.println("1. register dbmaster driver \n");

          Class.forName(driver);
          /***************************************************************
           *  connect dbmaster
           ***************************************************************/
          System.out.println("2. connect to database \n");

          con = DriverManager.getConnection(url, user, "");

          /***************************************************************
           *  get a statement object to create table jdbc_employee
           ***************************************************************/
          System.out.println("3. create table jdbc_employee \n");
          Statement stmt = con.createStatement();
          stmt.executeUpdate("create table jdbc_employee (id int, name char(20), salay float, hired_date date)");

          /***************************************************************
           *  insert records
           ***************************************************************/
          System.out.println("4. insert data into table jdbc_employee \n");

          System.out.println("   (1) insert tuple (1, 'Charles Brown', 555.32, '1999/01/01') \n");
          stmt.executeUpdate("insert into jdbc_employee values (1, 'Charles Brown', 555.32, '1999/01/01')");

          System.out.println("   (2) insert tuple (2, 'Bart Simpson', 232555.3332, '1988/01/01') \n");
          stmt.executeUpdate("insert into jdbc_employee values (2, 'Bart Simpson', 232555.3332, '1988/01/01')");

          System.out.println("   (3) insert tuple (3, 'Homer Simpson', 1232555.3332, '1970/01/01') \n");
          stmt.executeUpdate("insert into jdbc_employee values (3, 'Homer Simpson', 1232555.3332, '1970/01/01')");

          System.out.println("   (4) insert tuple (4, 'Mickey Mouse', 32322555.3332, '1950/01/01') \n");
          stmt.executeUpdate("insert into jdbc_employee values (4, 'Mickey Mouse', 32322555.3332, '1950/01/01')");

          System.out.println("   (5) insert tuple (5, 'Donald Duck', 322555.3332, '1960/01/01') \n");
          stmt.executeUpdate("insert into jdbc_employee values (5, 'Donald Duck', 322555.3332, '1960/01/01')");

          System.out.println("   (6) insert tuple (6, 'Goofy Dog', 44322555.3332, '1983/01/01') \n");
          stmt.executeUpdate("insert into jdbc_employee values (6, 'Goofy Dog', 44322555.3332, '1983/01/01')");

          /***************************************************************
           *  retrieve resultset
           ***************************************************************/
          System.out.println("5. retrieve result from jdbc_employee \n");

          //send sql statement
          rs = stmt.executeQuery("select * from jdbc_employee");

          //show resultset
          rsmd = rs.getMetaData();
          cols = rsmd.getColumnCount();

          //get column name
          for (i = 1; i <= cols; ++i)
            {
                System.out.print(rsmd.getColumnName(i) + '\t');
            }

          System.out.println();

	        //get a tuple
          while(rs.next())
            {
                //get one column in a tuple
                for(i = 1;i <= cols;++i)
                {
                    switch (i)
                    {
                        case 1:
                            System.out.print(String.valueOf(rs.getInt(i)) + '\t');
                            break;
                        case 2:
                            System.out.print(rs.getString(i) + '\t');
                            break;
                        case 3:
                            System.out.print(String.valueOf(rs.getFloat(i)) + '\t');
                            break;
                        case 4:
                            System.out.print(String.valueOf(rs.getDate(i)) + '\t');
                            break;
                        default:
                            System.out.print("warning: wrong column number" + '\t');
                            break;
                    }
                }
                System.out.println();
            }
	        System.out.println();
          rs.close();

          /***************************************************************
           *  drop table ,close statement and connection
           ***************************************************************/
          System.out.println("6. drop table jdbc_employee \n");

          stmt.executeUpdate("drop table jdbc_employee");

          System.out.println("7. close statement \n");
          stmt.close();

          System.out.println("8. close connection \n");
          con.close();
        }

        /***************************************************************
         *  map "try {" of register driver
         ***************************************************************/
        catch (Exception ex){
            System.out.println(ex.getMessage());
            ex.printStackTrace();
        }
      /***************************************************************
       *  print program end title
       ***************************************************************/
      System.out.println("+----------------------------------------------------+\n");
      System.out.println("+------------- END of Employee ----------------------+\n");
      System.out.println("+----------------------------------------------------+\n");

  }//end of main

}//end of class
