/**************************************************
 * Demonstrate Case of Text Index with Order By
 **************************************************/
set workdir 'd:\release\workspace';
set printto '04out.txt';

connect to DBSAMPLE5 'SAMPLEUSER';

//initial base data
drop table fulltext.orderby1;
create table fulltext.orderby1 (c1 char(10),c2 varchar(50),c3 long varchar,c4 serial,c5 int,c6 date,
              c7 time,c8 timestamp);
insert into fulltext.orderby1 values(?,?,?,?,?,?,?,?);
   'aa 1 x','i O īG','i am @  apple',1,6,'1998/5/14','10:10:10','2001/1/1 10:10:10 PM';
   'bb 1 x','i O ','i am @  book',3,2,'1997/4/30','11:20:20','2001/1/1 9:5:4 AM';
   'cc 1 x','i O ','i am @  cat',2,2,'1998/1/1','15:00:01','1990/2/2 3:3:3 AM';
   'dd 2 x','you O Ѯ','you are @ i desk',5,3,'1990/2/2','18:00:02','2002/1/1 2:2:2 PM';
   'ee 2 x','you O jH','you are @ Y elephant',4,5,'2000/1/1','12:12:12','1998/1/1 1:1:1 PM';
   'ff 2 x','you O ','you are @  flower',6,4,'2001/1/1','2:2:2','1995/5/5 5:5:5 AM';
   end;
//********************************
// demonstrate Text Index with order by
//   demonstrate create text index
//     demonstrate order by column type
//********************************

create text index tidx1 on fulltext.orderby1 (c1) order by c1;
create text index tidx2 on fulltext.orderby1 (c1) order by c2;
create text index tidx3 on fulltext.orderby1 (c1) order by c3;
//ERROR (6169): [DBMaster] cannot to sort on a non-ordered data type

//********************************
// demonstrate Text Index with order by
//   demonstrate create text index
//     demonstrate order by asc
//********************************

create text index ascidx1 on fulltext.orderby1 (c1) order by c4 asc;
create text index ascidx2 on fulltext.orderby1 (c1) order by c5 asc;
create text index ascidx3 on fulltext.orderby1 (c1) order by c6 asc;
create text index ascidx4 on fulltext.orderby1 (c2) order by c7 asc;
create text index ascidx5 on fulltext.orderby1 (c3) order by c8 asc;

select c1,c4 from fulltext.orderby1(text index ascidx1) where c1 match '1 & x';
select c1,c4 from fulltext.orderby1(text index ascidx1) where c1 match '1 | 2';

select c1,c5 from fulltext.orderby1(text index ascidx2) where c1 match '1 & x';
select c1,c5 from fulltext.orderby1(text index ascidx2) where c1 match '1 | 2';

select c1,c6 from fulltext.orderby1(text index ascidx3) where c1 match '1 & x';
select c1,c6 from fulltext.orderby1(text index ascidx3) where c1 match '1 | 2';

select c2,c7 from fulltext.orderby1 where c2 match 'i & O';
select c2,c7 from fulltext.orderby1 where c2 match 'i | you';

select c3,c8 from fulltext.orderby1 where c3 match 'i & @';
select c3,c8 from fulltext.orderby1 where c3 match 'i | you';


//********************************
// demonstrate Text Index with order by
//   demonstrate create text index
//     demonstrate order by desc
//********************************

create text index descidx1 on fulltext.orderby1 (c1) order by c4 desc;
create text index descidx2 on fulltext.orderby1 (c1) order by c5 desc;
create text index descidx3 on fulltext.orderby1 (c1) order by c6 desc;
create text index descidx4 on fulltext.orderby1 (c2) order by c7 desc;
create text index descidx5 on fulltext.orderby1 (c3) order by c8 desc;

select c1,c4 from fulltext.orderby1(text index descidx1) where c1 match '1 & x';
select c1,c4 from fulltext.orderby1(text index descidx1) where c1 match '1 | 2';

select c1,c5 from fulltext.orderby1(text index descidx2) where c1 match '1 & x';
select c1,c5 from fulltext.orderby1(text index descidx2) where c1 match '1 | 2';

select c1,c6 from fulltext.orderby1(text index descidx3) where c1 match '1 & x';
select c1,c6 from fulltext.orderby1(text index descidx3) where c1 match '1 | 2';

select c2,c7 from fulltext.orderby1(text index descidx4) where c2 match 'i & O';
select c2,c7 from fulltext.orderby1(text index descidx4) where c2 match 'i | you';

select c3,c8 from fulltext.orderby1(text index descidx5) where c3 match 'i & @';
select c3,c8 from fulltext.orderby1(text index descidx5) where c3 match 'i | you';



//********************************
// demonstrate Text Index with order by
//   demonstrate create text index
//     demonstrate drop order by column
//********************************

//alter table fulltext.orderby1 drop c6;
//select c1,c6 from fulltext.orderby1(text index ascidx3) where c1 match '1 & x';
//select c1,c6 from fulltext.orderby1(text index descidx3) where c1 match '1 & x';

drop table fulltext.orderby2;
create table fulltext.orderby2(c1 char(20),c2 time) ;
insert into fulltext.orderby2 values('1a B c','10:00:00');
insert into fulltext.orderby2 values('2a B c','09:59:59');
insert into fulltext.orderby2 values('3a B c','10:00:01');
create text index tidx1 on fulltext.orderby2 (c1) order by c2 desc;
select * from fulltext.orderby2(text index tidx1) where c1 match 'B';
alter table fulltext.orderby2 drop c2;
//MR5214 should 3 rows selected
def table fulltext.orderby2;
select * from fulltext.orderby2(text index tidx1) where c1 match 'B';
alter table fulltext.orderby2 add c2 time;
select * from fulltext.orderby2;

//********************************
// demonstrate Text Index with order by
//   demonstrate create text index
//     demonstrate rebuild text index-->doesn't support rebuild
//********************************

insert into fulltext.orderby1 values(?,?,?,?,?,?,?,?);
   'gg 1 x','i O Ml','i am @  glass',8,7,'1997/5/14','8:10:10','2001/12/31 10:10:10 PM';
   'hh 1 x','i O Фl','i am @  house',7,8,'1996/5/14','5:10:10','2000/1/1 10:10:10 PM';
   end;

rebuild text index tidx1 for fulltext.orderby1;
select c1,c4 from fulltext.orderby1 where c1 match '1 | 2';
select c1,c4 from fulltext.orderby1(text index tidx1) where c1 match '1 | 2';
drop text index tidx1 from fulltext.orderby1;
create text index tidx1 on fulltext.orderby1(c1) order by c4;
set dump plan on;
//6 rows selected; since Text Index Scan on tidx2(c1)
select c1,c4 from fulltext.orderby1 where c1 match '1 | 2';
//8 rows selected; since Text Index Scan on tidx1(c1)
select c1,c4 from fulltext.orderby1(text index tidx1) where c1 match '1 | 2';
set dump plan off;


//*************************************
// demonstrate Text Index with order by
//   demonstrate select ... order by
//     demonstrate create ..... order by
//*************************************

drop table fulltext.orderby3;
create table fulltext.orderby3(c1 varchar(20),c2 int,c3 int);
insert into fulltext.orderby3 values(?,?,?);
'1a xx',3,5;
'2b xx',2,5;
'3c xx',1,5;
'4d xx',4,5;
'5e xx',2,6;
'6f xx',2,2;
end;
create text index tidx1 on fulltext.orderby3(c1) order by c2 asc;
create text index tidx2 on fulltext.orderby3(c1) order by c2 desc;
select * from fulltext.orderby3(text index tidx1) where c1 match 'xx' order by c3 asc;
select * from fulltext.orderby3(text index tidx1) where c1 match 'xx' order by c3 desc;
select * from fulltext.orderby3(text index tidx2) where c1 match 'xx' order by c3 asc;
select * from fulltext.orderby3(text index tidx2) where c1 match 'xx' order by c3 desc;


//***************************************
// demonstrate Text Index with order by
//   demonstrate select ... order by
//     demonstrate create .....without order by
//***************************************

create text index nidx on fulltext.orderby1 (c1);
select c1,c5,c6 from fulltext.orderby1(text index nidx) where c1 match '1 | 2' order by c6 asc;
select c1,c5,c6 from fulltext.orderby1(text index nidx) where c1 match '1 | 2' order by c6 desc;


//********************************
// demonstrate Text Index with order by
//   demonstrate unload table 
//********************************
def table fulltext.orderby1;
unload table from fulltext.orderby1 to orderby1;
drop table fulltext.orderby1;

load table from orderby1;
def table fulltext.orderby1;
select c1,c5 from fulltext.orderby1(text index nidx) where c1 match '1 | 2';

drop table fulltext.orderby1;
drop table fulltext.orderby2;
drop table fulltext.orderby3;

set printto off;
disconnect;
q;