/**************************************************
 * Demonstrate Case of Text Index with fuzzy search
 **************************************************/
set workdir 'd:\release\workspace';
set printto 03out.txt;

connect to DBSAMPLE5 'SAMPLEUSER';

drop table fulltext.textfile;
create table fulltext.textfile(id integer,con long varchar);
insert into fulltext.textfile values(1,'DBMaster is a powerful Database');
insert into fulltext.textfile values(2,'DBMaster is a powerful and flexible SQL Database');
insert into fulltext.textfile values(3,'DBMaster is a powerful and flexible SQL Database Management System (DBMS)');
insert into fulltext.textfile values(4,'DBMaster is a powerful and flexible SQL Database that provides excellent text index mechanism');
insert into fulltext.textfile values(5,'DBMaster supports a Java Database Connectivity compliant interface');
insert into fulltext.textfile values(6,'compliant interface and DBMaster COBOL interface (DCI)');
insert into fulltext.textfile values(7,'compliant interface and DBMaster COBOL interface (DCI)');

create text index idx_textfile_con on fulltext.textfile(con);

set blobwidth 128;
select * from fulltext.textfile;
/*
FUZZY SEARCH:
A phrase led by a '?' (Question mark) will be evaluated as a fuzzy expression, 
e.g. '?intel pentium'. Words used for a search in a fuzzy expression can be separated 
by up to four words in the target text. For example, '?intel pentium' will find 
'Intel will release its 1GHz Pentium III processor', and '?amd k7 athlon' will find 
'AMD has renamed its K7 processor as Athlon'.
A number of words in the query may be missing from the result set. For example 
'?William Jeffery Clinton' can find 'William Clinton' and 'William J Clinton', 
but the first word of the query must appear; the query '?William Clinton' will not 
find 'Bill Clinton'.
*/
select id from fulltext.textfile where con MATCH '?A SQL & ?text index';
select id from fulltext.textfile where con MATCH '(?dbmaster)  & (? text index)';
select id from fulltext.textfile where con MATCH '?database  | text index';
select id from fulltext.textfile where con MATCH 'POWERFUL  | ? SYSTEM';
select id from fulltext.textfile where con MATCH '?a java database';
select id from fulltext.textfile where con MATCH '? java database';

/*
NEAR LOGIC FULL-TEXT SEARCH
A phrase led by a '~'(tilde mark) will be evaluated as a near expression. 
It ensures that all words in the query string appear in the text. For example, 
'~amd sales 1ghz athlon' will find 'AMD announced quarterly sales of its 1ghz Athlon chip', 
but not, 'AMD announced quarterly sales of its Athlon chip'.
*/
select * from fulltext.textfile where con MATCH '~interface dbmaster cobol';
select * from fulltext.textfile where con MATCH '?interface dbmaster cobol';

drop table fulltext.textfile;

set printto off;
disconnect;
q;