/****************************************************************************
 *  Copyright(C) 1997 - 2007 CaseMaker Inc. All rights reserved.
 *
 *	03blob.ec:
 *      This sample is mainly concerned about BLOB related ESQL.
 *       1. put BLOB "logo.bmp" into sample.Card table as the fifth row.
 *       2. get BLOBs from sample.Card table, save as files "BMP*.BMP".
 *
 *	Referenced Table:
 *		sample.Card(id integer,fname varchar(30),lname varchar(30)
 *				title varchar(30), photo long varbinary)
 *
 ****************************************************************************/


#include <stdio.h>
#include <string.h>

EXEC SQL include sqlca;
EXEC SQL include dbenvca;
EXEC SQL include sqlda;
#define STRING_LEN 1024
#define MAX_BUF_SIZE 2048

#define chkErr() \
        { \
        if (SQLCODE && SQLCODE != SQL_NO_DATA_FOUND) \
           { \
           if (SQLCODE == SQL_SUCCESS_WITH_INFO) \
              printf("WARN(%d):%s\n", sqlca.sqlerrd[0], sqlca.sqlerrmc); \
           else \
              { \
              printf("ERR(%d):%s\n", sqlca.sqlerrd[0], sqlca.sqlerrmc); \
              } \
           } \
        }

void demo_put_blob(int index, char *fname);
void demo_get_blob();

int main()
{
   EXEC SQL begin declare section;
   char user[8], passwd[8];           /* connection information         */
   char dbname[18];                   /* char type is fix length string */
   EXEC SQL end declare section;

   strcpy(dbname, "DBSAMPLE5");          /* get db,user,password info */
   strcpy(user, "SYSADM");
   strcpy(passwd, "");
 
   /* you can also directly type EXEC SQL connect to db_name user_id passwd */
   EXEC SQL connect to :dbname :user :passwd;

   printf("This is a sample program which inserts blob file 'logo.bmp' into photo\n");
   printf("column of Card table OF DBSAMPLE5 database.\n");
   printf("We then retrive all the blob out and save them as bitmap files named \n");
   printf("from BMP1.BMP to BMP8.BMP.\n");
   printf("<<< demo_put_blob >>>\n");
   demo_put_blob(100, "logo.bmp");
   printf("\n");
   printf("<<< demo_get_blob >>>\n");
   demo_get_blob();
   EXEC SQL delete from sample.Card where ID = 100;
   EXEC SQL commit work;

   EXEC SQL disconnect;
   if (SQLCODE)
      printf("ERR(%d):%s\n", sqlca.sqlerrd[0], sqlca.sqlerrmc);    
   return 0;
}

void demo_put_blob(int index, char * fname)
{
   EXEC SQL begin declare section;
      int ID;
      longvarbinary photo;
   EXEC SQL end declare section;
   FILE *stream;
   int numread;
   long count=0, delay;
   char buf[MAX_BUF_SIZE];

   if( (stream  = fopen( fname, "rb" )) == NULL )
   {
      printf( "The file '%s' was not opened\n", fname );   
      exit(0);
   }

   /* Prepare an ESQL statement and declare the BLOB host variable as 
      a question mark, to indicate that this BLOB host variable will 
      be bound later                                                  */
   EXEC SQL prepare stmt from "INSERT INTO sample.Card (ID, photo) VALUES (:ID, ?)";
   chkErr();
   ID=index;
   photo.buf = buf;
   photo.bufsize = STRING_LEN;      

   /* Execute this ESQL statement */
   EXEC SQL execute stmt;
   chkErr();

   /* Declare when to begin to put the BLOB */
   EXEC SQL begin put blob for stmt;     
   chkErr();
   do {
      numread = fread( buf, sizeof( char ), STRING_LEN, stream );
      photo.buf = buf;
      photo.bufsize=numread;      
      /* Define which BLOB variable to use for putting the BLOB and filling 
         the information of the bufsize and bufptr. */
      EXEC SQL put blob for stmt using :photo;
      chkErr();
      count += numread;
      printf("\r%ld         ", count);
      fflush(stdout);
      for (delay=0; delay<100000; delay++)
        fflush(stdout);
   } while (STRING_LEN == numread);

   /* Declare PUT BLOB operation is finished. */
   EXEC SQL end put blob for stmt;
   chkErr();
   printf("done.         \n");

   if( fclose( stream ) )
      printf( "The file '%s' was not closed\n", fname );
}

void demo_get_blob()
{
   EXEC SQL begin declare section;
      int ID;
      longvarbinary photo;
      SQLLEN i_photo;
      int nCol;      
   EXEC SQL end declare section;
   char fname[20];
   FILE *stream;
   int numwritten;
   char buf[MAX_BUF_SIZE];

   /* Prepare an ESQL statement and declare the BLOB host variable as 
      a question mark. */
   EXEC SQL prepare stmt from "select ID, photo from sample.Card into :ID, ?";
   chkErr();
   
   /* Declare a cursor for a prepared statement */
   EXEC SQL declare demo_cursor cursor for stmt;
   chkErr();

   /* Open the cursor */
   EXEC SQL open demo_cursor;
   chkErr();
   nCol = 2; 
   photo.bufsize = MAX_BUF_SIZE;
   photo.buf = buf;

   while (1)
   {
     /* Fetch the cursor */
     EXEC SQL fetch demo_cursor into :ID, ?;
     chkErr();
     if (SQLCODE)
     {
       if (SQLWARN0 != 'W')
         break;
     }

     printf("ID = %d\n", ID);

     sprintf(fname, "BMP%d.BMP", ID);
     if( (stream  = fopen( fname, "w+b" )) == NULL )
       printf( "The file '%s' was not opened\n", fname );   

     while(1)
     {
       /* Define the column number in the BLOB host variable and the 
          available buffer size and valid buffer pointer */
       EXEC SQL get blob column :nCol for stmt using :photo :i_photo;
       if (SQLCODE == SQL_NO_DATA_FOUND)
         break;
       else if(i_photo<=0)
       	 break;
       else 
         numwritten = fwrite( photo.buf, sizeof( char ), (i_photo<MAX_BUF_SIZE)?i_photo: MAX_BUF_SIZE, stream );
     }

     if( fclose( stream ) )
       printf( "The file '%s' was not closed\n", fname );
   }
   /* Close the curosr. */
   EXEC SQL close demo_cursor;
   chkErr();
}
