/****************************************************************************
 *  Copyright(C) 1997 - 2007 CaseMaker Inc. All rights reserved.
 *
 *	02cursor.ec:
 *      This sample is mainly concerned of cursor.
 *  	1. declare, open, close
 *  	2. select cursor with fetch next only
 *  	3. select scroll cursor with fetch next, previous, last, first, 
 *      	relative n, absolute n
 *   	4. updateble cursor for update, and delete
 *
 *	Referenced Table: 
 *		sample.Card(id integer,fname varchar(30),lname varchar(30)
 *				title varchar(30), photo long varbinary)
 *
 ****************************************************************************/


EXEC SQL include sqlca;
EXEC SQL include dbenvca;

#define chkErr() \
        { \
        if (SQLCODE && SQLCODE != SQL_NO_DATA_FOUND) \
           { \
           if (SQLCODE == SQL_SUCCESS_WITH_INFO) \
              printf("WARN(%d):%s\n", sqlca.sqlerrd[0], sqlca.sqlerrmc); \
           else \
              { \
              printf("ERR(%d):%s\n", sqlca.sqlerrd[0], sqlca.sqlerrmc); \
              } \
           } \
        }

void viewcard();
void demo_scroll_cursor();
void demo_update_cursor();
void demo_delete_cursor();

int main()
{
   EXEC SQL begin declare section;
   char user[8], passwd[8];           /* connection information         */
   char dbname[18];                   /* char type is fix length string */
   EXEC SQL end declare section;

   strcpy(dbname, "DBSAMPLE5");          /* get db,user,password info */
   strcpy(user, "SYSADM");
   strcpy(passwd, "");
 
   /* you can also directly type EXEC SQL connect to db_name user_id passwd */
   EXEC SQL connect to :dbname :user :passwd;

   viewcard();
   printf("<<< demo_scroll_cursor >>>\n");
   demo_scroll_cursor();

   printf("<<< demo_update_cursor >>>\n");
   demo_update_cursor(); 
   viewcard();

   printf("<<< demo_delete_cursor >>>\n");
   demo_delete_cursor();
   viewcard();

   EXEC SQL disconnect;
   if (SQLCODE)
      printf("ERR(%d):%s\n", sqlca.sqlerrd[0], sqlca.sqlerrmc);    
   return 0;
}

void viewcard()
{
   EXEC SQL begin declare section;
      int ID;
      char LName[30+1];
      char FName[30+1];
   EXEC SQL end declare section;

   EXEC SQL declare card_cursor cursor for 
            select ID, LName, FName from sample.Card into :ID, :LName, :FName;

   chkErr();
   EXEC SQL open card_cursor;
   chkErr();
   printf("Num   LastName                       FirstName\n");
   printf("===== ============================== ==============================\n");
   while (1)
   {
     EXEC SQL fetch card_cursor;
     if (sqlca.sqlcode == SQL_SUCCESS || 
         sqlca.sqlcode == SQL_SUCCESS_WITH_INFO)
	printf("%5d %-30s %-30s\n", ID, LName, FName);
     else
        break;
   };
   printf("\n");
   EXEC SQL close card_cursor;
   chkErr();
}

void demo_scroll_cursor()
{
   EXEC SQL begin declare section;
      int ID;
      char LName[30+1];
      char FName[30+1];
      SQLLEN indvalue =SQL_NTS;
      int n;
   EXEC SQL end declare section;

   /* Insert a Record */
   printf("insert a record\n");
   EXEC SQL insert into sample.Card (ID, LName, FName) values (100, '007', 'James');
   chkErr();
   EXEC SQL commit work;   
   chkErr();
   viewcard();

   /* Declaring a Cursor */
   EXEC SQL declare scroll_cursor scroll cursor for 
      select ID, LName, FName from sample.Card
      into :ID, :LName :indvalue, :FName :indvalue;
   chkErr();

   /* Opening a Cursor */
   EXEC SQL open scroll_cursor;
   chkErr();

   /* Using a Cursor to Retrieve Data */
   printf("fetch absolute 4 : \n");
   n = 4;
   EXEC SQL fetch absolute :n scroll_cursor;
   chkErr();
   printf("%5d %-30s %-30s\n", ID, LName, FName);

   printf("fetch first : \n");
   EXEC SQL fetch first scroll_cursor;
   chkErr();
   printf("%5d %-30s %-30s\n", ID, LName, FName);

   printf("fetch next : \n");
   EXEC SQL fetch next scroll_cursor;
   chkErr();
   printf("%5d %-30s %-30s\n", ID, LName, FName);

   printf("fetch relative 2 : \n");
   n = 2;
   EXEC SQL fetch relative :n scroll_cursor;
   chkErr();
   printf("%5d %-30s %-30s\n", ID, LName, FName);

   printf("fetch previous : \n");
   EXEC SQL fetch previous scroll_cursor;
   chkErr();
   printf("%5d %-30s %-30s\n", ID, LName, FName);

   printf("fetch last : \n");
   EXEC SQL fetch last scroll_cursor;
   chkErr();
   printf("%5d %-30s %-30s\n", ID, LName, FName);
  
   printf("\n");
   /* Closing the Cursor */
   EXEC SQL close scroll_cursor;
   chkErr();
}


void demo_update_cursor()
{
   EXEC SQL begin declare section;
      int ID;
      char LName[30+1];
      char FName[30+1];
      SQLLEN indvalue =SQL_NTS;
   EXEC SQL end declare section;

   EXEC SQL declare scroll_cursor scroll cursor for 
      select ID, LName, FName from sample.Card
      into :ID, :LName :indvalue, :FName :indvalue
      for update of LName;
   chkErr();

   /* Opening a Cursor */
   EXEC SQL open scroll_cursor;
   chkErr();

   printf("fetch last : \n");
   EXEC SQL fetch last scroll_cursor;
   chkErr();
   printf("%5d %-30s %-30s\n", ID, LName, FName);

   /* Updating Data with a Cursor */
   EXEC SQL set autocommit off;
   printf("update at cursor : \n");
   EXEC SQL update sample.Card set LName = '*007' where current of scroll_cursor;
   chkErr();
   EXEC SQL commit work;
}

void demo_delete_cursor()
{
   EXEC SQL begin declare section;
      int ID;
      char LName[30+1];
      char FName[30+1];
      SQLLEN indvalue =SQL_NTS;
   EXEC SQL end declare section;

   EXEC SQL declare scroll_cursor scroll cursor for 
      select ID, LName, FName from sample.Card
      into :ID, :LName :indvalue, :FName :indvalue
      for update of LName;

   /* Opening a Cursor */
   EXEC SQL open scroll_cursor;
   chkErr();

   printf("fetch last : \n");
   EXEC SQL fetch last scroll_cursor;
   chkErr();
   printf("%5d %-30s %-30s\n", ID, LName, FName);

   /* Deleting Data with a Cursor */
   EXEC SQL set autocommit off;
   printf("delete at cursor : \n");
   EXEC SQL delete from sample.Card where current of scroll_cursor;
   chkErr();
   EXEC SQL commit work;
}
